/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.jaxrs;

import java.net.URI;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.drools.guvnor.server.jaxrs.jaxb.Asset;
import org.drools.guvnor.server.jaxrs.jaxb.AssetMetadata;
import org.drools.guvnor.server.jaxrs.jaxb.AtomAssetMetadata;
import org.drools.guvnor.server.jaxrs.jaxb.AtomPackageMetadata;
import org.drools.guvnor.server.jaxrs.jaxb.Category;
import org.drools.guvnor.server.jaxrs.jaxb.Package;
import org.drools.guvnor.server.jaxrs.jaxb.PackageMetadata;
import org.drools.guvnor.server.jaxrs.providers.atom.Content;
import org.drools.guvnor.server.jaxrs.providers.atom.Entry;
import org.drools.guvnor.server.jaxrs.providers.atom.Link;
import org.drools.guvnor.server.jaxrs.providers.atom.Person;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.ModuleItem;

public class Translator {
    public static final String NS = "";
    public static final QName METADATA = new QName("", "metadata");
    public static final QName VALUE = new QName("", "value");
    public static final QName ARCHIVED = new QName("", "archived");
    public static final QName UUID = new QName("", "uuid");
    public static final QName STATE = new QName("", "state");
    public static final QName FORMAT = new QName("", "format");
    public static final QName CATEGORIES = new QName("", "categories");
    public static final QName VERSION_NUMBER = new QName("", "versionNumber");
    public static final QName CHECKIN_COMMENT = new QName("", "checkinComment");

    public static Category toCategory(CategoryItem categoryItem, UriInfo uriInfo) {
        Category category = new Category();
        category.setPath(categoryItem.getFullPath());
        category.setRefLink(uriInfo.getBaseUriBuilder().path("/categories/{categoryPath}").build(new Object[]{categoryItem.getFullPath()}));
        return category;
    }

    public static Asset toAsset(AssetItem a, UriInfo uriInfo) {
        AssetMetadata metadata = new AssetMetadata();
        metadata.setUuid(a.getUUID());
        metadata.setCreated(a.getCreatedDate().getTime());
        metadata.setDisabled(a.getDisabled());
        metadata.setFormat(a.getFormat());
        metadata.setState(a.getState() == null ? NS : a.getState().getName());
        metadata.setNote("<![CDATA[ " + a.getCheckinComment() + " ]]>");
        metadata.setCheckInComment(a.getCheckinComment());
        metadata.setVersionNumber(a.getVersionNumber());
        List categories = a.getCategories();
        String[] cats = new String[categories.size()];
        int counter = 0;
        for (CategoryItem c : categories) {
            cats[counter++] = c.getName();
        }
        Asset ret = new Asset();
        ret.setTitle(a.getTitle());
        ret.setBinaryContentAttachmentFileName(a.getBinaryContentAttachmentFileName());
        ret.setPublished(a.getLastModified().getTime());
        ret.setAuthor(a.getLastContributor());
        ret.setMetadata(metadata);
        ret.setDescription(a.getDescription());
        ret.setRefLink(uriInfo.getBaseUriBuilder().path("/packages/{packageName}/assets/{assetName}").build(new Object[]{a.getModule().getName(), a.getName()}));
        ret.setBinaryLink(uriInfo.getBaseUriBuilder().path("/packages/{packageName}/assets/{assetName}/binary").build(new Object[]{a.getModule().getName(), a.getName()}));
        ret.setSourceLink(uriInfo.getBaseUriBuilder().path("/packages/{packageName}/assets/{assetName}/source").build(new Object[]{a.getModule().getName(), a.getName()}));
        return ret;
    }

    public static Package toPackage(ModuleItem p, UriInfo uriInfo) {
        PackageMetadata metadata = new PackageMetadata();
        metadata.setUuid(p.getUUID());
        metadata.setCreated(p.getCreatedDate().getTime());
        metadata.setState(p.getState() != null ? p.getState().getName() : NS);
        metadata.setArchived(p.isArchived());
        metadata.setVersionNumber(p.getVersionNumber());
        metadata.setCheckinComment(p.getCheckinComment());
        Package ret = new Package();
        ret.setMetadata(metadata);
        ret.setTitle(p.getTitle());
        ret.setAuthor(p.getLastContributor());
        ret.setPublished(p.getLastModified().getTime());
        ret.setDescription(p.getDescription());
        ret.setBinaryLink(uriInfo.getBaseUriBuilder().path("/packages/{packageName}/binary").build(new Object[]{p.getName()}));
        ret.setSourceLink(uriInfo.getBaseUriBuilder().path("/packages/{packageName}/source").build(new Object[]{p.getName()}));
        Iterator iter = p.getAssets();
        HashSet<URI> assets = new HashSet<URI>();
        while (iter.hasNext()) {
            AssetItem a = (AssetItem)iter.next();
            Asset asset = Translator.toAsset(a, uriInfo);
            assets.add(asset.getRefLink());
        }
        ret.setAssets(assets);
        return ret;
    }

    public static Entry toPackageEntryAbdera(ModuleItem p, UriInfo uriInfo) {
        URI baseUri = p.isHistoricalVersion() ? uriInfo.getBaseUriBuilder().path("packages/{packageName}/versions/{version}").build(new Object[]{p.getName(), Long.toString(p.getVersionNumber())}) : uriInfo.getBaseUriBuilder().path("packages/{packageName}").build(new Object[]{p.getName()});
        Entry e = new Entry();
        e.setTitle(p.getTitle());
        e.setSummary(p.getDescription());
        e.setPublished(new Date(p.getLastModified().getTimeInMillis()));
        e.setBase(baseUri);
        e.getAuthors().add(new Person(p.getLastContributor()));
        e.setId(baseUri);
        Iterator i = p.getAssets();
        while (i.hasNext()) {
            AssetItem item = (AssetItem)i.next();
            Link l = new Link();
            l.setHref(UriBuilder.fromUri((URI)baseUri).path("assets/{assetName}").build(new Object[]{item.getName()}));
            l.setTitle(item.getTitle());
            l.setRel("asset");
            e.getLinks().add(l);
        }
        AtomPackageMetadata metaData = (AtomPackageMetadata)e.getAnyOtherJAXBObject();
        if (metaData == null) {
            metaData = new AtomPackageMetadata();
        }
        metaData.setArchived(p.isArchived());
        metaData.setUuid(p.getUUID());
        metaData.setState(p.getState() == null ? NS : p.getState().getName());
        metaData.setVersionNumber(p.getVersionNumber());
        metaData.setCheckinComment(p.getCheckinComment());
        e.setAnyOtherJAXBObject((Object)metaData);
        Content content = new Content();
        content.setSrc(UriBuilder.fromUri((URI)baseUri).path("binary").build(new Object[0]));
        content.setType(MediaType.APPLICATION_OCTET_STREAM_TYPE);
        e.setContent(content);
        return e;
    }

    public static Entry toAssetEntryAbdera(AssetItem a, UriInfo uriInfo) {
        URI baseUri = a.isHistoricalVersion() ? uriInfo.getBaseUriBuilder().path("packages/{packageName}/assets/{assetName}/versions/{version}").build(new Object[]{a.getModuleName(), a.getName(), Long.toString(a.getVersionNumber())}) : uriInfo.getBaseUriBuilder().path("packages/{packageName}/assets/{assetName}").build(new Object[]{a.getModuleName(), a.getName()});
        Entry e = new Entry();
        e.setTitle(a.getTitle());
        e.setSummary(a.getDescription());
        e.setPublished(new Date(a.getLastModified().getTimeInMillis()));
        e.setBase(baseUri);
        e.getAuthors().add(new Person(a.getLastContributor()));
        e.setId(baseUri);
        try {
            AtomAssetMetadata atomAssetMetadata = (AtomAssetMetadata)e.getAnyOtherJAXBObject(AtomAssetMetadata.class, new Class[0]);
            if (atomAssetMetadata == null) {
                atomAssetMetadata = new AtomAssetMetadata();
            }
            atomAssetMetadata.setArchived(a.isArchived());
            atomAssetMetadata.setUuid(a.getUUID());
            atomAssetMetadata.setState(a.getState() == null ? NS : a.getState().getName());
            atomAssetMetadata.setFormat(a.getFormat());
            atomAssetMetadata.setVersionNumber(a.getVersionNumber());
            atomAssetMetadata.setCheckinComment(a.getCheckinComment());
            String[] categories = new String[a.getCategories().size()];
            int i = 0;
            for (CategoryItem cItem : a.getCategories()) {
                categories[i] = cItem.getName();
                ++i;
            }
            atomAssetMetadata.setCategories(categories);
            e.setAnyOtherJAXBObject((Object)atomAssetMetadata);
        }
        catch (Exception ex) {
            throw new WebServiceException((Throwable)ex);
        }
        Content content = new Content();
        content.setSrc(UriBuilder.fromUri((URI)baseUri).path("binary").build(new Object[0]));
        content.setType(MediaType.APPLICATION_OCTET_STREAM_TYPE);
        e.setContent(content);
        return e;
    }
}

