/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.ruleeditor.springcontext;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SpringContextElementsManager {
    private static final String SPRING_CONTEXT_ELEMENTS_PROPERTIES = "/springContextElements.properties";
    private static SpringContextElementsManager INSTANCE;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();

    private SpringContextElementsManager() throws IOException {
        Properties props = new Properties();
        props.load(this.getClass().getResourceAsStream(SPRING_CONTEXT_ELEMENTS_PROPERTIES));
        this.populateProperties(props.entrySet());
    }

    public static synchronized SpringContextElementsManager getInstance() throws IOException {
        if (INSTANCE == null) {
            INSTANCE = new SpringContextElementsManager();
        }
        return INSTANCE;
    }

    private void populateProperties(Set<Map.Entry<Object, Object>> fileProps) {
        for (Map.Entry<Object, Object> entry : fileProps) {
            String key = entry.getKey().toString().replaceAll("_", " ");
            this.properties.put(key, entry.getValue().toString());
        }
    }

    public Set<String> getElementNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public String getElementValue(String elementName) {
        return this.properties.get(elementName);
    }

    public Map<String, String> getElements() {
        return this.properties;
    }
}

