/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.guvnor.server.security.AdminType;
import org.drools.guvnor.server.security.CategoryPathType;
import org.drools.guvnor.server.security.ModuleNameType;
import org.drools.guvnor.server.security.ModuleUUIDType;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleBasedPermissionManager;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.security.WebDavPackageNameType;
import org.drools.guvnor.server.security.rules.CategoryPathTypePermissionRule;
import org.drools.guvnor.server.security.rules.PackageNameTypeConverter;
import org.drools.guvnor.server.security.rules.PackagePermissionRule;
import org.drools.guvnor.server.security.rules.PackageUUIDTypePermissionRule;
import org.drools.guvnor.server.security.rules.PermissionRule;
import org.drools.guvnor.server.security.rules.PermissionRuleObjectConverter;
import org.drools.guvnor.server.util.LoggingHelper;
import org.jboss.seam.security.permission.PermissionResolver;

@ApplicationScoped
public class RoleBasedPermissionResolver
implements PermissionResolver,
Serializable {
    private static final LoggingHelper log = LoggingHelper.getLogger(RoleBasedPermissionResolver.class);
    private boolean enableRoleBasedAuthorization = false;
    private final Map<Class<?>, PermissionRule> permissionRules = new HashMap();
    private final Map<Class<?>, PermissionRuleObjectConverter> permissionRuleObjectConverters = new HashMap();
    @Inject
    private RoleBasedPermissionManager roleBasedPermissionManager;
    @Inject
    private CategoryPathTypePermissionRule categoryPathTypePermissionRule;
    @Inject
    private PackageUUIDTypePermissionRule packageUUIDTypePermissionRule;
    @Inject
    private PackagePermissionRule packagePermissionRule;
    @Inject
    private PackageNameTypeConverter packageNameTypeConverter;

    @PostConstruct
    public void setupPermissionRules() {
        this.permissionRules.put(CategoryPathType.class, this.categoryPathTypePermissionRule);
        this.permissionRules.put(ModuleUUIDType.class, this.packageUUIDTypePermissionRule);
        this.permissionRules.put(ModuleNameType.class, this.packagePermissionRule);
        this.permissionRules.put(WebDavPackageNameType.class, this.packagePermissionRule);
        this.permissionRuleObjectConverters.put(ModuleNameType.class, this.packageNameTypeConverter);
        this.permissionRuleObjectConverters.put(WebDavPackageNameType.class, this.packageNameTypeConverter);
    }

    public boolean hasPermission(Object requestedObject, String requestedPermission) {
        if (this.isInvalidInstance(requestedObject)) {
            log.debug("Requested permission is not an instance of CategoryPathType|PackageNameType|WebDavPackageNameType|AdminType|PackageUUIDType");
            return false;
        }
        if (!this.enableRoleBasedAuthorization) {
            return true;
        }
        List<RoleBasedPermission> permissions = this.fetchAllRoleBasedPermissionsForCurrentUser();
        boolean hasAdminPermission = this.hasAdminPermission(permissions);
        if (hasAdminPermission || RoleType.ADMIN.getName().equals(requestedPermission)) {
            return hasAdminPermission;
        }
        return this.getPermissionRuleFor(requestedObject).hasPermission(this.convertFor(requestedObject), requestedPermission, permissions);
    }

    private PermissionRule getPermissionRuleFor(Object requestedObject) {
        return this.permissionRules.get(requestedObject.getClass());
    }

    private Object convertFor(Object requestedObject) {
        PermissionRuleObjectConverter permissionRuleObjectConverter = this.permissionRuleObjectConverters.get(requestedObject.getClass());
        return permissionRuleObjectConverter == null ? requestedObject : permissionRuleObjectConverter.convert(requestedObject);
    }

    private List<RoleBasedPermission> fetchAllRoleBasedPermissionsForCurrentUser() {
        return this.roleBasedPermissionManager.getRoleBasedPermission();
    }

    private boolean isInvalidInstance(Object requestedObject) {
        return !(requestedObject instanceof CategoryPathType) && !(requestedObject instanceof ModuleNameType) && !(requestedObject instanceof WebDavPackageNameType) && !(requestedObject instanceof AdminType) && !(requestedObject instanceof ModuleUUIDType);
    }

    private boolean hasAdminPermission(List<RoleBasedPermission> permissions) {
        for (RoleBasedPermission p : permissions) {
            if (!RoleType.ADMIN.getName().equalsIgnoreCase(p.getRole())) continue;
            log.debug("Requested permission: unknown, Permission granted: Yes");
            return true;
        }
        log.debug("Requested permission: admin, Permission granted: No");
        return false;
    }

    public void filterSetByAction(Set<Object> targets, String action) {
    }

    public boolean isEnableRoleBasedAuthorization() {
        return this.enableRoleBasedAuthorization;
    }

    public void setEnableRoleBasedAuthorization(boolean enableRoleBasedAuthorization) {
        this.enableRoleBasedAuthorization = enableRoleBasedAuthorization;
    }
}

