/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class AssetLockManager {
    private static final long LOCK_EXPIRATION_TIME = 1200000L;
    private final Map<String, Lock> map = new HashMap<String, Lock>();

    public boolean isAssetLocked(String uuid) {
        if (this.map.keySet().contains(uuid)) {
            long timeStamp = this.map.get((Object)uuid).timeStamp;
            long currentTime = System.currentTimeMillis();
            if (currentTime - timeStamp > 1200000L) {
                this.map.remove(uuid);
                return false;
            }
            return true;
        }
        return false;
    }

    public String getAssetLockerUserName(String uuid) {
        if (this.isAssetLocked(uuid)) {
            return this.map.get((Object)uuid).userName;
        }
        return null;
    }

    public void lockAsset(String uuid, String userName) {
        this.map.put(uuid, new Lock(userName));
    }

    public void unLockAsset(String uuid) {
        this.map.remove(uuid);
    }

    class Lock {
        final String userName;
        final long timeStamp;

        Lock(String userName) {
            this.userName = userName;
            this.timeStamp = System.currentTimeMillis();
        }
    }
}

