/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.time.SessionClock;
import org.drools.time.TimeUtils;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessCalendarImpl
implements BusinessCalendar {
    private static final Logger logger = LoggerFactory.getLogger(BusinessCalendarImpl.class);
    private Properties businessCalendarConfiguration;
    private int daysPerWeek;
    private int hoursInDay;
    private int startHour;
    private int endHour;
    private String timezone;
    private List<TimePeriod> holidays;
    private List<Integer> weekendDays = new ArrayList<Integer>();
    private SessionClock clock;
    private static final Pattern SIMPLE = Pattern.compile("([+-])?\\s*((\\d+)[Ww])?\\s*((\\d+)[Dd])?\\s*((\\d+)[Hh])?\\s*((\\d+)[Mm])?");
    private static final int SIM_WEEK = 3;
    private static final int SIM_DAY = 5;
    private static final int SIM_HOU = 7;
    private static final int SIM_MIN = 9;
    public static final String DAYS_PER_WEEK = "business.hours.per.week";
    public static final String HOURS_PER_DAY = "business.hours.per.day";
    public static final String START_HOUR = "business.start.hour";
    public static final String END_HOUR = "business.end.hour";
    public static final String HOLIDAYS = "business.holidays";
    public static final String HOLIDAY_DATE_FORMAT = "business.holiday.date.format";
    public static final String WEEKEND_DAYS = "business.weekend.days";
    public static final String TIMEZONE = "business.cal.timezone";
    private static final String DEFAULT_PROPERTIES_NAME = "/jbpm.business.calendar.properties";

    public BusinessCalendarImpl() {
        String propertiesLocation = System.getProperty("jbpm.business.calendar.properties");
        if (propertiesLocation == null) {
            propertiesLocation = DEFAULT_PROPERTIES_NAME;
        }
        this.businessCalendarConfiguration = new Properties();
        InputStream in = this.getClass().getResourceAsStream(propertiesLocation);
        if (in != null) {
            try {
                this.businessCalendarConfiguration.load(in);
            }
            catch (IOException e) {
                logger.error("Error while loading properties for business calendar", (Throwable)e);
            }
        }
        this.init();
    }

    public BusinessCalendarImpl(Properties configuration) {
        this.businessCalendarConfiguration = configuration;
        this.init();
    }

    public BusinessCalendarImpl(Properties configuration, SessionClock clock) {
        this.businessCalendarConfiguration = configuration;
        this.clock = clock;
        this.init();
    }

    protected void init() {
        if (this.businessCalendarConfiguration == null) {
            throw new IllegalArgumentException("BusinessCalendar configuration was not provided.");
        }
        this.daysPerWeek = this.getPropertyAsInt(DAYS_PER_WEEK, "5");
        this.hoursInDay = this.getPropertyAsInt(HOURS_PER_DAY, "8");
        this.startHour = this.getPropertyAsInt(START_HOUR, "9");
        this.endHour = this.getPropertyAsInt(END_HOUR, "17");
        this.holidays = this.parseHolidays();
        this.parseWeekendDays();
        this.timezone = this.businessCalendarConfiguration.getProperty(TIMEZONE);
    }

    @Override
    public long calculateBusinessTimeAsDuration(String timeExpression) {
        if (this.businessCalendarConfiguration == null) {
            return TimeUtils.parseTimeString((String)timeExpression);
        }
        Date calculatedDate = this.calculateBusinessTimeAsDate(timeExpression);
        return calculatedDate.getTime() - this.getCurrentTime();
    }

    @Override
    public Date calculateBusinessTimeAsDate(String timeExpression) {
        int currentCalHour;
        int numberOfWeeks;
        Matcher mat;
        if (this.businessCalendarConfiguration == null) {
            return new Date(TimeUtils.parseTimeString((String)(this.getCurrentTime() + timeExpression)));
        }
        String trimmed = timeExpression.trim();
        int weeks = 0;
        int days = 0;
        int hours = 0;
        int min = 0;
        if (trimmed.length() > 0 && (mat = SIMPLE.matcher(trimmed)).matches()) {
            weeks = mat.group(3) != null ? Integer.parseInt(mat.group(3)) : 0;
            days = mat.group(5) != null ? Integer.parseInt(mat.group(5)) : 0;
            hours = mat.group(7) != null ? Integer.parseInt(mat.group(7)) : 0;
            min = mat.group(9) != null ? Integer.parseInt(mat.group(9)) : 0;
        }
        int time = 0;
        GregorianCalendar c = new GregorianCalendar();
        if (this.timezone != null) {
            ((Calendar)c).setTimeZone(TimeZone.getTimeZone(this.timezone));
        }
        if (this.clock != null) {
            c.setTimeInMillis(this.clock.getCurrentTime());
        }
        if ((numberOfWeeks = days / this.daysPerWeek + weeks) > 0) {
            ((Calendar)c).add(3, numberOfWeeks);
        }
        this.handleWeekend(c);
        int numberOfDays = (hours += (days - numberOfWeeks * this.daysPerWeek) * this.hoursInDay) / this.hoursInDay;
        if (numberOfDays > 0) {
            for (int i = 0; i < numberOfDays; ++i) {
                ((Calendar)c).add(6, 1);
                this.handleWeekend(c);
            }
        }
        if ((currentCalHour = c.get(11)) >= this.endHour) {
            ((Calendar)c).add(6, 1);
            ((Calendar)c).add(11, this.startHour - currentCalHour);
        } else if (currentCalHour < this.startHour) {
            ((Calendar)c).add(11, this.startHour);
        }
        time = hours - numberOfDays * this.hoursInDay;
        ((Calendar)c).add(10, time);
        this.handleWeekend(c);
        currentCalHour = c.get(11);
        if (currentCalHour >= this.endHour) {
            ((Calendar)c).add(6, 1);
            c.set(11, this.startHour);
            ((Calendar)c).add(11, currentCalHour - this.endHour);
        } else if (currentCalHour < this.startHour) {
            ((Calendar)c).add(11, this.startHour);
        }
        int numberOfHours = min / 60;
        if (numberOfHours > 0) {
            ((Calendar)c).add(10, numberOfHours);
            min -= numberOfHours * 60;
        }
        ((Calendar)c).add(12, min);
        currentCalHour = c.get(11);
        if (currentCalHour >= this.endHour) {
            ((Calendar)c).add(6, 1);
            c.set(11, this.startHour);
            ((Calendar)c).add(11, currentCalHour - this.endHour);
        } else if (currentCalHour < this.startHour) {
            ((Calendar)c).add(11, this.startHour);
        }
        this.handleWeekend(c);
        this.handleHoliday(c);
        return c.getTime();
    }

    protected void handleHoliday(Calendar c) {
        if (!this.holidays.isEmpty()) {
            Date current = c.getTime();
            for (TimePeriod holiday : this.holidays) {
                if (!current.after(holiday.getFrom()) || !current.before(holiday.getTo())) continue;
                GregorianCalendar tmp = new GregorianCalendar();
                tmp.setTime(holiday.getTo());
                c.add(6, tmp.get(6) - c.get(6));
                this.handleWeekend(c);
                break;
            }
        }
    }

    protected int getPropertyAsInt(String propertyName, String defaultValue) {
        String value = this.businessCalendarConfiguration.getProperty(propertyName, defaultValue);
        return Integer.parseInt(value);
    }

    protected List<TimePeriod> parseHolidays() {
        String holidaysString = this.businessCalendarConfiguration.getProperty(HOLIDAYS);
        ArrayList<TimePeriod> holidays = new ArrayList<TimePeriod>();
        int currentYear = Calendar.getInstance().get(1);
        if (holidaysString != null) {
            String[] hPeriods = holidaysString.split(",");
            SimpleDateFormat sdf = new SimpleDateFormat(this.businessCalendarConfiguration.getProperty(HOLIDAY_DATE_FORMAT, "yyyy-MM-dd"));
            for (String hPeriod : hPeriods) {
                boolean addNextYearHolidays = false;
                String[] fromTo = hPeriod.split(":");
                if (fromTo[0].startsWith("*")) {
                    addNextYearHolidays = true;
                    fromTo[0] = fromTo[0].replaceFirst("\\*", currentYear + "");
                }
                try {
                    Date from;
                    if (fromTo.length == 2) {
                        GregorianCalendar tmpFrom = new GregorianCalendar();
                        if (this.timezone != null) {
                            ((Calendar)tmpFrom).setTimeZone(TimeZone.getTimeZone(this.timezone));
                        }
                        tmpFrom.setTime(sdf.parse(fromTo[0]));
                        if (fromTo[1].startsWith("*")) {
                            fromTo[1] = fromTo[1].replaceFirst("\\*", currentYear + "");
                        }
                        GregorianCalendar tmpTo = new GregorianCalendar();
                        if (this.timezone != null) {
                            ((Calendar)tmpTo).setTimeZone(TimeZone.getTimeZone(this.timezone));
                        }
                        tmpTo.setTime(sdf.parse(fromTo[1]));
                        from = tmpFrom.getTime();
                        ((Calendar)tmpTo).add(6, 1);
                        if (tmpFrom.get(2) > tmpTo.get(2) && tmpFrom.get(1) == tmpTo.get(1)) {
                            ((Calendar)tmpTo).add(1, 1);
                        }
                        Date to = tmpTo.getTime();
                        holidays.add(new TimePeriod(from, to));
                        holidays.add(new TimePeriod(from, to));
                        if (!addNextYearHolidays) continue;
                        tmpFrom = new GregorianCalendar();
                        if (this.timezone != null) {
                            ((Calendar)tmpFrom).setTimeZone(TimeZone.getTimeZone(this.timezone));
                        }
                        tmpFrom.setTime(sdf.parse(fromTo[0]));
                        ((Calendar)tmpFrom).add(1, 1);
                        from = tmpFrom.getTime();
                        tmpTo = new GregorianCalendar();
                        if (this.timezone != null) {
                            ((Calendar)tmpTo).setTimeZone(TimeZone.getTimeZone(this.timezone));
                        }
                        tmpTo.setTime(sdf.parse(fromTo[1]));
                        ((Calendar)tmpTo).add(1, 1);
                        ((Calendar)tmpTo).add(6, 1);
                        if (tmpFrom.get(2) > tmpTo.get(2) && tmpFrom.get(1) == tmpTo.get(1)) {
                            ((Calendar)tmpTo).add(1, 1);
                        }
                        to = tmpTo.getTime();
                        holidays.add(new TimePeriod(from, to));
                        continue;
                    }
                    GregorianCalendar c = new GregorianCalendar();
                    c.setTime(sdf.parse(fromTo[0]));
                    ((Calendar)c).add(6, 1);
                    holidays.add(new TimePeriod(sdf.parse(fromTo[0]), c.getTime()));
                    if (!addNextYearHolidays) continue;
                    Calendar tmp = Calendar.getInstance();
                    tmp.setTime(sdf.parse(fromTo[0]));
                    tmp.add(1, 1);
                    from = tmp.getTime();
                    ((Calendar)c).add(1, 1);
                    holidays.add(new TimePeriod(from, c.getTime()));
                }
                catch (Exception e) {
                    logger.error("Error while parsing holiday in business calendar", (Throwable)e);
                }
            }
        }
        return holidays;
    }

    protected void parseWeekendDays() {
        String weekendDays = this.businessCalendarConfiguration.getProperty(WEEKEND_DAYS);
        if (weekendDays == null) {
            this.weekendDays.add(7);
            this.weekendDays.add(1);
        } else {
            String[] days;
            for (String day : days = weekendDays.split(",")) {
                this.weekendDays.add(Integer.parseInt(day));
            }
        }
    }

    protected long getCurrentTime() {
        if (this.clock != null) {
            return this.clock.getCurrentTime();
        }
        return System.currentTimeMillis();
    }

    protected boolean isWorkingDay(int day) {
        return !this.weekendDays.contains(day);
    }

    protected void handleWeekend(Calendar c) {
        int dayOfTheWeek = c.get(7);
        while (!this.isWorkingDay(dayOfTheWeek)) {
            c.add(6, 1);
            dayOfTheWeek = c.get(7);
        }
    }

    private class TimePeriod {
        private Date from;
        private Date to;

        protected TimePeriod(Date from, Date to) {
            this.from = from;
            this.to = to;
        }

        protected Date getFrom() {
            return this.from;
        }

        protected Date getTo() {
            return this.to;
        }
    }
}

