/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.ZNRecordDelta;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.StatusUpdate;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.log4j.Logger;

public class ExternalViewComputeStage
extends AbstractBaseStage {
    private static Logger LOG = Logger.getLogger(ExternalViewComputeStage.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        long startTime = System.currentTimeMillis();
        LOG.info((Object)"START ExternalViewComputeStage.process()");
        HelixManager manager = (HelixManager)event.getAttribute("helixmanager");
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.toString());
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        if (manager == null || resourceMap == null || cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires ClusterManager|RESOURCES|DataCache");
        }
        HelixDataAccessor dataAccessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = dataAccessor.keyBuilder();
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.toString());
        ArrayList<ExternalView> newExtViews = new ArrayList<ExternalView>();
        ArrayList<PropertyKey> keys = new ArrayList<PropertyKey>();
        Map curExtViews = dataAccessor.getChildValuesMap(keyBuilder.externalViews());
        for (String resourceName : resourceMap.keySet()) {
            ExternalView view = new ExternalView(resourceName);
            Resource resource = (Resource)resourceMap.get(resourceName);
            if (resource.getBucketSize() > 0) {
                view.setBucketSize(resource.getBucketSize());
            } else {
                view.setBucketSize(currentStateOutput.getBucketSize(resourceName));
            }
            for (Partition partition : resource.getPartitions()) {
                Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resourceName, partition);
                if (currentStateMap == null || currentStateMap.size() <= 0) continue;
                for (String instance : currentStateMap.keySet()) {
                    view.setState(partition.getPartitionName(), instance, currentStateMap.get(instance));
                }
            }
            ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute("clusterStatusMonitor");
            IdealState idealState = cache._idealStateMap.get(view.getResourceName());
            if (idealState != null) {
                if (clusterStatusMonitor != null && !idealState.getStateModelDefRef().equalsIgnoreCase("SchedulerTaskQueue")) {
                    StateModelDefinition stateModelDef = cache.getStateModelDef(idealState.getStateModelDefRef());
                    clusterStatusMonitor.setResourceStatus(view, cache._idealStateMap.get(view.getResourceName()), stateModelDef);
                }
            } else {
                clusterStatusMonitor.unregisterResource(view.getResourceName());
            }
            ExternalView curExtView = (ExternalView)curExtViews.get(resourceName);
            if (idealState != null) {
                view.getRecord().getSimpleFields().putAll(idealState.getRecord().getSimpleFields());
            } else if (curExtView != null) {
                view.getRecord().getSimpleFields().putAll(curExtView.getRecord().getSimpleFields());
            }
            if (curExtView != null && curExtView.getRecord().equals(view.getRecord())) continue;
            keys.add(keyBuilder.externalView(resourceName));
            newExtViews.add(view);
            if (idealState == null || !idealState.getStateModelDefRef().equalsIgnoreCase("SchedulerTaskQueue")) continue;
            this.updateScheduledTaskStatus(view, manager, idealState);
        }
        if (newExtViews.size() > 0) {
            dataAccessor.setChildren(keys, newExtViews);
        }
        for (String resourceName : curExtViews.keySet()) {
            if (resourceMap.keySet().contains(resourceName)) continue;
            LOG.info((Object)("Remove externalView for resource: " + resourceName));
            dataAccessor.removeProperty(keyBuilder.externalView(resourceName));
        }
        long endTime = System.currentTimeMillis();
        LOG.info((Object)("END ExternalViewComputeStage.process(). took: " + (endTime - startTime) + " ms"));
    }

    private void updateScheduledTaskStatus(ExternalView ev, HelixManager manager, IdealState taskQueueIdealState) {
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        ZNRecord finishedTasks = new ZNRecord(ev.getResourceName());
        HashMap emptyMap = new HashMap();
        LinkedList emptyList = new LinkedList();
        HashMap<String, Integer> controllerMsgIdCountMap = new HashMap<String, Integer>();
        HashMap controllerMsgUpdates = new HashMap();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        for (String taskPartitionName : ev.getPartitionSet()) {
            for (String taskState : ev.getStateMap(taskPartitionName).values()) {
                String controllerMsgId;
                if (!taskState.equalsIgnoreCase(HelixDefinedState.ERROR.toString()) && !taskState.equalsIgnoreCase("COMPLETED")) continue;
                LOG.info((Object)(taskPartitionName + " finished as " + taskState));
                finishedTasks.getListFields().put(taskPartitionName, emptyList);
                finishedTasks.getMapFields().put(taskPartitionName, emptyMap);
                if (taskQueueIdealState.getRecord().getMapField(taskPartitionName) == null || (controllerMsgId = taskQueueIdealState.getRecord().getMapField(taskPartitionName).get("controllerMsgId")) == null) continue;
                LOG.info((Object)(taskPartitionName + " finished with controllerMsg " + controllerMsgId));
                if (!controllerMsgUpdates.containsKey(controllerMsgId)) {
                    controllerMsgUpdates.put(controllerMsgId, new HashMap());
                }
                ((Map)controllerMsgUpdates.get(controllerMsgId)).put(taskPartitionName, taskState);
            }
        }
        for (String taskId : taskQueueIdealState.getPartitionSet()) {
            String controllerMsgId = taskQueueIdealState.getRecord().getMapField(taskId).get("controllerMsgId");
            if (controllerMsgId == null) continue;
            if (!controllerMsgIdCountMap.containsKey(controllerMsgId)) {
                controllerMsgIdCountMap.put(controllerMsgId, 0);
            }
            controllerMsgIdCountMap.put(controllerMsgId, (Integer)controllerMsgIdCountMap.get(controllerMsgId) + 1);
        }
        if (controllerMsgUpdates.size() > 0) {
            for (String controllerMsgId : controllerMsgUpdates.keySet()) {
                PropertyKey controllerStatusUpdateKey = keyBuilder.controllerTaskStatus(Message.MessageType.SCHEDULER_MSG.toString(), controllerMsgId);
                StatusUpdate controllerStatusUpdate = (StatusUpdate)accessor.getProperty(controllerStatusUpdateKey);
                for (String taskPartitionName : ((Map)controllerMsgUpdates.get(controllerMsgId)).keySet()) {
                    HashMap<String, String> result = new HashMap<String, String>();
                    result.put("Result", (String)((Map)controllerMsgUpdates.get(controllerMsgId)).get(taskPartitionName));
                    controllerStatusUpdate.getRecord().setMapField("MessageResult " + taskQueueIdealState.getRecord().getMapField(taskPartitionName).get(Message.Attributes.TGT_NAME.toString()) + " " + taskPartitionName + " " + taskQueueIdealState.getRecord().getMapField(taskPartitionName).get(Message.Attributes.MSG_ID.toString()), result);
                }
                Integer controllerMsgIdCount = (Integer)controllerMsgIdCountMap.get(controllerMsgId);
                if (controllerMsgIdCount != null && ((Map)controllerMsgUpdates.get(controllerMsgId)).size() == controllerMsgIdCount.intValue()) {
                    int finishedTasksNum = 0;
                    int completedTasksNum = 0;
                    for (String key : controllerStatusUpdate.getRecord().getMapFields().keySet()) {
                        if (key.startsWith("MessageResult ")) {
                            ++finishedTasksNum;
                        }
                        if (controllerStatusUpdate.getRecord().getMapField(key).get("Result") == null || !controllerStatusUpdate.getRecord().getMapField(key).get("Result").equalsIgnoreCase("COMPLETED")) continue;
                        ++completedTasksNum;
                    }
                    TreeMap<String, String> summary = new TreeMap<String, String>();
                    summary.put("TotalMessages:", "" + finishedTasksNum);
                    summary.put("CompletedMessages", "" + completedTasksNum);
                    controllerStatusUpdate.getRecord().setMapField("Summary", summary);
                }
                accessor.updateProperty(controllerStatusUpdateKey, controllerStatusUpdate);
            }
        }
        if (finishedTasks.getListFields().size() > 0) {
            ZNRecordDelta znDelta = new ZNRecordDelta(finishedTasks, ZNRecordDelta.MergeOperation.SUBTRACT);
            LinkedList<ZNRecordDelta> deltaList = new LinkedList<ZNRecordDelta>();
            deltaList.add(znDelta);
            IdealState delta = new IdealState(taskQueueIdealState.getResourceName());
            delta.setDeltaList(deltaList);
            keyBuilder = accessor.keyBuilder();
            accessor.updateProperty(keyBuilder.idealStates(taskQueueIdealState.getResourceName()), delta);
        }
    }
}

