/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.helix.task.beans.TaskBean;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class TaskConfig {
    private static final Logger LOG = Logger.getLogger(TaskConfig.class);
    private final Map<String, String> _configMap;

    public TaskConfig(String command, Map<String, String> configMap, boolean successOptional, String id, String target) {
        if (configMap == null) {
            configMap = Maps.newHashMap();
        }
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        if (command != null) {
            configMap.put(TaskConfigFields.TASK_COMMAND.toString(), command);
        }
        configMap.put(TaskConfigFields.TASK_SUCCESS_OPTIONAL.toString(), Boolean.toString(successOptional));
        configMap.put(TaskConfigFields.TASK_ID.toString(), id);
        if (target != null) {
            configMap.put(TaskConfigFields.TASK_TARGET_PARTITION.toString(), target);
        }
        this._configMap = configMap;
    }

    public TaskConfig(String command, Map<String, String> configMap, boolean successOptional) {
        this(command, configMap, successOptional, null, null);
    }

    public String getId() {
        return this._configMap.get(TaskConfigFields.TASK_ID.toString());
    }

    public String getCommand() {
        return this._configMap.get(TaskConfigFields.TASK_COMMAND.toString());
    }

    public String getTargetPartition() {
        return this._configMap.get(TaskConfigFields.TASK_TARGET_PARTITION.toString());
    }

    public boolean isSuccessOptional() {
        String successOptionalStr = this._configMap.get(TaskConfigFields.TASK_SUCCESS_OPTIONAL.toString());
        if (successOptionalStr == null) {
            return false;
        }
        return Boolean.parseBoolean(successOptionalStr);
    }

    public Map<String, String> getConfigMap() {
        return this._configMap;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            LOG.error((Object)"Could not serialize TaskConfig", (Throwable)e);
            return super.toString();
        }
    }

    public static TaskConfig from(String target) {
        return new TaskConfig(null, null, false, null, target);
    }

    public static TaskConfig from(TaskBean bean) {
        return new TaskConfig(bean.command, bean.taskConfigMap, bean.successOptional);
    }

    public static TaskConfig from(Map<String, String> rawConfigMap) {
        String taskId = rawConfigMap.get(TaskConfigFields.TASK_ID.toString());
        String command = rawConfigMap.get(TaskConfigFields.TASK_COMMAND.toString());
        String targetPartition = rawConfigMap.get(TaskConfigFields.TASK_TARGET_PARTITION.toString());
        String successOptionalStr = rawConfigMap.get(TaskConfigFields.TASK_SUCCESS_OPTIONAL.toString());
        boolean successOptional = successOptionalStr != null ? Boolean.valueOf(successOptionalStr) : null;
        return new TaskConfig(command, rawConfigMap, successOptional, taskId, targetPartition);
    }

    private static enum TaskConfigFields {
        TASK_ID,
        TASK_COMMAND,
        TASK_SUCCESS_OPTIONAL,
        TASK_TARGET_PARTITION;

    }
}

