/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.WorkingMemory;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.NumberUtils;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.Declaration;
import org.drools.runtime.Calendars;
import org.drools.spi.Activation;
import org.drools.time.Trigger;
import org.drools.time.impl.PointInTimeTrigger;
import org.drools.time.impl.Timer;

public class DurationTimer
implements Timer,
Externalizable {
    private long duration;
    private Declaration eventFactHandleDecl;

    public DurationTimer() {
    }

    public DurationTimer(long duration) {
        this.duration = duration;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.duration);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.duration = in.readLong();
    }

    public long getDuration() {
        return this.duration;
    }

    public Trigger createTrigger(Activation item, WorkingMemory wm) {
        long timestamp;
        if (this.eventFactHandleDecl != null) {
            LeftTuple leftTuple = item.getTuple();
            EventFactHandle fh = (EventFactHandle)leftTuple.get(this.eventFactHandleDecl);
            timestamp = fh.getStartTimestamp();
        } else {
            timestamp = ((InternalWorkingMemory)wm).getTimerService().getCurrentTime();
        }
        String[] calendarNames = item.getRule().getCalendars();
        Calendars calendars = ((InternalWorkingMemory)wm).getCalendars();
        return this.createTrigger(timestamp, calendarNames, calendars);
    }

    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        long offset = timestamp + this.duration;
        if (NumberUtils.isAddOverflow(timestamp, this.duration, offset)) {
            return new PointInTimeTrigger(timestamp, calendarNames, calendars);
        }
        return new PointInTimeTrigger(offset, calendarNames, calendars);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DurationTimer other = (DurationTimer)obj;
        return this.duration == other.duration;
    }

    public Declaration getEventFactHandleDecl() {
        return this.eventFactHandleDecl;
    }

    public void setEventFactHandleDecl(Declaration eventFactHandleDecl) {
        this.eventFactHandleDecl = eventFactHandleDecl;
    }
}

