/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.moduleeditor.drools.WorkingSetManager;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.AssetService;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.WorkingSetConfigData;

public class WorkingSetSelectorPopup {
    private final RuleModeller modeller;
    private final Asset asset;
    private FormStylePopup pop;
    private ListBox availableFacts = new ListBox(true);
    private ListBox selectedFacts = new ListBox(true);

    public WorkingSetSelectorPopup(RuleModeller m, Asset a) {
        this.modeller = m;
        this.asset = a;
        this.pop = new FormStylePopup();
        this.pop.setTitle(Constants.INSTANCE.SelectWorkingSets());
        Grid g = this.buildDoubleList(null);
        AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
        assetService.listAssets(this.asset.getMetaData().getModuleUUID(), new String[]{"workingset"}, 0, -1, "workingsetList", (AsyncCallback)new GenericCallback<TableDataResult>(){

            public void onSuccess(TableDataResult result) {
                for (int i = 0; i < result.data.length; ++i) {
                    if (WorkingSetManager.getInstance().isWorkingSetActive(WorkingSetSelectorPopup.this.asset.getMetaData().getModuleName(), result.data[i].id)) {
                        WorkingSetSelectorPopup.this.selectedFacts.addItem(result.data[i].getDisplayName(), result.data[i].id);
                        continue;
                    }
                    WorkingSetSelectorPopup.this.availableFacts.addItem(result.data[i].getDisplayName(), result.data[i].id);
                }
            }
        });
        Button save = new Button(ConstantsCore.INSTANCE.SaveAndClose());
        save.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String[] wsUUIDs = new String[WorkingSetSelectorPopup.this.selectedFacts.getItemCount()];
                for (int i = 0; i < WorkingSetSelectorPopup.this.selectedFacts.getItemCount(); ++i) {
                    wsUUIDs[i] = WorkingSetSelectorPopup.this.selectedFacts.getValue(i);
                }
                WorkingSetManager.getInstance().applyWorkingSets(WorkingSetSelectorPopup.this.asset.getMetaData().getModuleName(), wsUUIDs, new Command(){

                    public void execute() {
                        LoadingPopup.close();
                        WorkingSetSelectorPopup.this.pop.hide();
                        WorkingSetSelectorPopup.this.modeller.refreshWidget();
                        WorkingSetSelectorPopup.this.modeller.verifyRule(null, true);
                    }
                });
            }
        });
        this.pop.addRow((Widget)g);
        this.pop.addRow((Widget)save);
    }

    public void show() {
        this.pop.show();
    }

    private Grid buildDoubleList(WorkingSetConfigData wsData) {
        Grid grid = new Grid(2, 3);
        this.availableFacts.setVisibleItemCount(10);
        this.selectedFacts.setVisibleItemCount(10);
        Grid btnsPanel = new Grid(2, 1);
        btnsPanel.setWidget(0, 0, (Widget)new Button(">", new ClickHandler(){

            public void onClick(ClickEvent sender) {
                WorkingSetSelectorPopup.this.moveSelected(WorkingSetSelectorPopup.this.availableFacts, WorkingSetSelectorPopup.this.selectedFacts);
            }
        }));
        btnsPanel.setWidget(1, 0, (Widget)new Button("&lt;", new ClickHandler(){

            public void onClick(ClickEvent sender) {
                WorkingSetSelectorPopup.this.moveSelected(WorkingSetSelectorPopup.this.selectedFacts, WorkingSetSelectorPopup.this.availableFacts);
            }
        }));
        grid.setWidget(0, 0, (Widget)new SmallLabel("Available"));
        grid.setWidget(0, 1, (Widget)new SmallLabel(""));
        grid.setWidget(0, 2, (Widget)new SmallLabel("Selected"));
        grid.setWidget(1, 0, (Widget)this.availableFacts);
        grid.setWidget(1, 1, (Widget)btnsPanel);
        grid.setWidget(1, 2, (Widget)this.selectedFacts);
        grid.getColumnFormatter().setWidth(0, "45%");
        grid.getColumnFormatter().setWidth(0, "10%");
        grid.getColumnFormatter().setWidth(0, "45%");
        return grid;
    }

    private void moveSelected(ListBox from, ListBox to) {
        int selected;
        while ((selected = from.getSelectedIndex()) != -1) {
            to.addItem(from.getItemText(selected), from.getValue(selected));
            from.removeItem(selected);
        }
    }
}

