/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleAttributeWidget;
import org.drools.guvnor.client.common.DirtyableHorizontalPane;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleMetadata;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;

public class AttributeSelectorPopup
extends FormStylePopup {
    private final ListBox list = RuleAttributeWidget.getAttributeList();
    private final TextBox box = new TextBox();

    public AttributeSelectorPopup(RuleModel model, boolean lockLHS, boolean lockRHS, Command refresh) {
        super(AttributeSelectorPopup.getImage(), Constants.INSTANCE.AddAnOptionToTheRule());
        this.setTextBox(model, refresh);
        this.setListBox(model, refresh);
        this.setFreezePanel(model, lockLHS, lockRHS, refresh);
    }

    private static Image getImage() {
        Image image = new Image(DroolsGuvnorImageResources.INSTANCE.config());
        image.setAltText(Constants.INSTANCE.Config());
        return image;
    }

    private void setTextBox(RuleModel model, Command refresh) {
        this.box.setVisibleLength(15);
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        horiz.add((Widget)this.box);
        horiz.add((Widget)this.getAddButton(model, refresh, this.box));
        this.addAttribute(Constants.INSTANCE.Metadata3(), (Widget)horiz);
    }

    private void setListBox(final RuleModel model, final Command refresh) {
        this.list.setSelectedIndex(0);
        this.list.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String attr = AttributeSelectorPopup.this.list.getItemText(AttributeSelectorPopup.this.list.getSelectedIndex());
                if (attr.equals("freeze_conditions") || attr.equals("freeze_actions")) {
                    model.addMetadata(new RuleMetadata(attr, "true"));
                } else {
                    model.addAttribute(new RuleAttribute(attr, ""));
                }
                refresh.execute();
                AttributeSelectorPopup.this.hide();
            }
        });
        this.addAttribute(Constants.INSTANCE.Attribute1(), (Widget)this.list);
    }

    private void setFreezePanel(final RuleModel model, boolean lockLHS, boolean lockRHS, final Command refresh) {
        Button freezeConditions = new Button(Constants.INSTANCE.Conditions());
        freezeConditions.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                model.addMetadata(new RuleMetadata("freeze_conditions", "true"));
                refresh.execute();
                AttributeSelectorPopup.this.hide();
            }
        });
        Button freezeActions = new Button(Constants.INSTANCE.Actions());
        freezeActions.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                model.addMetadata(new RuleMetadata("freeze_actions", "true"));
                refresh.execute();
                AttributeSelectorPopup.this.hide();
            }
        });
        HorizontalPanel hz = new HorizontalPanel();
        if (!lockLHS) {
            hz.add((Widget)freezeConditions);
        }
        if (!lockRHS) {
            hz.add((Widget)freezeActions);
        }
        hz.add((Widget)new InfoPopup(Constants.INSTANCE.FrozenAreas(), Constants.INSTANCE.FrozenExplanation()));
        if (hz.getWidgetCount() > 1) {
            this.addAttribute(Constants.INSTANCE.FreezeAreasForEditing(), (Widget)hz);
        }
    }

    private Image getAddButton(final RuleModel model, final Command refresh, final TextBox box) {
        Image addbutton = DroolsGuvnorImages.INSTANCE.NewItem();
        addbutton.setAltText(Constants.INSTANCE.AddMetadataToTheRule());
        addbutton.setTitle(Constants.INSTANCE.AddMetadataToTheRule());
        addbutton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                model.addMetadata(new RuleMetadata(box.getText(), ""));
                refresh.execute();
                AttributeSelectorPopup.this.hide();
            }
        });
        return addbutton;
    }
}

