/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ListBox;
import java.util.Arrays;
import java.util.HashSet;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.IDirtyable;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.ui.ConstraintValueEditorHelper;

public class EnumDropDown
extends ListBox
implements IDirtyable {
    private final DropDownValueChanged valueChangedCommand;

    public EnumDropDown(String currentValue, DropDownValueChanged valueChanged, DropDownData dropData) {
        this(currentValue, valueChanged, dropData, false);
    }

    public EnumDropDown(String currentValue, DropDownValueChanged valueChanged, DropDownData dropData, boolean multipleSelect) {
        super(multipleSelect);
        this.valueChangedCommand = valueChanged;
        this.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                EnumDropDown.this.valueChangedCommand.valueChanged(EnumDropDown.this.encodeSelectedItems(), EnumDropDown.this.encodeSelectedItems());
            }
        });
        this.setDropDownData(currentValue, dropData);
    }

    String encodeSelectedItems() {
        if (this.getItemCount() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.isMultipleSelect()) {
            boolean first = true;
            buffer.append("( ");
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (!this.isItemSelected(i)) continue;
                if (!first) {
                    buffer.append(",");
                }
                first = false;
                buffer.append("\"");
                buffer.append(this.getValue(i));
                buffer.append("\"");
            }
            buffer.append(" )");
        } else {
            buffer.append(this.getValue(this.getSelectedIndex()));
        }
        return buffer.toString();
    }

    public void setDropDownData(final String currentValue, final DropDownData dropData) {
        if (dropData != null && dropData.fixedList == null && dropData.queryExpression != null) {
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

                public void execute() {
                    LoadingPopup.showMessage((String)Constants.INSTANCE.RefreshingList());
                    RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
                    repositoryService.loadDropDownExpression(dropData.valuePairs, dropData.queryExpression, (AsyncCallback)new GenericCallback<String[]>(){

                        public void onSuccess(String[] data) {
                            LoadingPopup.close();
                            if (data.length == 0) {
                                data = new String[]{Constants.INSTANCE.UnableToLoadList()};
                            }
                            EnumDropDown.this.fillDropDown(currentValue, data);
                        }

                        public void onFailure(Throwable t) {
                            LoadingPopup.close();
                            EnumDropDown.this.fillDropDown(currentValue, new String[]{Constants.INSTANCE.UnableToLoadList()});
                        }
                    });
                }
            });
        } else {
            this.fillDropDown(currentValue, dropData);
        }
    }

    private void fillDropDown(String currentValue, DropDownData dropData) {
        if (dropData == null) {
            this.fillDropDown(currentValue, new String[0]);
        } else {
            this.fillDropDown(currentValue, dropData.fixedList);
        }
    }

    private void fillDropDown(String currentValue, String[] enumeratedValues) {
        this.clear();
        boolean selected = false;
        HashSet<String> currentValues = new HashSet<String>();
        String trimmedCurrentValue = currentValue;
        if (this.isMultipleSelect() && trimmedCurrentValue != null) {
            trimmedCurrentValue = currentValue.replace("\"", "");
            trimmedCurrentValue = trimmedCurrentValue.replace("(", "");
            trimmedCurrentValue = trimmedCurrentValue.replace(")", "");
            if ((trimmedCurrentValue = trimmedCurrentValue.trim()).indexOf(",") > 0) {
                currentValues.addAll(Arrays.asList(trimmedCurrentValue.split(",")));
            }
        } else {
            currentValues.add(currentValue);
        }
        for (int i = 0; i < enumeratedValues.length; ++i) {
            String val;
            String v = enumeratedValues[i];
            if (v.indexOf(61) > 0) {
                String[] splut = ConstraintValueEditorHelper.splitValue((String)v);
                String realValue = splut[0];
                String display = splut[1];
                val = realValue;
                this.addItem(display, realValue);
            } else {
                this.addItem(v);
                val = v;
            }
            if (currentValue == null || !currentValues.contains(val)) continue;
            this.setItemSelected(i, true);
            selected = true;
        }
        if (!selected) {
            int itemCount = this.getItemCount();
            this.setEnabled(itemCount > 0);
            if (itemCount > 0) {
                this.setSelectedIndex(0);
                Scheduler.get().scheduleFinally(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        EnumDropDown.this.valueChangedCommand.valueChanged(EnumDropDown.this.getItemText(0), EnumDropDown.this.getValue(0));
                    }
                });
            }
        }
    }
}

