/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Panel;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.TemplateDataCellFactory;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.TemplateDataCellValueFactory;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.TemplateDataColumn;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.events.SetInternalTemplateDataModelEvent;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.events.SetTemplateDataEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractDecoratedGridHeaderWidget;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractDecoratedGridSidebarWidget;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractDecoratedGridWidget;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractMergableGridWidget;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.DynamicColumn;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.ResourcesProvider;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.DynamicData;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SetModelEvent;
import org.drools.ide.common.client.modeldriven.brl.templates.InterpolationVariable;
import org.drools.ide.common.client.modeldriven.brl.templates.TemplateModel;

public abstract class AbstractDecoratedTemplateDataGridWidget
extends AbstractDecoratedGridWidget<TemplateModel, TemplateDataColumn, String> {
    protected final TemplateDataCellFactory cellFactory;
    protected final TemplateDataCellValueFactory cellValueFactory;

    public AbstractDecoratedTemplateDataGridWidget(ResourcesProvider<TemplateDataColumn> resources, TemplateDataCellFactory cellFactory, TemplateDataCellValueFactory cellValueFactory, EventBus eventBus, Panel mainPanel, Panel bodyPanel, AbstractMergableGridWidget<TemplateModel, TemplateDataColumn> gridWidget, AbstractDecoratedGridHeaderWidget<TemplateModel, TemplateDataColumn> headerWidget, AbstractDecoratedGridSidebarWidget<TemplateModel, TemplateDataColumn> sidebarWidget) {
        super(resources, eventBus, mainPanel, bodyPanel, gridWidget, headerWidget, sidebarWidget);
        if (cellFactory == null) {
            throw new IllegalArgumentException("cellFactory cannot be null");
        }
        if (cellValueFactory == null) {
            throw new IllegalArgumentException("cellValueFactory cannot be null");
        }
        this.cellFactory = cellFactory;
        this.cellValueFactory = cellValueFactory;
        eventBus.addHandler(SetTemplateDataEvent.TYPE, (EventHandler)this);
    }

    @Override
    public void onSetModel(SetModelEvent<TemplateModel> event) {
        DynamicData data = new DynamicData();
        TemplateModel model = event.getModel();
        ArrayList<DynamicColumn<TemplateDataColumn>> columns = new ArrayList<DynamicColumn<TemplateDataColumn>>();
        this.setupInternalModel(model, columns, data);
        SetInternalTemplateDataModelEvent sime = new SetInternalTemplateDataModelEvent(model, data, (List<DynamicColumn<TemplateDataColumn>>)columns);
        this.eventBus.fireEvent((GwtEvent)sime);
    }

    private void setupInternalModel(TemplateModel model, List<DynamicColumn<TemplateDataColumn>> columns, DynamicData data) {
        InterpolationVariable[] vars = model.getInterpolationVariablesList();
        if (vars.length == 0) {
            return;
        }
        int colIndex = 0;
        String[][] modelData = model.getTableAsArray();
        for (int iRow = 0; iRow < modelData.length; ++iRow) {
            data.addRow();
        }
        for (InterpolationVariable var : vars) {
            TemplateDataColumn col = new TemplateDataColumn(var.getVarName(), var.getDataType(), var.getFactType(), var.getFactField());
            DynamicColumn<TemplateDataColumn> column = new DynamicColumn<TemplateDataColumn>(col, this.cellFactory.getCell(col), colIndex, this.eventBus);
            columns.add(column);
            data.addColumn(colIndex, this.makeColumnData(modelData, col, colIndex++), true);
        }
    }

    private List<CellValue<? extends Comparable<?>>> makeColumnData(String[][] data, TemplateDataColumn column, int colIndex) {
        int dataSize = data.length;
        ArrayList columnData = new ArrayList(dataSize);
        for (int iRow = 0; iRow < dataSize; ++iRow) {
            String[] row = data[iRow];
            String initialValue = row[colIndex];
            if (initialValue != null && initialValue.equals("")) {
                initialValue = null;
            }
            CellValue<? extends Comparable<?>> cv = this.cellValueFactory.convertModelCellValue(column, initialValue);
            columnData.add(cv);
        }
        return columnData;
    }
}

