/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.serviceconfig;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssertBehaviorOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssetReference;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.EventProcessingOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKAgentConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKSessionConfig;
import org.drools.guvnor.client.util.Preconditions;
import org.drools.guvnor.shared.api.PortableObject;

public class ServiceKBaseConfig
implements PortableObject {
    private static final long serialVersionUID = -543908047056220915L;
    private String name;
    private Integer maxThreads;
    private Boolean mbeans;
    private EventProcessingOption eventProcessingMode;
    private AssertBehaviorOption assertBehavior;
    private String assetsUser;
    private String assetsPassword;
    private Set<AssetReference> resources;
    private Set<AssetReference> models;
    private Map<String, ServiceKSessionConfig> ksessions;
    private Map<String, ServiceKAgentConfig> kagents;

    public ServiceKBaseConfig() {
    }

    public ServiceKBaseConfig(String name) {
        this.setupNewInstance(name, null, null, null, null, null, null, null, null, null, null);
    }

    public ServiceKBaseConfig(ServiceKBaseConfig value) {
        Preconditions.checkNotNull((String)"value", (Object)value);
        this.setupNewInstance(value.name, value.maxThreads, value.mbeans, value.eventProcessingMode, value.assertBehavior, value.assetsUser, value.assetsPassword, value.resources, value.models, value.ksessions.values(), value.kagents.values());
    }

    public ServiceKBaseConfig(String name, Integer maxThreads, Boolean mbeans, EventProcessingOption eventProcessingMode, AssertBehaviorOption assertBehavior, String assetsUser, String assetsPassword, Collection<AssetReference> resources, Collection<AssetReference> models, Collection<ServiceKSessionConfig> ksessions, Collection<ServiceKAgentConfig> kagents) {
        this.setupNewInstance(name, maxThreads, mbeans, eventProcessingMode, assertBehavior, assetsUser, assetsPassword, resources, models, ksessions, kagents);
    }

    public ServiceKBaseConfig(String newName, ServiceKBaseConfig value) {
        Preconditions.checkNotNull((String)"value", (Object)value);
        Preconditions.checkNotEmpty((String)"name", (String)newName);
        this.setupNewInstance(newName, value.maxThreads, value.mbeans, value.eventProcessingMode, value.assertBehavior, value.assetsUser, value.assetsPassword, value.resources, value.models, value.ksessions.values(), value.kagents.values());
    }

    private void setupNewInstance(String name, Integer maxThreads, Boolean mbeans, EventProcessingOption eventProcessingMode, AssertBehaviorOption assertBehavior, String assetsUser, String assetsPassword, Collection<AssetReference> resources, Collection<AssetReference> models, Collection<ServiceKSessionConfig> ksessions, Collection<ServiceKAgentConfig> kagents) {
        this.name = Preconditions.checkNotEmpty((String)"name", (String)name);
        this.maxThreads = maxThreads;
        this.mbeans = mbeans;
        this.eventProcessingMode = eventProcessingMode;
        this.assertBehavior = assertBehavior;
        this.assetsUser = assetsUser;
        this.assetsPassword = assetsPassword;
        if (resources != null && resources.size() > 0) {
            this.resources = new HashSet<AssetReference>(resources.size());
            for (AssetReference activeResource : resources) {
                this.resources.add(new AssetReference(activeResource));
            }
        } else {
            this.resources = new HashSet<AssetReference>();
        }
        if (models != null && models.size() > 0) {
            this.models = new HashSet<AssetReference>(models.size());
            for (AssetReference activeModel : models) {
                this.models.add(new AssetReference(activeModel));
            }
        } else {
            this.models = new HashSet<AssetReference>();
        }
        if (ksessions != null && ksessions.size() > 0) {
            this.ksessions = new HashMap<String, ServiceKSessionConfig>(ksessions.size());
            for (ServiceKSessionConfig activeKSession : ksessions) {
                this.ksessions.put(activeKSession.getName(), new ServiceKSessionConfig(activeKSession));
            }
        } else {
            this.ksessions = new HashMap<String, ServiceKSessionConfig>();
        }
        if (kagents != null && kagents.size() > 0) {
            this.kagents = new HashMap<String, ServiceKAgentConfig>(kagents.size());
            for (ServiceKAgentConfig activeKAgent : kagents) {
                this.kagents.put(activeKAgent.getName(), new ServiceKAgentConfig(activeKAgent));
            }
        } else {
            this.kagents = new HashMap<String, ServiceKAgentConfig>();
        }
    }

    public boolean hasConfig() {
        return this.mbeans != null || this.eventProcessingMode != null || this.assertBehavior != null || this.maxThreads != null;
    }

    public String getName() {
        return this.name;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public Boolean getMbeans() {
        return this.mbeans;
    }

    public EventProcessingOption getEventProcessingMode() {
        return this.eventProcessingMode;
    }

    public AssertBehaviorOption getAssertBehavior() {
        return this.assertBehavior;
    }

    public String getAssetsUser() {
        return this.assetsUser;
    }

    public String getAssetsPassword() {
        return this.assetsPassword;
    }

    public Collection<AssetReference> getResources() {
        return this.resources;
    }

    public Collection<AssetReference> getModels() {
        return this.models;
    }

    public ServiceKSessionConfig getKsession(String name) {
        return this.ksessions.get(name);
    }

    public Collection<ServiceKSessionConfig> getKsessions() {
        return this.ksessions.values();
    }

    public Collection<ServiceKAgentConfig> getKagents() {
        return this.kagents.values();
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setMbeans(boolean mbeans) {
        this.mbeans = mbeans;
    }

    public void setMbeansToNull() {
        this.mbeans = null;
    }

    public void setEventProcessingMode(EventProcessingOption eventProcessingMode) {
        this.eventProcessingMode = (EventProcessingOption)((Object)Preconditions.checkNotNull((String)"eventProcessingMode", (Object)((Object)eventProcessingMode)));
    }

    public void setEventProcessingModeToNull() {
        this.eventProcessingMode = null;
    }

    public void setAssertBehavior(AssertBehaviorOption assertBehavior) {
        this.assertBehavior = (AssertBehaviorOption)((Object)Preconditions.checkNotNull((String)"assertBehavior", (Object)((Object)assertBehavior)));
    }

    public void setAssertBehaviorToNull() {
        this.assertBehavior = null;
    }

    public void setAssetsUser(String assetsUser) {
        this.assetsUser = Preconditions.checkNotEmpty((String)"assetsUser", (String)assetsUser);
    }

    public void setAssetsUserToNull() {
        this.assetsUser = null;
    }

    public void setAssetsPassword(String assetsPassword) {
        this.assetsPassword = (String)Preconditions.checkNotNull((String)"assetsPassword", (Object)assetsPassword);
    }

    public void setAssetsPasswordToNull() {
        this.assetsPassword = null;
    }

    public void addResource(AssetReference resource) {
        if (resource == null) {
            return;
        }
        this.resources.add(resource);
    }

    public void addResources(Collection<AssetReference> resources) {
        if (resources == null || resources.size() == 0) {
            return;
        }
        this.resources.addAll(resources);
    }

    public void setResources(Collection<AssetReference> resources) {
        this.resources.clear();
        if (resources == null || resources.size() == 0) {
            return;
        }
        this.resources.addAll(resources);
    }

    public void removeResource(AssetReference resource) {
        if (resource == null) {
            return;
        }
        this.resources.remove(resource);
    }

    public void addModel(AssetReference model) {
        if (model == null) {
            return;
        }
        this.models.add(model);
    }

    public void addModels(Collection<AssetReference> models) {
        if (models == null || models.size() == 0) {
            return;
        }
        this.models.addAll(models);
    }

    public void setModels(Collection<AssetReference> models) {
        this.models.clear();
        if (models == null || models.size() == 0) {
            return;
        }
        this.models.addAll(models);
    }

    public void removeModel(AssetReference model) {
        if (model == null) {
            return;
        }
        this.models.remove(model);
    }

    public String getNextKSessionName() {
        String name;
        int i = 0;
        while (this.ksessions.containsKey(name = "ksession" + ++i)) {
        }
        return name;
    }

    public void addKsession(ServiceKSessionConfig ksession) {
        if (ksession == null) {
            return;
        }
        if (this.ksessions.containsKey(ksession.getName())) {
            throw new IllegalArgumentException("Session already exists");
        }
        this.ksessions.put(ksession.getName(), ksession);
    }

    public void removeKsession(String ksessionName) {
        if (ksessionName == null || ksessionName.trim().length() == 0) {
            return;
        }
        this.ksessions.remove(ksessionName);
    }

    public String getNextKAgentName() {
        String name;
        int i = 0;
        while (this.kagents.containsKey(name = "kagent" + ++i)) {
        }
        return name;
    }

    public void addKagent(ServiceKAgentConfig kagent) {
        if (kagent == null) {
            return;
        }
        if (this.kagents.containsKey(kagent.getName())) {
            throw new IllegalArgumentException("Agent already exists");
        }
        this.kagents.put(kagent.getName(), kagent);
    }

    public void removeKagent(String kagentName) {
        if (kagentName == null || kagentName.trim().length() == 0) {
            return;
        }
        this.kagents.remove(kagentName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceKBaseConfig that = (ServiceKBaseConfig)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.assertBehavior != that.assertBehavior) {
            return false;
        }
        if (this.assetsPassword != null ? !this.assetsPassword.equals(that.assetsPassword) : that.assetsPassword != null) {
            return false;
        }
        if (this.assetsUser != null ? !this.assetsUser.equals(that.assetsUser) : that.assetsUser != null) {
            return false;
        }
        if (this.eventProcessingMode != that.eventProcessingMode) {
            return false;
        }
        if (this.maxThreads != null ? !this.maxThreads.equals(that.maxThreads) : that.maxThreads != null) {
            return false;
        }
        if (this.mbeans != null ? !this.mbeans.equals(that.mbeans) : that.mbeans != null) {
            return false;
        }
        if (!((Object)this.models).equals(that.models)) {
            return false;
        }
        if (!((Object)this.resources).equals(that.resources)) {
            return false;
        }
        if (!((Object)this.kagents).equals(that.kagents)) {
            return false;
        }
        return ((Object)this.ksessions).equals(that.ksessions);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.maxThreads != null ? this.maxThreads.hashCode() : 0);
        result = 31 * result + (this.mbeans != null ? this.mbeans.hashCode() : 0);
        result = 31 * result + (this.eventProcessingMode != null ? this.eventProcessingMode.hashCode() : 0);
        result = 31 * result + (this.assertBehavior != null ? this.assertBehavior.hashCode() : 0);
        result = 31 * result + (this.assetsUser != null ? this.assetsUser.hashCode() : 0);
        result = 31 * result + (this.assetsPassword != null ? this.assetsPassword.hashCode() : 0);
        result = 31 * result + ((Object)this.resources).hashCode();
        result = 31 * result + ((Object)this.models).hashCode();
        result = 31 * result + ((Object)this.ksessions).hashCode();
        result = 31 * result + ((Object)this.kagents).hashCode();
        return result;
    }
}

