/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.decisiontable.widget.AbstractDecisionTableWidget;
import org.drools.guvnor.client.decisiontable.widget.auditlog.AuditLog;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.UserSecurityContext;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;

public class DecisionTableControlsWidget
extends Composite {
    private Button addRowButton;
    private Button otherwiseButton;
    private Button analyzeButton;
    private Button auditLogButton;

    public DecisionTableControlsWidget(final AbstractDecisionTableWidget dtable, GuidedDecisionTable52 model, final UserSecurityContext userSecurityContext, boolean isReadOnly) {
        HorizontalPanel panel = new HorizontalPanel();
        this.addRowButton = new Button(Constants.INSTANCE.AddRow(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (dtable != null) {
                    dtable.appendRow();
                }
            }
        });
        this.addRowButton.setEnabled(!isReadOnly);
        panel.add((Widget)this.addRowButton);
        this.otherwiseButton = new Button(Constants.INSTANCE.Otherwise(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (dtable != null) {
                    dtable.makeOtherwiseCell();
                }
            }
        });
        this.otherwiseButton.setEnabled(false);
        panel.add((Widget)this.otherwiseButton);
        this.analyzeButton = new Button(Constants.INSTANCE.Analyze(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (dtable != null) {
                    dtable.analyze();
                }
            }
        });
        this.analyzeButton.setEnabled(!isReadOnly);
        panel.add((Widget)this.analyzeButton);
        this.auditLogButton = new Button(Constants.INSTANCE.DecisionTableAuditLog(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (dtable != null) {
                    AuditLog log = new AuditLog(dtable.model, userSecurityContext);
                    log.show();
                }
            }
        });
        this.auditLogButton.setEnabled(!isReadOnly);
        panel.add((Widget)this.auditLogButton);
        this.initWidget((Widget)panel);
    }

    void setEnableOtherwiseButton(boolean isEnabled) {
        this.otherwiseButton.setEnabled(isEnabled);
    }
}

