/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget.auditlog;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.drools.guvnor.client.messages.Constants;
import org.drools.ide.common.client.modeldriven.auditlog.AuditLogEntry;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.ActionInsertFactColumnDetails;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.ActionSetFieldColumnDetails;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.AttributeColumnDetails;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.ColumnDetails;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.ConditionColumnDetails;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.DecisionTableAuditLogFilter;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.DeleteColumnAuditLogEntry;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.DeleteRowAuditLogEntry;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.InsertColumnAuditLogEntry;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.InsertRowAuditLogEntry;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.LimitedEntryActionInsertFactColumnDetails;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.LimitedEntryActionSetFieldColumnDetails;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.LimitedEntryConditionColumnDetails;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.MetadataColumnDetails;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.UpdateColumnAuditLogEntry;

public class AuditLogEntryCellHelper {
    private static final Template TEMPLATE = (Template)GWT.create(Template.class);
    private final DateTimeFormat format;

    public AuditLogEntryCellHelper(DateTimeFormat format) {
        this.format = format;
    }

    public static String getEventTypeDisplayText(String eventType) {
        if (eventType.equals(DecisionTableAuditLogFilter.DecisionTableAuditEvents.INSERT_COLUMN.name())) {
            return Constants.INSTANCE.DecisionTableAuditLogEventInsertColumn();
        }
        if (eventType.equals(DecisionTableAuditLogFilter.DecisionTableAuditEvents.INSERT_ROW.name())) {
            return Constants.INSTANCE.DecisionTableAuditLogEventInsertRow();
        }
        if (eventType.equals(DecisionTableAuditLogFilter.DecisionTableAuditEvents.UPDATE_COLUMN.name())) {
            return Constants.INSTANCE.DecisionTableAuditLogEventUpdateColumn();
        }
        if (eventType.equals(DecisionTableAuditLogFilter.DecisionTableAuditEvents.DELETE_COLUMN.name())) {
            return Constants.INSTANCE.DecisionTableAuditLogEventDeleteColumn();
        }
        if (eventType.equals(DecisionTableAuditLogFilter.DecisionTableAuditEvents.DELETE_ROW.name())) {
            return Constants.INSTANCE.DecisionTableAuditLogEventDeleteRow();
        }
        throw new IllegalArgumentException("Unrecognised AuditLogEntry type.");
    }

    public SafeHtml getSafeHtml(AuditLogEntry event) {
        if (event instanceof UpdateColumnAuditLogEntry) {
            return this.getSafeHtml((UpdateColumnAuditLogEntry)event);
        }
        if (event instanceof InsertColumnAuditLogEntry) {
            return this.getSafeHtml((InsertColumnAuditLogEntry)event);
        }
        if (event instanceof DeleteColumnAuditLogEntry) {
            return this.getSafeHtml((DeleteColumnAuditLogEntry)event);
        }
        if (event instanceof InsertRowAuditLogEntry) {
            return this.getSafeHtml((InsertRowAuditLogEntry)event);
        }
        if (event instanceof DeleteRowAuditLogEntry) {
            return this.getSafeHtml((DeleteRowAuditLogEntry)event);
        }
        throw new IllegalArgumentException("Unrecognised AuditLogEntry type.");
    }

    private SafeHtml getSafeHtml(InsertRowAuditLogEntry event) {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        sb.append(TEMPLATE.commentHeader(Constants.INSTANCE.DecisionTableAuditLogInsertRowAt0(event.getRowIndex() + 1)));
        return sb.toSafeHtml();
    }

    private SafeHtml getSafeHtml(DeleteRowAuditLogEntry event) {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        sb.append(TEMPLATE.commentHeader(Constants.INSTANCE.DecisionTableAuditLogDeleteRowAt0(event.getRowIndex() + 1)));
        return sb.toSafeHtml();
    }

    private SafeHtml getSafeHtml(InsertColumnAuditLogEntry event) {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        this.buildColumnDetailsInsert(event.getDetails(), sb);
        return sb.toSafeHtml();
    }

    private SafeHtml getSafeHtml(UpdateColumnAuditLogEntry event) {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        this.buildColumnDetailsUpdate(event.getDetails(), event.getOriginalDetails(), sb);
        return sb.toSafeHtml();
    }

    private SafeHtml getSafeHtml(DeleteColumnAuditLogEntry event) {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        sb.append(TEMPLATE.commentHeader(Constants.INSTANCE.DecisionTableAuditLogDeleteColumn0(event.getColumnHeader())));
        return sb.toSafeHtml();
    }

    private void buildColumnDetailsInsert(ColumnDetails details, SafeHtmlBuilder sb) {
        if (details instanceof AttributeColumnDetails) {
            this.buildColumnDetailsInsert((AttributeColumnDetails)details, sb);
        } else if (details instanceof MetadataColumnDetails) {
            this.buildColumnDetailsInsert((MetadataColumnDetails)details, sb);
        } else if (details instanceof ConditionColumnDetails) {
            this.buildColumnDetailsInsert((ConditionColumnDetails)details, sb);
        } else if (details instanceof LimitedEntryConditionColumnDetails) {
            this.buildColumnDetailsInsert((LimitedEntryConditionColumnDetails)details, sb);
        } else if (details instanceof ActionInsertFactColumnDetails) {
            this.buildColumnDetailsInsert((ActionInsertFactColumnDetails)details, sb);
        } else if (details instanceof LimitedEntryActionInsertFactColumnDetails) {
            this.buildColumnDetailsInsert((LimitedEntryActionInsertFactColumnDetails)details, sb);
        } else if (details instanceof ActionSetFieldColumnDetails) {
            this.buildColumnDetailsInsert((ActionSetFieldColumnDetails)details, sb);
        } else if (details instanceof LimitedEntryActionSetFieldColumnDetails) {
            this.buildColumnDetailsInsert((LimitedEntryActionSetFieldColumnDetails)details, sb);
        } else {
            sb.append(TEMPLATE.commentHeader(Constants.INSTANCE.DecisionTableAuditLogInsertColumn0(details.getColumnHeader())));
        }
    }

    private void buildColumnDetailsInsert(AttributeColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(Constants.INSTANCE.DecisionTableAuditLogInsertAttribute0(details.getAttribute())));
    }

    private void buildColumnDetailsInsert(MetadataColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader(Constants.INSTANCE.DecisionTableAuditLogInsertMetadata0(details.getMetadata())));
    }

    private void buildColumnDetailsInsert(ConditionColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader2Details(Constants.INSTANCE.DecisionTableAuditLogInsertCondition0(details.getColumnHeader()), Constants.INSTANCE.FieldColon(), this.nil(details.getFactField()), Constants.INSTANCE.OperatorColon(), this.nil(details.getOperator())));
    }

    private void buildColumnDetailsInsert(LimitedEntryConditionColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader3Details(Constants.INSTANCE.DecisionTableAuditLogInsertCondition0(details.getColumnHeader()), Constants.INSTANCE.FieldColon(), this.nil(details.getFactField()), Constants.INSTANCE.OperatorColon(), this.nil(details.getOperator()), Constants.INSTANCE.ValueColon(), this.nilLimitedEntryValue(details.getValue())));
    }

    private void buildColumnDetailsInsert(ActionInsertFactColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader2Details(Constants.INSTANCE.DecisionTableAuditLogInsertActionInsertFact0(details.getColumnHeader()), Constants.INSTANCE.FactTypeColon(), this.nil(details.getFactType()), Constants.INSTANCE.FieldColon(), this.nil(details.getFactField())));
    }

    private void buildColumnDetailsInsert(LimitedEntryActionInsertFactColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader3Details(Constants.INSTANCE.DecisionTableAuditLogInsertActionInsertFact0(details.getColumnHeader()), Constants.INSTANCE.FactTypeColon(), this.nil(details.getFactType()), Constants.INSTANCE.FieldColon(), this.nil(details.getFactField()), Constants.INSTANCE.ValueColon(), this.nilLimitedEntryValue(details.getValue())));
    }

    private void buildColumnDetailsInsert(ActionSetFieldColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader2Details(Constants.INSTANCE.DecisionTableAuditLogInsertActionSetField0(details.getColumnHeader()), Constants.INSTANCE.BoundVariableColon(), this.nil(details.getBoundName()), Constants.INSTANCE.FieldColon(), this.nil(details.getFactField())));
    }

    private void buildColumnDetailsInsert(LimitedEntryActionSetFieldColumnDetails details, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader3Details(Constants.INSTANCE.DecisionTableAuditLogInsertActionSetField0(details.getColumnHeader()), Constants.INSTANCE.BoundVariableColon(), this.nil(details.getBoundName()), Constants.INSTANCE.FieldColon(), this.nil(details.getFactField()), Constants.INSTANCE.ValueColon(), this.nilLimitedEntryValue(details.getValue())));
    }

    private void buildColumnDetailsUpdate(ColumnDetails details, ColumnDetails originalDetails, SafeHtmlBuilder sb) {
        if (details instanceof ConditionColumnDetails && originalDetails instanceof ConditionColumnDetails) {
            this.buildColumnDetailsUpdate((ConditionColumnDetails)details, (ConditionColumnDetails)originalDetails, sb);
        } else if (details instanceof LimitedEntryConditionColumnDetails && originalDetails instanceof LimitedEntryConditionColumnDetails) {
            this.buildColumnDetailsUpdate((LimitedEntryConditionColumnDetails)details, (LimitedEntryConditionColumnDetails)originalDetails, sb);
        } else if (details instanceof ActionInsertFactColumnDetails && originalDetails instanceof ActionInsertFactColumnDetails) {
            this.buildColumnDetailsUpdate((ActionInsertFactColumnDetails)details, (ActionInsertFactColumnDetails)originalDetails, sb);
        } else if (details instanceof LimitedEntryActionInsertFactColumnDetails && originalDetails instanceof LimitedEntryActionInsertFactColumnDetails) {
            this.buildColumnDetailsUpdate((LimitedEntryActionInsertFactColumnDetails)details, (LimitedEntryActionInsertFactColumnDetails)originalDetails, sb);
        } else if (details instanceof ActionSetFieldColumnDetails && originalDetails instanceof ActionSetFieldColumnDetails) {
            this.buildColumnDetailsUpdate((ActionSetFieldColumnDetails)details, (ActionSetFieldColumnDetails)originalDetails, sb);
        } else if (details instanceof LimitedEntryActionSetFieldColumnDetails && originalDetails instanceof LimitedEntryActionSetFieldColumnDetails) {
            this.buildColumnDetailsUpdate((LimitedEntryActionSetFieldColumnDetails)details, (LimitedEntryActionSetFieldColumnDetails)originalDetails, sb);
        } else {
            sb.append(TEMPLATE.commentHeader(Constants.INSTANCE.DecisionTableAuditLogUpdateColumn0Was1(details.getColumnHeader(), originalDetails.getColumnHeader())));
        }
    }

    private void buildColumnDetailsUpdate(ConditionColumnDetails details, ConditionColumnDetails originalDetails, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader2Details(Constants.INSTANCE.DecisionTableAuditLogUpdateCondition0Was1(details.getColumnHeader(), originalDetails.getColumnHeader()), Constants.INSTANCE.FieldColon(), Constants.INSTANCE.DecisionTableAuditLog0Was1(this.nil(details.getFactField()), this.nil(originalDetails.getFactField())), Constants.INSTANCE.OperatorColon(), Constants.INSTANCE.DecisionTableAuditLog0Was1(this.nil(details.getOperator()), this.nil(originalDetails.getOperator()))));
    }

    private void buildColumnDetailsUpdate(LimitedEntryConditionColumnDetails details, LimitedEntryConditionColumnDetails originalDetails, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader3Details(Constants.INSTANCE.DecisionTableAuditLogUpdateCondition0Was1(details.getColumnHeader(), originalDetails.getColumnHeader()), Constants.INSTANCE.FieldColon(), Constants.INSTANCE.DecisionTableAuditLog0Was1(this.nil(details.getFactField()), this.nil(originalDetails.getFactField())), Constants.INSTANCE.OperatorColon(), Constants.INSTANCE.DecisionTableAuditLog0Was1(this.nil(details.getOperator()), this.nil(originalDetails.getOperator())), Constants.INSTANCE.ValueColon(), Constants.INSTANCE.DecisionTableAuditLog0Was1(this.nilLimitedEntryValue(details.getValue()), this.nilLimitedEntryValue(originalDetails.getValue()))));
    }

    private void buildColumnDetailsUpdate(ActionInsertFactColumnDetails details, ActionInsertFactColumnDetails originalDetails, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader2Details(Constants.INSTANCE.DecisionTableAuditLogUpdateAction0Was1(details.getColumnHeader(), originalDetails.getColumnHeader()), Constants.INSTANCE.FactTypeColon(), Constants.INSTANCE.DecisionTableAuditLog0Was1(this.nil(details.getFactType()), this.nil(originalDetails.getFactType())), Constants.INSTANCE.FieldColon(), Constants.INSTANCE.DecisionTableAuditLog0Was1(this.nil(details.getFactField()), this.nil(originalDetails.getFactField()))));
    }

    private void buildColumnDetailsUpdate(LimitedEntryActionInsertFactColumnDetails details, LimitedEntryActionInsertFactColumnDetails originalDetails, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader3Details(Constants.INSTANCE.DecisionTableAuditLogUpdateAction0Was1(details.getColumnHeader(), originalDetails.getColumnHeader()), Constants.INSTANCE.FactTypeColon(), Constants.INSTANCE.DecisionTableAuditLog0Was1(this.nil(details.getFactType()), this.nil(originalDetails.getFactType())), Constants.INSTANCE.FieldColon(), Constants.INSTANCE.DecisionTableAuditLog0Was1(this.nil(details.getFactField()), this.nil(originalDetails.getFactField())), Constants.INSTANCE.ValueColon(), Constants.INSTANCE.DecisionTableAuditLog0Was1(this.nilLimitedEntryValue(details.getValue()), this.nilLimitedEntryValue(originalDetails.getValue()))));
    }

    private void buildColumnDetailsUpdate(ActionSetFieldColumnDetails details, ActionSetFieldColumnDetails originalDetails, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader2Details(Constants.INSTANCE.DecisionTableAuditLogUpdateAction0Was1(details.getColumnHeader(), originalDetails.getColumnHeader()), Constants.INSTANCE.BoundVariableColon(), Constants.INSTANCE.DecisionTableAuditLog0Was1(this.nil(details.getBoundName()), this.nil(originalDetails.getBoundName())), Constants.INSTANCE.FieldColon(), Constants.INSTANCE.DecisionTableAuditLog0Was1(this.nil(details.getFactField()), this.nil(originalDetails.getFactField()))));
    }

    private void buildColumnDetailsUpdate(LimitedEntryActionSetFieldColumnDetails details, LimitedEntryActionSetFieldColumnDetails originalDetails, SafeHtmlBuilder sb) {
        sb.append(TEMPLATE.commentHeader3Details(Constants.INSTANCE.DecisionTableAuditLogUpdateAction0Was1(details.getColumnHeader(), originalDetails.getColumnHeader()), Constants.INSTANCE.BoundVariableColon(), Constants.INSTANCE.DecisionTableAuditLog0Was1(this.nil(details.getBoundName()), this.nil(originalDetails.getBoundName())), Constants.INSTANCE.FieldColon(), Constants.INSTANCE.DecisionTableAuditLog0Was1(this.nil(details.getFactField()), this.nil(originalDetails.getFactField())), Constants.INSTANCE.ValueColon(), Constants.INSTANCE.DecisionTableAuditLog0Was1(this.nilLimitedEntryValue(details.getValue()), this.nilLimitedEntryValue(originalDetails.getValue()))));
    }

    private String nil(String value) {
        return value == null ? "" : value;
    }

    private String nilLimitedEntryValue(DTCellValue52 value) {
        String displayText = this.convertDTCellValueToString(value);
        return displayText == null ? "" : displayText;
    }

    private String convertDTCellValueToString(DTCellValue52 dcv) {
        switch (dcv.getDataType()) {
            case BOOLEAN: {
                Boolean booleanValue = dcv.getBooleanValue();
                return booleanValue == null ? null : booleanValue.toString();
            }
            case DATE: {
                Date dateValue = dcv.getDateValue();
                return dateValue == null ? null : this.format.format(dcv.getDateValue());
            }
            case NUMERIC: {
                BigDecimal numericValue = (BigDecimal)dcv.getNumericValue();
                return numericValue == null ? null : numericValue.toPlainString();
            }
            case NUMERIC_BIGDECIMAL: {
                BigDecimal bigDecimalValue = (BigDecimal)dcv.getNumericValue();
                return bigDecimalValue == null ? null : bigDecimalValue.toPlainString();
            }
            case NUMERIC_BIGINTEGER: {
                BigInteger bigIntegerValue = (BigInteger)dcv.getNumericValue();
                return bigIntegerValue == null ? null : bigIntegerValue.toString();
            }
            case NUMERIC_BYTE: {
                Byte byteValue = (Byte)dcv.getNumericValue();
                return byteValue == null ? null : byteValue.toString();
            }
            case NUMERIC_DOUBLE: {
                Double doubleValue = (Double)dcv.getNumericValue();
                return doubleValue == null ? null : doubleValue.toString();
            }
            case NUMERIC_FLOAT: {
                Float floatValue = (Float)dcv.getNumericValue();
                return floatValue == null ? null : floatValue.toString();
            }
            case NUMERIC_INTEGER: {
                Integer integerValue = (Integer)dcv.getNumericValue();
                return integerValue == null ? null : integerValue.toString();
            }
            case NUMERIC_LONG: {
                Long longValue = (Long)dcv.getNumericValue();
                return longValue == null ? null : longValue.toString();
            }
            case NUMERIC_SHORT: {
                Short shortValue = (Short)dcv.getNumericValue();
                return shortValue == null ? null : shortValue.toString();
            }
        }
        return dcv.getStringValue();
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div>{0}</div>")
        public SafeHtml commentHeader(String var1);

        @SafeHtmlTemplates.Template(value="<div>{0}</div><table><tr><td><div class=\"auditLogDetailLabel\">{1}</div></td><td><div class=\"auditLogDetailValue\">{2}</div></td></tr><tr><td><div class=\"auditLogDetailLabel\">{3}</div></td><td><div class=\"auditLogDetailValue\">{4}</div></td></tr></table>")
        public SafeHtml commentHeader2Details(String var1, String var2, String var3, String var4, String var5);

        @SafeHtmlTemplates.Template(value="<div>{0}</div><table><tr><td><div class=\"auditLogDetailLabel\">{1}</div></td><td><div class=\"auditLogDetailValue\">{2}</div></td></tr><tr><td><div class=\"auditLogDetailLabel\">{3}</div></td><td><div class=\"auditLogDetailValue\">{4}</div></td></tr><tr><td><div class=\"auditLogDetailLabel\">{5}</div></td><td><div class=\"auditLogDetailValue\">{6}</div></td></tr></table>")
        public SafeHtml commentHeader3Details(String var1, String var2, String var3, String var4, String var5, String var6, String var7);
    }
}

