/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.deployment;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.AcceptItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.SnapshotView;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.util.Activity;

public class SnapshotActivity
extends Activity {
    private final ClientFactory clientFactory;
    private final String moduleName;
    private final String snapshotName;

    public SnapshotActivity(String moduleName, String snapshotName, ClientFactory clientFactory) {
        this.moduleName = moduleName;
        this.snapshotName = snapshotName;
        this.clientFactory = clientFactory;
    }

    public void start(final AcceptItem tabbedPanel, final EventBus eventBus) {
        this.clientFactory.getModuleService().loadSnapshotInfo(this.moduleName, this.snapshotName, (AsyncCallback)new GenericCallback<SnapshotInfo>(){

            public void onSuccess(SnapshotInfo snapshotInfo) {
                SnapshotActivity.this.showTab(tabbedPanel, snapshotInfo, eventBus);
            }
        });
    }

    private void showTab(final AcceptItem tabbedPanel, final SnapshotInfo snapshotInfo, final EventBus eventBus) {
        LoadingPopup.showMessage((String)Constants.INSTANCE.LoadingSnapshot());
        ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
        moduleService.loadModule(snapshotInfo.getUuid(), (AsyncCallback)new GenericCallback<Module>(){

            public void onSuccess(Module conf) {
                tabbedPanel.add(Constants.INSTANCE.SnapshotLabel(snapshotInfo.getName()), (IsWidget)new SnapshotView(SnapshotActivity.this.clientFactory, eventBus, snapshotInfo, conf));
                LoadingPopup.close();
            }
        });
    }
}

