/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.navigation.qa.SummaryTable;
import org.drools.guvnor.client.explorer.navigation.qa.SummaryTableView;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.util.PercentageBar;

public class SummaryTableViewImpl
extends Composite
implements SummaryTableView {
    private FlexTable flexTable = new FlexTable();
    private SummaryTableView.Presenter presenter;
    private int summaryTableIndex = 0;

    public SummaryTableViewImpl() {
        this.initWidget((Widget)this.flexTable);
    }

    @Override
    public void addRow(SummaryTable.Row row) {
        SummaryTableRow summaryTableRow = new SummaryTableRow(row.getUuid());
        summaryTableRow.setName(row.getScenarioName());
        summaryTableRow.setPercentage(row.getPercentage(), row.getBackgroundColor());
        summaryTableRow.setMessage(row.getMessage());
        ++this.summaryTableIndex;
    }

    @Override
    public void setPresenter(SummaryTableView.Presenter presenter) {
        this.presenter = presenter;
    }

    class SummaryTableRow {
        static final int BAR_WIDTH = 150;

        public SummaryTableRow(String uuid) {
            this.addOpenButton(uuid);
        }

        void setName(String scenarioName) {
            SummaryTableViewImpl.this.flexTable.setWidget(SummaryTableViewImpl.this.summaryTableIndex, 0, (Widget)new SmallLabel(scenarioName + ":"));
            SummaryTableViewImpl.this.flexTable.getFlexCellFormatter().setHorizontalAlignment(SummaryTableViewImpl.this.summaryTableIndex, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        }

        void setMessage(String message) {
            SummaryTableViewImpl.this.flexTable.setWidget(SummaryTableViewImpl.this.summaryTableIndex, 2, (Widget)new SmallLabel(message));
        }

        private void addOpenButton(String uuid) {
            SummaryTableViewImpl.this.flexTable.setWidget(SummaryTableViewImpl.this.summaryTableIndex, 3, (Widget)this.createOpenButton(uuid));
        }

        private Button createOpenButton(final String uuid) {
            Button open = new Button(Constants.INSTANCE.Open());
            open.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    SummaryTableViewImpl.this.presenter.openTestScenario(uuid);
                }
            });
            return open;
        }

        public void setPercentage(int percentage, String color) {
            this.setPercentageBar(this.createPercentageBar(percentage, color));
        }

        private PercentageBar createPercentageBar(int percentage, String color) {
            PercentageBar percentageBar = new PercentageBar();
            percentageBar.setPercent(percentage);
            percentageBar.setBackgroundColor(color);
            percentageBar.setWidth(150);
            return percentageBar;
        }

        void setPercentageBar(PercentageBar percentageBar) {
            SummaryTableViewImpl.this.flexTable.setWidget(SummaryTableViewImpl.this.summaryTableIndex, 1, (Widget)percentageBar);
        }
    }
}

