/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.moduleeditor.drools;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.explorer.AcceptItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.ClosePlaceEvent;
import org.drools.guvnor.client.explorer.navigation.deployment.SnapshotPlace;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.AssetViewerActivity;
import org.drools.guvnor.client.moduleeditor.drools.PackageBuilderWidget;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.widgets.drools.tables.SnapshotComparisonPagedTable;

public class SnapshotView
extends Composite {
    public static final String LATEST_SNAPSHOT = "LATEST";
    private Module parentConf;
    private SnapshotInfo snapInfo;
    private ListBox box = new ListBox();
    private VerticalPanel vert;
    private SnapshotComparisonPagedTable table;
    private final ClientFactory clientFactory;
    private final EventBus eventBus;

    public SnapshotView(ClientFactory clientFactory, EventBus eventBus, SnapshotInfo snapInfo, Module parentPackage) {
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.vert = new VerticalPanel();
        this.snapInfo = snapInfo;
        this.parentConf = parentPackage;
        PrettyFormLayout head = new PrettyFormLayout();
        Image snapshot = GuvnorImages.INSTANCE.Snapshot();
        snapshot.setAltText("");
        head.addHeader(snapshot, this.header());
        this.vert.add((Widget)head);
        AssetViewerActivity assetViewerActivity = new AssetViewerActivity(this.parentConf.getUuid(), clientFactory);
        assetViewerActivity.start(new AcceptItem(){

            public void add(String tabTitle, IsWidget widget) {
                ScrollPanel pnl = new ScrollPanel();
                pnl.setWidth("100%");
                pnl.add(widget);
                SnapshotView.this.vert.add((Widget)pnl);
            }
        }, null);
        this.vert.setWidth("100%");
        this.initWidget((Widget)this.vert);
    }

    private Widget header() {
        FlexTable ft = new FlexTable();
        ft.setWidget(0, 0, (Widget)new Label(Constants.INSTANCE.ViewingSnapshot()));
        ft.setWidget(0, 1, (Widget)new HTML("<b>" + this.snapInfo.getName() + "</b>"));
        ft.getFlexCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.setWidget(1, 0, (Widget)new Label(Constants.INSTANCE.ForPackage()));
        ft.setWidget(1, 1, (Widget)new Label(this.parentConf.getName()));
        ft.getFlexCellFormatter().setHorizontalAlignment(1, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        HTML dLink = new HTML("<a href='" + PackageBuilderWidget.getDownloadLink(this.parentConf) + "' target='_blank'>" + Constants.INSTANCE.clickHereToDownloadBinaryOrCopyURLForDeploymentAgent() + "</a>");
        ft.setWidget(2, 0, (Widget)new Label(Constants.INSTANCE.DeploymentURL()));
        ft.setWidget(2, 1, (Widget)dLink);
        ft.getFlexCellFormatter().setHorizontalAlignment(2, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.setWidget(3, 0, (Widget)new Label(Constants.INSTANCE.SnapshotCreatedOn()));
        ft.getFlexCellFormatter().setHorizontalAlignment(3, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.setWidget(3, 1, (Widget)new Label(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(this.parentConf.getLastModified())));
        ft.getFlexCellFormatter().setHorizontalAlignment(4, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.setWidget(4, 0, (Widget)new Label(Constants.INSTANCE.CommentColon()));
        ft.setWidget(4, 1, (Widget)new Label(this.parentConf.getCheckinComment()));
        ft.getFlexCellFormatter().setHorizontalAlignment(4, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        HorizontalPanel actions = new HorizontalPanel();
        actions.add((Widget)this.getDeleteButton(this.snapInfo.getName(), this.parentConf.getName()));
        actions.add((Widget)this.getCopyButton(this.snapInfo.getName(), this.parentConf.getName()));
        ft.setWidget(5, 0, (Widget)actions);
        ft.setWidget(6, 0, this.getCompareWidget(this.parentConf.getName(), this.snapInfo.getName()));
        ft.getFlexCellFormatter().setHorizontalAlignment(4, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.getFlexCellFormatter().setColSpan(5, 0, 2);
        return ft;
    }

    private Widget getCompareWidget(final String packageName, final String snapshotName) {
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.add((Widget)new Label("Compare to:"));
        ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
        moduleService.listSnapshots(this.parentConf.getName(), (AsyncCallback)new GenericCallback<SnapshotInfo[]>(){

            public void onSuccess(SnapshotInfo[] info) {
                for (int i = 0; i < info.length; ++i) {
                    if (snapshotName.equals(info[i].getName())) continue;
                    SnapshotView.this.box.addItem(info[i].getName());
                }
            }
        });
        hPanel.add((Widget)this.box);
        Button button = new Button("Compare");
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (SnapshotView.this.table != null) {
                    SnapshotView.this.vert.remove((Widget)SnapshotView.this.table);
                }
                SnapshotView.this.table = new SnapshotComparisonPagedTable(packageName, snapshotName, SnapshotView.this.box.getItemText(SnapshotView.this.box.getSelectedIndex()), SnapshotView.this.clientFactory);
                SnapshotView.this.vert.add((Widget)SnapshotView.this.table);
            }
        });
        hPanel.add((Widget)button);
        return hPanel;
    }

    private Button getDeleteButton(final String snapshotName, final String moduleName) {
        Button btn = new Button(Constants.INSTANCE.Delete());
        btn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)Constants.INSTANCE.SnapshotDeleteConfirm(snapshotName, moduleName))) {
                    ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
                    moduleService.copyOrRemoveSnapshot(moduleName, snapshotName, true, null, (AsyncCallback)new GenericCallback<Void>(){

                        public void onSuccess(Void v) {
                            Window.alert((String)Constants.INSTANCE.SnapshotWasDeleted());
                            SnapshotView.this.eventBus.fireEvent((GwtEvent)SnapshotView.this.getCloseEvent(moduleName));
                        }
                    });
                }
            }
        });
        return btn;
    }

    private ClosePlaceEvent getCloseEvent(String moduleName) {
        return new ClosePlaceEvent((Place)new SnapshotPlace(moduleName, this.snapInfo.getName()));
    }

    private Button getCopyButton(final String snapshotName, final String packageName) {
        final ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
        Button btn = new Button(Constants.INSTANCE.Copy());
        btn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                moduleService.listSnapshots(packageName, (AsyncCallback)SnapshotView.this.createGenericCallback(snapshotName, packageName, moduleService));
            }
        });
        return btn;
    }

    private GenericCallback<SnapshotInfo[]> createGenericCallback(final String snapshotName, final String packageName, final ModuleServiceAsync serv) {
        return new GenericCallback<SnapshotInfo[]>(){

            public void onSuccess(final SnapshotInfo[] snaps) {
                final FormStylePopup copy = new FormStylePopup(DroolsGuvnorImages.INSTANCE.Snapshot(), Constants.INSTANCE.CopySnapshotText(snapshotName));
                final ArrayList<RadioButton> options = new ArrayList<RadioButton>();
                VerticalPanel vert = new VerticalPanel();
                for (int i = 0; i < snaps.length; ++i) {
                    if (snaps[i].getName().equals(snapshotName)) continue;
                    RadioButton existing = new RadioButton("snapshotNameGroup", snaps[i].getName());
                    options.add(existing);
                    vert.add((Widget)existing);
                }
                HorizontalPanel newNameHorizontalPanel = new HorizontalPanel();
                final TextBox newNameTextBox = new TextBox();
                String newNameText = Constants.INSTANCE.NEW() + ": ";
                final RadioButton newNameRadioButton = new RadioButton("snapshotNameGroup", newNameText);
                newNameHorizontalPanel.add((Widget)newNameRadioButton);
                newNameTextBox.setEnabled(false);
                newNameRadioButton.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        newNameTextBox.setEnabled(true);
                    }
                });
                newNameHorizontalPanel.add((Widget)newNameTextBox);
                options.add(newNameRadioButton);
                vert.add((Widget)newNameHorizontalPanel);
                copy.addAttribute(Constants.INSTANCE.ExistingSnapshots(), (Widget)vert);
                Button ok = new Button(Constants.INSTANCE.OK());
                copy.addAttribute("", (Widget)ok);
                ok.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (!this.isOneButtonSelected(options)) {
                            Window.alert((String)Constants.INSTANCE.YouHaveToEnterOrChoseALabelNameForTheSnapshot());
                            return;
                        }
                        if (newNameRadioButton.getValue().booleanValue()) {
                            if (this.checkUnique(snaps, newNameTextBox.getText())) {
                                serv.copyOrRemoveSnapshot(packageName, snapshotName, false, newNameTextBox.getText(), (AsyncCallback)new GenericCallback<Void>(){

                                    public void onSuccess(Void v) {
                                        copy.hide();
                                        Window.alert((String)Constants.INSTANCE.CreatedSnapshot0ForPackage1(newNameTextBox.getText(), packageName));
                                    }
                                });
                            }
                        } else {
                            for (RadioButton rb : options) {
                                if (!rb.getValue().booleanValue()) continue;
                                final String newName = rb.getText();
                                serv.copyOrRemoveSnapshot(packageName, snapshotName, false, newName, (AsyncCallback)new GenericCallback<Void>(){

                                    public void onSuccess(Void v) {
                                        copy.hide();
                                        Window.alert((String)Constants.INSTANCE.Snapshot0ForPackage1WasCopiedFrom2(newName, packageName, snapshotName));
                                    }
                                });
                            }
                        }
                    }

                    private boolean isOneButtonSelected(List<RadioButton> options2) {
                        boolean oneButtonIsSelected = false;
                        for (RadioButton rb : options2) {
                            if (!rb.getValue().booleanValue()) continue;
                            oneButtonIsSelected = true;
                            break;
                        }
                        return oneButtonIsSelected;
                    }

                    private boolean checkUnique(SnapshotInfo[] snaps2, String name) {
                        for (SnapshotInfo sn : snaps2) {
                            if (!sn.getName().equals(name)) continue;
                            Window.alert((String)Constants.INSTANCE.PleaseEnterANonExistingSnapshotName());
                            return false;
                        }
                        return true;
                    }
                });
                copy.show();
            }
        };
    }

    public static void showNewSnapshot(final Command refreshCmd) {
        final FormStylePopup pop = new FormStylePopup(DroolsGuvnorImages.INSTANCE.Snapshot(), Constants.INSTANCE.NewSnapshot());
        final RulePackageSelector sel = new RulePackageSelector();
        pop.addAttribute(Constants.INSTANCE.ForPackage(), (Widget)sel);
        Button ok = new Button(Constants.INSTANCE.OK());
        pop.addAttribute("", (Widget)ok);
        pop.show();
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                pop.hide();
                String pkg = sel.getSelectedPackage();
                PackageBuilderWidget.showSnapshotDialog(pkg, refreshCmd, "", "", "", false, "", "", false, "");
            }
        });
    }

    public static void rebuildBinaries() {
        if (Window.confirm((String)Constants.INSTANCE.SnapshotRebuildWarning())) {
            LoadingPopup.showMessage((String)Constants.INSTANCE.RebuildingSnapshotsPleaseWaitThisMayTakeSomeTime());
            ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
            moduleService.rebuildSnapshots((AsyncCallback)new GenericCallback<Void>(){

                public void onSuccess(Void v) {
                    LoadingPopup.close();
                    Window.alert((String)Constants.INSTANCE.SnapshotsWereRebuiltSuccessfully());
                }
            });
        }
    }
}

