/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.decoratedgrid;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractDecoratedGridHeaderWidget;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractDecoratedGridSidebarWidget;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractMergableGridWidget;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.ResourcesProvider;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.AppendRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.ColumnResizeEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.DeleteRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.InsertRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SelectedCellChangeEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SetModelEvent;

public abstract class AbstractDecoratedGridWidget<M, T, C>
extends Composite
implements ColumnResizeEvent.Handler,
SelectedCellChangeEvent.Handler,
DeleteRowEvent.Handler,
InsertRowEvent.Handler,
AppendRowEvent.Handler,
SetModelEvent.Handler<M> {
    protected Panel mainPanel;
    protected Panel bodyPanel;
    protected ScrollPanel scrollPanel;
    protected AbstractMergableGridWidget<M, T> gridWidget;
    protected AbstractDecoratedGridHeaderWidget<M, T> headerWidget;
    protected AbstractDecoratedGridSidebarWidget<M, T> sidebarWidget;
    protected int height;
    protected int width;
    protected final ResourcesProvider<T> resources;
    protected final EventBus eventBus;

    public AbstractDecoratedGridWidget(ResourcesProvider<T> resources, EventBus eventBus, Panel mainPanel, Panel bodyPanel, AbstractMergableGridWidget<M, T> gridWidget, AbstractDecoratedGridHeaderWidget<M, T> headerWidget, AbstractDecoratedGridSidebarWidget<M, T> sidebarWidget) {
        if (resources == null) {
            throw new IllegalArgumentException("resources cannot be null");
        }
        if (eventBus == null) {
            throw new IllegalArgumentException("eventBus cannot be null");
        }
        if (mainPanel == null) {
            throw new IllegalArgumentException("mainPanel cannot be null");
        }
        if (bodyPanel == null) {
            throw new IllegalArgumentException("bodyPanel cannot be null");
        }
        if (gridWidget == null) {
            throw new IllegalArgumentException("gridWidget cannot be null");
        }
        if (headerWidget == null) {
            throw new IllegalArgumentException("headerWidget cannot be null");
        }
        if (sidebarWidget == null) {
            throw new IllegalArgumentException("sidebarWidget cannot be null");
        }
        this.resources = resources;
        this.eventBus = eventBus;
        this.mainPanel = mainPanel;
        this.bodyPanel = bodyPanel;
        this.gridWidget = gridWidget;
        this.headerWidget = headerWidget;
        this.sidebarWidget = sidebarWidget;
        this.headerWidget.setSidebar((UIObject)this.sidebarWidget);
        this.scrollPanel = new ScrollPanel();
        this.scrollPanel.add(gridWidget);
        this.scrollPanel.addScrollHandler(this.getScrollHandler());
        this.initialiseHeaderWidget();
        this.initialiseSidebarWidget();
        this.initWidget((Widget)mainPanel);
        eventBus.addHandler(DeleteRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(InsertRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(AppendRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(SelectedCellChangeEvent.TYPE, (EventHandler)this);
    }

    protected void assertDimensions() {
        this.headerWidget.setWidth(this.scrollPanel.getElement().getClientWidth() + "px");
        this.sidebarWidget.setHeight(this.scrollPanel.getElement().getClientHeight() + "px");
    }

    protected abstract ScrollHandler getScrollHandler();

    private void initialiseHeaderWidget() {
        this.eventBus.addHandler(ColumnResizeEvent.TYPE, (EventHandler)this);
        this.headerWidget.addResizeHandler(new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                AbstractDecoratedGridWidget.this.scrollPanel.setHeight(AbstractDecoratedGridWidget.this.height - event.getHeight() + "px");
                AbstractDecoratedGridWidget.this.assertDimensions();
            }
        });
        this.bodyPanel.add(this.headerWidget);
        this.bodyPanel.add((Widget)this.scrollPanel);
    }

    private void initialiseSidebarWidget() {
        this.headerWidget.addResizeHandler(new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                AbstractDecoratedGridWidget.this.sidebarWidget.resizeSidebar(event.getHeight());
            }
        });
        this.mainPanel.add(this.sidebarWidget);
        this.mainPanel.add((Widget)this.bodyPanel);
    }

    public void setPixelSize(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be less than zero");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be less than zero");
        }
        super.setPixelSize(width, height);
        this.height = height;
        this.setHeight(height);
        this.setWidth(width);
    }

    private void cellSelected(AbstractMergableGridWidget.CellSelectionDetail ce) {
        if (ce == null) {
            return;
        }
        if (ce.getOffsetX() < this.scrollPanel.getHorizontalScrollPosition()) {
            this.scrollPanel.setHorizontalScrollPosition(ce.getOffsetX());
        }
        int scrollWidth = this.scrollPanel.getElement().getClientWidth();
        if (ce.getOffsetX() + ce.getWidth() > scrollWidth + this.scrollPanel.getHorizontalScrollPosition()) {
            int delta = ce.getOffsetX() + ce.getWidth() - this.scrollPanel.getHorizontalScrollPosition() - scrollWidth;
            this.scrollPanel.setHorizontalScrollPosition(this.scrollPanel.getHorizontalScrollPosition() + delta);
        }
        if (ce.getOffsetY() < this.scrollPanel.getVerticalScrollPosition()) {
            this.scrollPanel.setVerticalScrollPosition(ce.getOffsetY());
        }
        int scrollHeight = this.scrollPanel.getElement().getClientHeight();
        if (ce.getOffsetY() + ce.getHeight() > scrollHeight + this.scrollPanel.getVerticalScrollPosition()) {
            int delta = ce.getOffsetY() + ce.getHeight() - this.scrollPanel.getVerticalScrollPosition() - scrollHeight;
            this.scrollPanel.setVerticalScrollPosition(this.scrollPanel.getVerticalScrollPosition() + delta);
        }
    }

    private void setHeight(int height) {
        this.mainPanel.setHeight(height + "px");
        Scheduler.get().scheduleFinally(new Scheduler.ScheduledCommand(){

            public void execute() {
                AbstractDecoratedGridWidget.this.assertDimensions();
            }
        });
    }

    private void setWidth(int width) {
        this.mainPanel.setWidth(width + "px");
        this.scrollPanel.setWidth(width - this.resources.sidebarWidth() + "px");
        Scheduler.get().scheduleFinally(new Scheduler.ScheduledCommand(){

            public void execute() {
                AbstractDecoratedGridWidget.this.assertDimensions();
            }
        });
    }

    @Override
    public void onColumnResize(ColumnResizeEvent event) {
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                AbstractDecoratedGridWidget.this.assertDimensions();
            }
        });
    }

    @Override
    public void onSelectedCellChange(SelectedCellChangeEvent event) {
        this.cellSelected(event.getCellSelectionDetail());
    }

    @Override
    public void onDeleteRow(DeleteRowEvent event) {
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                AbstractDecoratedGridWidget.this.assertDimensions();
            }
        });
    }

    @Override
    public void onInsertRow(InsertRowEvent event) {
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                AbstractDecoratedGridWidget.this.assertDimensions();
            }
        });
    }

    @Override
    public void onAppendRow(AppendRowEvent event) {
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                AbstractDecoratedGridWidget.this.assertDimensions();
            }
        });
    }
}

