/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.toolbar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.place.shared.Place;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.AfterAssetEditorCheckInEvent;
import org.drools.guvnor.client.asseteditor.BusinessProcessEditor;
import org.drools.guvnor.client.asseteditor.GuvnorEditor;
import org.drools.guvnor.client.asseteditor.RefreshAssetEditorEvent;
import org.drools.guvnor.client.asseteditor.SaveCommand;
import org.drools.guvnor.client.asseteditor.SaveEventListener;
import org.drools.guvnor.client.asseteditor.drools.RuleValidatorWrapper;
import org.drools.guvnor.client.asseteditor.drools.WorkingSetSelectorPopup;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModelEditor;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.common.StatusChangePopup;
import org.drools.guvnor.client.explorer.AssetEditorPlace;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.RefreshModuleEditorEvent;
import org.drools.guvnor.client.explorer.navigation.ClosePlaceEvent;
import org.drools.guvnor.client.explorer.navigation.qa.VerifierResultWidget;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.PackageBuilderWidget;
import org.drools.guvnor.client.moduleeditor.drools.SuggestionCompletionCache;
import org.drools.guvnor.client.moduleeditor.drools.WorkingSetManager;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.AssetService;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.rpc.VerificationService;
import org.drools.guvnor.client.rpc.VerificationServiceAsync;
import org.drools.guvnor.client.widgets.CheckinPopup;
import org.drools.guvnor.client.widgets.toolbar.ActionToolbarButtonsConfigurationProvider;
import org.drools.guvnor.client.widgets.toolbar.DefaultActionToolbarButtonsConfigurationProvider;
import org.drools.guvnor.shared.api.Valid;

public class AssetEditorActionToolbar
extends Composite {
    private static ActionToolbarBinder uiBinder = (ActionToolbarBinder)GWT.create(ActionToolbarBinder.class);
    @UiField
    MenuItem saveChanges;
    @UiField
    MenuItem saveChangesAndClose;
    @UiField
    MenuItem archive;
    @UiField
    MenuItem delete;
    @UiField
    MenuItem copy;
    @UiField
    MenuItem rename;
    @UiField
    MenuItem promoteToGlobal;
    @UiField
    MenuItem selectWorkingSets;
    @UiField
    MenuItem validate;
    @UiField
    MenuItem verify;
    @UiField
    MenuItem viewSource;
    @UiField
    MenuItem changeStatus;
    @UiField
    Label status;
    @UiField
    Image validIndicator;
    @UiField
    MenuItem sourceMenu;
    private AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
    private ActionToolbarButtonsConfigurationProvider actionToolbarButtonsConfigurationProvider;
    protected Asset asset;
    final Widget editor;
    private final EventBus eventBus;
    private final ClientFactory clientFactory;
    private Command afterCheckinEvent;
    private boolean readOnly;

    public AssetEditorActionToolbar(Asset asset, Widget editor, ClientFactory clientFactory, EventBus eventBus, boolean readOnly) {
        this.asset = asset;
        this.editor = editor;
        this.eventBus = eventBus;
        this.clientFactory = clientFactory;
        this.readOnly = readOnly;
        this.actionToolbarButtonsConfigurationProvider = new DefaultActionToolbarButtonsConfigurationProvider(asset);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.setState(asset.getState());
        this.setValidIndicator(GuvnorImages.INSTANCE.getValidImage(asset.getMetaData().getValid()));
        this.applyToolBarConfiguration();
        this.status.setVisible(this.actionToolbarButtonsConfigurationProvider.showStateLabel());
        this.initActionToolBar();
    }

    public void setState(String newStatus) {
        this.status.setText(Constants.INSTANCE.statusIs(newStatus));
    }

    public void setValidIndicator(Image valid) {
        this.validIndicator = valid;
    }

    private void applyToolBarConfiguration() {
        this.saveChanges.setVisible(this.actionToolbarButtonsConfigurationProvider.showSaveButton());
        this.saveChangesAndClose.setVisible(this.actionToolbarButtonsConfigurationProvider.showSaveAndCloseButton());
        this.validate.setVisible(this.actionToolbarButtonsConfigurationProvider.showValidateButton());
        this.verify.setVisible(this.actionToolbarButtonsConfigurationProvider.showVerifyButton());
        this.viewSource.setVisible(this.actionToolbarButtonsConfigurationProvider.showViewSourceButton());
        this.copy.setVisible(this.actionToolbarButtonsConfigurationProvider.showCopyButton());
        this.rename.setVisible(this.actionToolbarButtonsConfigurationProvider.showRenameButton());
        this.promoteToGlobal.setVisible(this.actionToolbarButtonsConfigurationProvider.showPromoteToGlobalButton());
        this.archive.setVisible(this.actionToolbarButtonsConfigurationProvider.showArchiveButton());
        this.delete.setVisible(this.actionToolbarButtonsConfigurationProvider.showDeleteButton());
        this.changeStatus.setVisible(this.actionToolbarButtonsConfigurationProvider.showChangeStatusButton());
        this.selectWorkingSets.setVisible(this.actionToolbarButtonsConfigurationProvider.showSelectWorkingSetsButton());
        this.sourceMenu.setVisible(this.areSourceMenuChildrenVisible());
    }

    private boolean areSourceMenuChildrenVisible() {
        return this.validate.isVisible() || this.verify.isVisible() || this.viewSource.isVisible();
    }

    public void setSelectWorkingSetsCommand(Command command) {
        this.selectWorkingSets.setCommand(command);
    }

    public void setViewSourceCommand(Command command) {
        this.viewSource.setCommand(command);
    }

    public void setVerifyCommand(Command command) {
        this.verify.setCommand(command);
    }

    public void setValidateCommand(Command command) {
        this.validate.setCommand(command);
    }

    public void setSaveChangesCommand(Command command) {
        this.saveChanges.setCommand(command);
    }

    public void setSaveChangesAndCloseCommand(Command command) {
        this.saveChangesAndClose.setCommand(command);
    }

    public void setChangeStatusCommand(Command command) {
        this.changeStatus.setCommand(command);
    }

    public void setDeleteVisible(boolean b) {
        this.delete.setVisible(b);
    }

    public void setArchiveVisible(boolean b) {
        this.archive.setVisible(b);
    }

    public void setArchiveCommand(final Command archiveCommand) {
        this.archive.setCommand(new Command(){

            public void execute() {
                if (Window.confirm((String)Constants.INSTANCE.AreYouSureYouWantToArchiveThisItem())) {
                    archiveCommand.execute();
                }
            }
        });
    }

    public void setCopyCommand(Command command) {
        this.copy.setCommand(command);
    }

    public void setRenameCommand(Command command) {
        this.rename.setCommand(command);
    }

    public void setDeleteCommand(final Command deleteCommand) {
        this.delete.setCommand(new Command(){

            public void execute() {
                if (Window.confirm((String)Constants.INSTANCE.DeleteAreYouSure())) {
                    deleteCommand.execute();
                }
            }
        });
    }

    public void setPromtToGlobalCommand(Command command) {
        this.promoteToGlobal.setCommand(command);
    }

    private void initActionToolBar() {
        if (this.readOnly) {
            this.setVisible(false);
        } else {
            this.setPromtToGlobalCommand(new Command(){

                public void execute() {
                    AssetEditorActionToolbar.this.doPromptToGlobal();
                }
            });
            this.setDeleteCommand(new Command(){

                public void execute() {
                    AssetEditorActionToolbar.this.doDelete();
                }
            });
            this.setCopyCommand(new Command(){

                public void execute() {
                    AssetEditorActionToolbar.this.doCopy();
                }
            });
            this.setRenameCommand(new Command(){

                public void execute() {
                    AssetEditorActionToolbar.this.doRename();
                }
            });
            this.setArchiveCommand(new Command(){

                public void execute() {
                    AssetEditorActionToolbar.this.doArchive();
                }
            });
            this.afterCheckinEvent = new Command(){

                public void execute() {
                    AssetEditorActionToolbar.this.setDeleteVisible(false);
                    AssetEditorActionToolbar.this.setArchiveVisible(true);
                }
            };
            this.setSelectWorkingSetsCommand(new Command(){

                public void execute() {
                    AssetEditorActionToolbar.this.showWorkingSetsSelection(((RuleModelEditor)AssetEditorActionToolbar.this.editor).getRuleModeller());
                }
            });
            this.setViewSourceCommand(new Command(){

                public void execute() {
                    if (AssetEditorActionToolbar.this.editor instanceof BusinessProcessEditor && ((BusinessProcessEditor)AssetEditorActionToolbar.this.editor).hasErrors()) {
                        return;
                    }
                    AssetEditorActionToolbar.this.onSave();
                    LoadingPopup.showMessage((String)Constants.INSTANCE.CalculatingSource());
                    AssetEditorActionToolbar.this.assetService.buildAssetSource(AssetEditorActionToolbar.this.asset, (AsyncCallback)new GenericCallback<String>(){

                        public void onSuccess(String src) {
                            AssetEditorActionToolbar.this.showSource(src);
                        }
                    });
                }
            });
            this.setVerifyCommand(new Command(){

                public void execute() {
                    AssetEditorActionToolbar.this.doVerify();
                }
            });
            this.setValidateCommand(new Command(){

                public void execute() {
                    AssetEditorActionToolbar.this.onSave();
                    LoadingPopup.showMessage((String)Constants.INSTANCE.ValidatingItemPleaseWait());
                    AssetEditorActionToolbar.this.assetService.validateAsset(AssetEditorActionToolbar.this.asset, (AsyncCallback)new GenericCallback<BuilderResult>(){

                        public void onSuccess(BuilderResult results) {
                            RuleValidatorWrapper.showBuilderErrors(results);
                            AssetEditorActionToolbar.this.setValidIndicator(GuvnorImages.INSTANCE.getValidImage(Valid.fromBoolean((results == null || !results.hasLines() ? 1 : 0) != 0)));
                        }
                    });
                }
            });
            this.setSaveChangesCommand(new Command(){

                public void execute() {
                    AssetEditorActionToolbar.this.verifyAndDoCheckinConfirm(false);
                }
            });
            this.setSaveChangesAndCloseCommand(new Command(){

                public void execute() {
                    AssetEditorActionToolbar.this.verifyAndDoCheckinConfirm(true);
                }
            });
            this.setChangeStatusCommand(new Command(){

                public void execute() {
                    AssetEditorActionToolbar.this.showStatusChanger();
                }
            });
        }
    }

    private void showStatusChanger() {
        final StatusChangePopup pop = new StatusChangePopup(this.asset.getUuid(), false);
        pop.setChangeStatusEvent(new Command(){

            public void execute() {
                AssetEditorActionToolbar.this.setState(pop.getState());
            }
        });
        pop.show();
    }

    protected void verifyAndDoCheckinConfirm(final boolean closeAfter) {
        if (this.editor instanceof RuleModeller) {
            ((RuleModeller)this.editor).verifyRule(new Command(){

                public void execute() {
                    if ((((RuleModeller)AssetEditorActionToolbar.this.editor).hasVerifierErrors() || ((RuleModeller)AssetEditorActionToolbar.this.editor).hasVerifierWarnings()) && !Window.confirm((String)Constants.INSTANCE.theRuleHasErrorsOrWarningsDotDoYouWantToContinue())) {
                        return;
                    }
                    AssetEditorActionToolbar.this.doCheckinConfirm(closeAfter);
                }
            });
        } else if (this.editor instanceof BusinessProcessEditor) {
            if (((BusinessProcessEditor)this.editor).hasErrors()) {
                return;
            }
            this.doCheckinConfirm(closeAfter);
        } else {
            this.doCheckinConfirm(closeAfter);
        }
    }

    protected void doCheckinConfirm(final boolean closeAfter) {
        final CheckinPopup pop = new CheckinPopup(Constants.INSTANCE.CheckInChanges());
        pop.setCommand(new Command(){

            public void execute() {
                AssetEditorActionToolbar.this.doCheckin(pop.getCheckinComment(), closeAfter);
            }
        });
        pop.show();
    }

    public void doCheckin(final String comment, final boolean closeAfter) {
        if (this.editor instanceof SaveEventListener) {
            ((SaveEventListener)this.editor).onSave(new SaveCommand(){

                public void save() {
                    AssetEditorActionToolbar.this.save(comment, closeAfter);
                }

                public void cancel() {
                }
            });
        } else {
            this.save(comment, closeAfter);
        }
    }

    private void save(String comment, boolean closeAfter) {
        this.performCheckIn(comment, closeAfter);
        if (closeAfter) {
            this.close();
        }
    }

    private void doVerify() {
        this.onSave();
        LoadingPopup.showMessage((String)Constants.INSTANCE.VerifyingItemPleaseWait());
        Set<String> activeWorkingSets = null;
        activeWorkingSets = WorkingSetManager.getInstance().getActiveAssetUUIDs(this.asset.getMetaData().getModuleName());
        VerificationServiceAsync verificationService = (VerificationServiceAsync)GWT.create(VerificationService.class);
        verificationService.verifyAsset(this.asset, activeWorkingSets, (AsyncCallback<AnalysisReport>)new GenericCallback<AnalysisReport>(){

            public void onSuccess(AnalysisReport report) {
                LoadingPopup.close();
                FormStylePopup form = new FormStylePopup(DroolsGuvnorImages.INSTANCE.RuleAsset(), Constants.INSTANCE.VerificationReport());
                ScrollPanel scrollPanel = new ScrollPanel((Widget)new VerifierResultWidget(report, false));
                scrollPanel.setWidth("800px");
                scrollPanel.setHeight("200px");
                form.addRow((Widget)scrollPanel);
                LoadingPopup.close();
                form.show();
            }
        });
    }

    private void showSource(String src) {
        PackageBuilderWidget.showSource(src, this.asset.getName());
        LoadingPopup.close();
    }

    private void onSave() {
        if (this.editor instanceof SaveEventListener) {
            SaveEventListener el = (SaveEventListener)this.editor;
            el.onSave(new SaveCommand(){

                public void save() {
                }

                public void cancel() {
                }
            });
        }
    }

    protected void showWorkingSetsSelection(RuleModeller modeller) {
        new WorkingSetSelectorPopup(modeller, this.asset).show();
    }

    protected boolean hasDirty() {
        return false;
    }

    private void close() {
        this.eventBus.fireEvent((GwtEvent)new ClosePlaceEvent((Place)new AssetEditorPlace(this.asset.getUuid())));
    }

    void doDelete() {
        this.readOnly = true;
        RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
        repositoryService.deleteUncheckedRule(this.asset.getUuid(), (AsyncCallback)new GenericCallback<Void>(){

            public void onSuccess(Void o) {
                AssetEditorActionToolbar.this.eventBus.fireEvent((GwtEvent)new RefreshModuleEditorEvent(AssetEditorActionToolbar.this.asset.getMetaData().getModuleUUID()));
                AssetEditorActionToolbar.this.close();
            }
        });
    }

    private void doArchive() {
        this.assetService.archiveAsset(this.asset.getUuid(), (AsyncCallback)new GenericCallback<Void>(){

            public void onSuccess(Void o) {
                AssetEditorActionToolbar.this.eventBus.fireEvent((GwtEvent)new RefreshModuleEditorEvent(AssetEditorActionToolbar.this.asset.getMetaData().getModuleUUID()));
                AssetEditorActionToolbar.this.close();
            }
        });
    }

    private void performCheckIn(String comment, boolean closeAfter) {
        this.asset.setCheckinComment(comment);
        final boolean[] saved = new boolean[]{false};
        if (!saved[0]) {
            LoadingPopup.showMessage((String)Constants.INSTANCE.SavingPleaseWait());
        }
        this.assetService.checkinVersion(this.asset, (AsyncCallback)new GenericCallback<String>(){

            public void onSuccess(String uuid) {
                if (uuid == null) {
                    ErrorPopup.showMessage((String)Constants.INSTANCE.FailedToCheckInTheItemPleaseContactYourSystemAdministrator());
                    return;
                }
                if (uuid.startsWith("ERR")) {
                    ErrorPopup.showMessage((String)uuid.substring(5));
                    return;
                }
                AssetEditorActionToolbar.this.flushSuggestionCompletionCache(AssetEditorActionToolbar.this.asset.getMetaData().getModuleName(), uuid);
                if (AssetEditorActionToolbar.this.editor instanceof DirtyableComposite) {
                    ((DirtyableComposite)AssetEditorActionToolbar.this.editor).resetDirty();
                }
                LoadingPopup.close();
                saved[0] = true;
                if (AssetEditorActionToolbar.this.editor instanceof GuvnorEditor) {
                    AssetEditorActionToolbar.this.eventBus.fireEvent((GwtEvent)new AfterAssetEditorCheckInEvent(uuid, (GuvnorEditor)AssetEditorActionToolbar.this.editor));
                }
                if (AssetEditorActionToolbar.this.editor instanceof SaveEventListener) {
                    ((SaveEventListener)AssetEditorActionToolbar.this.editor).onAfterSave();
                }
                AssetEditorActionToolbar.this.eventBus.fireEvent((GwtEvent)new RefreshModuleEditorEvent(AssetEditorActionToolbar.this.asset.getMetaData().getModuleUUID()));
                if (AssetEditorActionToolbar.this.afterCheckinEvent != null) {
                    AssetEditorActionToolbar.this.afterCheckinEvent.execute();
                }
            }
        });
    }

    public void flushSuggestionCompletionCache(final String moduleName, String uuid) {
        if (AssetFormats.isPackageDependency((String)this.asset.getFormat())) {
            LoadingPopup.showMessage((String)Constants.INSTANCE.RefreshingContentAssistance());
            SuggestionCompletionCache.getInstance().loadPackage(moduleName, new Command(){

                public void execute() {
                    AssetEditorActionToolbar.this.eventBus.fireEvent((GwtEvent)new RefreshAssetEditorEvent(moduleName, null));
                    LoadingPopup.close();
                }
            });
        } else {
            this.eventBus.fireEvent((GwtEvent)new RefreshAssetEditorEvent(moduleName, uuid));
        }
    }

    protected void doCloseUnsavedWarning() {
        final FormStylePopup pop = new FormStylePopup(DroolsGuvnorImages.INSTANCE.WarningImage(), Constants.INSTANCE.WARNINGUnCommittedChanges());
        Button dis = new Button(Constants.INSTANCE.Discard());
        Button can = new Button(Constants.INSTANCE.Cancel());
        HorizontalPanel hor = new HorizontalPanel();
        hor.add((Widget)dis);
        hor.add((Widget)can);
        pop.addRow((Widget)new HTML(Constants.INSTANCE.AreYouSureYouWantToDiscardChanges()));
        pop.addRow((Widget)hor);
        dis.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                AssetEditorActionToolbar.this.close();
                pop.hide();
            }
        });
        can.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                pop.hide();
            }
        });
        pop.show();
    }

    private void doCopy() {
        final FormStylePopup form = new FormStylePopup(DroolsGuvnorImages.INSTANCE.RuleAsset(), Constants.INSTANCE.CopyThisItem());
        final TextBox newName = new TextBox();
        form.addAttribute(Constants.INSTANCE.NewName(), (Widget)newName);
        final RulePackageSelector sel = new RulePackageSelector();
        form.addAttribute(Constants.INSTANCE.NewPackage(), (Widget)sel);
        Button ok = new Button(Constants.INSTANCE.CreateCopy());
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                if (newName.getText() == null || newName.getText().equals("")) {
                    Window.alert((String)Constants.INSTANCE.AssetNameMustNotBeEmpty());
                    return;
                }
                String name = newName.getText().trim();
                AssetEditorActionToolbar.this.assetService.copyAsset(AssetEditorActionToolbar.this.asset.getUuid(), sel.getSelectedPackage(), name, (AsyncCallback)new GenericCallback<String>(){

                    public void onSuccess(String data) {
                        AssetEditorActionToolbar.this.eventBus.fireEvent((GwtEvent)new RefreshModuleEditorEvent(AssetEditorActionToolbar.this.asset.getMetaData().getModuleUUID()));
                        AssetEditorActionToolbar.this.flushSuggestionCompletionCache(sel.getSelectedPackage(), null);
                        AssetEditorActionToolbar.this.completedCopying(newName.getText(), sel.getSelectedPackage(), data);
                        form.hide();
                    }

                    public void onFailure(Throwable t) {
                        if (t.getMessage().indexOf("ItemExistsException") > -1) {
                            Window.alert((String)Constants.INSTANCE.ThatNameIsInUsePleaseTryAnother());
                        } else {
                            super.onFailure(t);
                        }
                    }
                });
            }
        });
        form.addAttribute("", (Widget)ok);
        form.show();
    }

    private void doRename() {
        Image image = new Image(DroolsGuvnorImageResources.INSTANCE.packageLarge());
        image.setAltText(Constants.INSTANCE.Package());
        final FormStylePopup pop = new FormStylePopup(image, Constants.INSTANCE.RenameThisItem());
        final TextBox box = new TextBox();
        box.setText(this.asset.getName());
        pop.addAttribute(Constants.INSTANCE.NewNameAsset(), (Widget)box);
        Button ok = new Button(Constants.INSTANCE.RenameItem());
        pop.addAttribute("", (Widget)ok);
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                AssetEditorActionToolbar.this.assetService.renameAsset(AssetEditorActionToolbar.this.asset.getUuid(), box.getText(), (AsyncCallback)new GenericCallback<String>(){

                    public void onSuccess(String data) {
                        Window.alert((String)Constants.INSTANCE.ItemHasBeenRenamed());
                        AssetEditorActionToolbar.this.eventBus.fireEvent((GwtEvent)new RefreshModuleEditorEvent(AssetEditorActionToolbar.this.asset.getMetaData().getModuleUUID()));
                        AssetEditorActionToolbar.this.eventBus.fireEvent((GwtEvent)new RefreshAssetEditorEvent(AssetEditorActionToolbar.this.asset.getMetaData().getModuleName(), AssetEditorActionToolbar.this.asset.getUuid()));
                        pop.hide();
                    }

                    public void onFailure(Throwable t) {
                        if (t.getMessage().indexOf("ItemExistsException") > -1) {
                            Window.alert((String)Constants.INSTANCE.ThatNameIsInUsePleaseTryAnother());
                        } else {
                            super.onFailure(t);
                        }
                    }
                });
            }
        });
        pop.show();
    }

    private void doPromptToGlobal() {
        if (this.asset.getMetaData().getModuleName().equals("globalArea")) {
            Window.alert((String)Constants.INSTANCE.ItemAlreadyInGlobalArea());
            return;
        }
        if (Window.confirm((String)Constants.INSTANCE.PromoteAreYouSure())) {
            this.assetService.promoteAssetToGlobalArea(this.asset.getUuid(), (AsyncCallback)new GenericCallback<Void>(){

                public void onSuccess(Void data) {
                    Window.alert((String)Constants.INSTANCE.Promoted());
                    AssetEditorActionToolbar.this.flushSuggestionCompletionCache(AssetEditorActionToolbar.this.asset.getMetaData().getModuleName(), null);
                    AssetEditorActionToolbar.this.flushSuggestionCompletionCache("globalArea", null);
                    AssetEditorActionToolbar.this.eventBus.fireEvent((GwtEvent)new RefreshModuleEditorEvent(AssetEditorActionToolbar.this.asset.getMetaData().getModuleUUID()));
                    AssetEditorActionToolbar.this.eventBus.fireEvent((GwtEvent)new RefreshAssetEditorEvent(AssetEditorActionToolbar.this.asset.getMetaData().getModuleName(), AssetEditorActionToolbar.this.asset.getUuid()));
                }

                public void onFailure(Throwable t) {
                    super.onFailure(t);
                }
            });
        }
    }

    private void completedCopying(String name, String pkg, String newAssetUUID) {
        Window.alert((String)Constants.INSTANCE.CreatedANewItemSuccess(name, pkg));
        this.clientFactory.getPlaceController().goTo((Place)new AssetEditorPlace(newAssetUUID));
    }

    static interface ActionToolbarBinder
    extends UiBinder<Widget, AssetEditorActionToolbar> {
    }
}

