/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.shared.simulation;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.guvnor.shared.simulation.SimulationPathModel;
import org.drools.guvnor.shared.simulation.command.AbstractCommandModel;

@XStreamAlias(value="SimulationStepModel")
public class SimulationStepModel
implements PortableObject {
    private SimulationPathModel path;
    private Long distanceMillis;
    private List<AbstractCommandModel> commands = new ArrayList<AbstractCommandModel>();

    public static SimulationStepModel createNew(SimulationPathModel path) {
        SimulationStepModel step = new SimulationStepModel(path);
        return step;
    }

    private SimulationStepModel() {
    }

    public SimulationStepModel(SimulationPathModel path) {
        this.path = path;
    }

    public SimulationPathModel getPath() {
        return this.path;
    }

    public Long getDistanceMillis() {
        return this.distanceMillis;
    }

    public void setDistanceMillis(Long distanceMillis) {
        this.distanceMillis = distanceMillis;
    }

    public List<AbstractCommandModel> getCommands() {
        return this.commands;
    }

    public void addCommand(AbstractCommandModel command) {
        if (command.getStep() != this) {
            throw new IllegalArgumentException("The simulation command's step (" + command.getStep() + ") is not this step (" + this + ").");
        }
        this.commands.add(command);
    }

    public void moveUpCommand(AbstractCommandModel command) {
        int commandIndex = this.commands.indexOf(command);
        int swapCommandIndex = commandIndex - 1;
        AbstractCommandModel swapCommand = this.commands.get(swapCommandIndex);
        this.commands.set(swapCommandIndex, command);
        this.commands.set(commandIndex, swapCommand);
    }

    public void moveDownCommand(AbstractCommandModel command) {
        int commandIndex = this.commands.indexOf(command);
        int swapCommandIndex = commandIndex + 1;
        AbstractCommandModel swapCommand = this.commands.get(swapCommandIndex);
        this.commands.set(swapCommandIndex, command);
        this.commands.set(commandIndex, swapCommand);
    }

    public void removeCommand(AbstractCommandModel command) {
        this.commands.remove(command);
    }
}

