/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.uberfire.ext.preferences.relocated.freemarker.cache.ConcurrentCacheStorage;
import org.uberfire.ext.preferences.relocated.freemarker.cache.ConcurrentMapFactory;
import org.uberfire.ext.preferences.relocated.freemarker.template.utility.UndeclaredThrowableException;

public class SoftCacheStorage
implements ConcurrentCacheStorage {
    private static final Method atomicRemove = SoftCacheStorage.getAtomicRemoveMethod();
    private final ReferenceQueue queue = new ReferenceQueue();
    private final Map map;
    private final boolean concurrent;
    static /* synthetic */ Class class$java$lang$Object;

    public SoftCacheStorage() {
        this(ConcurrentMapFactory.createMap());
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    public SoftCacheStorage(Map backingMap) {
        this.map = backingMap;
        this.concurrent = ConcurrentMapFactory.isConcurrent(this.map);
    }

    public Object get(Object key) {
        this.processQueue();
        Reference ref = (Reference)this.map.get(key);
        return ref == null ? null : ref.get();
    }

    public void put(Object key, Object value) {
        this.processQueue();
        this.map.put(key, new SoftValueReference(key, value, this.queue));
    }

    public void remove(Object key) {
        this.processQueue();
        this.map.remove(key);
    }

    public void clear() {
        this.map.clear();
        this.processQueue();
    }

    private void processQueue() {
        SoftValueReference ref;
        while ((ref = (SoftValueReference)this.queue.poll()) != null) {
            Object key = ref.getKey();
            if (this.concurrent) {
                try {
                    atomicRemove.invoke((Object)this.map, key, ref);
                }
                catch (IllegalAccessException e) {
                    throw new UndeclaredThrowableException(e);
                }
                catch (InvocationTargetException e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
            if (this.map.get(key) != ref) continue;
            this.map.remove(key);
        }
        return;
    }

    private static Method getAtomicRemoveMethod() {
        try {
            return Class.forName("java.util.concurrent.ConcurrentMap").getMethod("remove", class$java$lang$Object == null ? (class$java$lang$Object = SoftCacheStorage.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = SoftCacheStorage.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class SoftValueReference
    extends SoftReference {
        private final Object key;

        SoftValueReference(Object key, Object value, ReferenceQueue queue) {
            super(value, queue);
            this.key = key;
        }

        Object getKey() {
            return this.key;
        }
    }
}

