/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import java.io.IOException;
import java.util.ArrayList;
import org.uberfire.ext.preferences.relocated.freemarker.core.ConditionalBlock;
import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.core.Expression;
import org.uberfire.ext.preferences.relocated.freemarker.core.ParseException;
import org.uberfire.ext.preferences.relocated.freemarker.core.TemplateElement;
import org.uberfire.ext.preferences.relocated.freemarker.core.TemplateObject;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;

final class IfBlock
extends TemplateElement {
    IfBlock(ConditionalBlock block) {
        this.nestedElements = new ArrayList();
        this.addBlock(block);
    }

    void addBlock(ConditionalBlock block) {
        this.nestedElements.add(block);
    }

    void accept(Environment env) throws TemplateException, IOException {
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            ConditionalBlock cblock = (ConditionalBlock)this.nestedElements.get(i);
            Expression condition = cblock.condition;
            if (condition != null && !condition.isTrue(env)) continue;
            if (cblock.nestedBlock != null) {
                env.visit(cblock.nestedBlock);
            }
            return;
        }
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            ConditionalBlock cblock = (ConditionalBlock)this.nestedElements.get(i);
            buf.append(cblock.getCanonicalForm());
        }
        buf.append("</#if>");
        return buf.toString();
    }

    TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        if (this.nestedElements.size() == 1) {
            ConditionalBlock cblock = (ConditionalBlock)this.nestedElements.get(0);
            cblock.isSimple = true;
            cblock.setLocation(this.getTemplate(), (TemplateObject)cblock, (TemplateObject)this);
            return cblock.postParseCleanup(stripWhitespace);
        }
        return super.postParseCleanup(stripWhitespace);
    }

    public String getDescription() {
        return "if-else ";
    }
}

