/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Map;
import org.uberfire.ext.preferences.relocated.freemarker.core.BuiltIn;
import org.uberfire.ext.preferences.relocated.freemarker.core.DynamicKeyName;
import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.core.Expression;
import org.uberfire.ext.preferences.relocated.freemarker.core.NumberLiteral;
import org.uberfire.ext.preferences.relocated.freemarker.template.Template;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateModelException;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateScalarModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateSequenceModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateTransformModel;

class Interpret
extends BuiltIn {
    Interpret() {
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        TemplateModel model = this.target.getAsTemplateModel(env);
        Expression sourceExpr = null;
        String id = "anonymous_interpreted";
        if (model instanceof TemplateSequenceModel) {
            sourceExpr = (Expression)new DynamicKeyName(this.target, new NumberLiteral(new Integer(0))).copyLocationFrom(this.target);
            if (((TemplateSequenceModel)model).size() > 1) {
                id = ((Expression)new DynamicKeyName(this.target, new NumberLiteral(new Integer(1))).copyLocationFrom(this.target)).getStringValue(env);
            }
        } else if (model instanceof TemplateScalarModel) {
            sourceExpr = this.target;
        } else {
            throw Interpret.invalidTypeException(model, this.target, env, "sequence or string");
        }
        String templateSource = sourceExpr.getStringValue(env);
        Template parentTemplate = env.getTemplate();
        try {
            Template template = new Template(parentTemplate.getName() + "$" + id, new StringReader(templateSource), parentTemplate.getConfiguration());
            template.setLocale(env.getLocale());
            return new TemplateProcessorModel(template);
        }
        catch (IOException e) {
            throw new TemplateException("", e, env);
        }
    }

    private static class TemplateProcessorModel
    implements TemplateTransformModel {
        private final Template template;

        TemplateProcessorModel(Template template) {
            this.template = template;
        }

        public Writer getWriter(final Writer out, Map args) throws TemplateModelException, IOException {
            try {
                Environment env = Environment.getCurrentEnvironment();
                env.include(this.template);
            }
            catch (TemplateModelException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TemplateModelException(e);
            }
            return new Writer(out){

                public void close() {
                }

                public void flush() throws IOException {
                    out.flush();
                }

                public void write(char[] cbuf, int off, int len) throws IOException {
                    out.write(cbuf, off, len);
                }
            };
        }
    }
}

