/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import java.io.IOException;
import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.core.Expression;
import org.uberfire.ext.preferences.relocated.freemarker.core.ListLiteral;
import org.uberfire.ext.preferences.relocated.freemarker.core.StringLiteral;
import org.uberfire.ext.preferences.relocated.freemarker.core.TemplateElement;
import org.uberfire.ext.preferences.relocated.freemarker.template.SimpleSequence;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateNodeModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateScalarModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateSequenceModel;

final class VisitNode
extends TemplateElement {
    Expression targetNode;
    Expression namespaces;

    VisitNode(Expression targetNode, Expression namespaces) {
        this.targetNode = targetNode;
        this.namespaces = namespaces;
    }

    void accept(Environment env) throws IOException, TemplateException {
        TemplateModel nss;
        TemplateModel node = this.targetNode.getAsTemplateModel(env);
        VisitNode.assertNonNull(node, this.targetNode, env);
        if (!(node instanceof TemplateNodeModel)) {
            throw new TemplateException("Expecting an XML node here", env);
        }
        TemplateModel templateModel = nss = this.namespaces == null ? null : this.namespaces.getAsTemplateModel(env);
        if (this.namespaces instanceof StringLiteral) {
            nss = env.importLib(((TemplateScalarModel)nss).getAsString(), null);
        } else if (this.namespaces instanceof ListLiteral) {
            nss = ((ListLiteral)this.namespaces).evaluateStringsToNamespaces(env);
        }
        if (nss != null) {
            if (nss instanceof Environment.Namespace) {
                SimpleSequence ss = new SimpleSequence(1);
                ss.add(nss);
                nss = ss;
            } else if (!(nss instanceof TemplateSequenceModel)) {
                throw new TemplateException("Expecting a sequence of namespaces after 'using'", env);
            }
        }
        env.visit((TemplateNodeModel)node, (TemplateSequenceModel)nss);
    }

    public String getCanonicalForm() {
        if (this.namespaces == null) {
            return "<#visit " + this.targetNode.getCanonicalForm() + "/>";
        }
        return "<#visit " + this.targetNode.getCanonicalForm() + " using " + this.namespaces.getCanonicalForm() + "/>";
    }

    public String getDescription() {
        return "visit instruction";
    }
}

