/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.drools.base.EvaluatorWrapper;
import org.drools.base.evaluators.Operator;
import org.drools.compiler.DrlExprParser;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.ReflectiveVisitor;
import org.drools.core.util.StringUtils;
import org.drools.lang.ExpressionRewriter;
import org.drools.lang.descr.AtomicExprDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BindingDescr;
import org.drools.lang.descr.ConnectiveType;
import org.drools.lang.descr.ConstraintConnectiveDescr;
import org.drools.lang.descr.ExprConstraintDescr;
import org.drools.lang.descr.OperatorDescr;
import org.drools.lang.descr.RelationalExprDescr;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.DialectUtil;
import org.drools.util.CompositeClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELDumper
extends ReflectiveVisitor
implements ExpressionRewriter {
    private static final Pattern evalRegexp = Pattern.compile("^eval\\s*\\(", 8);
    private static final String[] standard = new String[]{"==", "<", ">", ">=", "<=", "!=", "~=", "instanceof"};

    @Override
    public String dump(BaseDescr base) {
        return this.dump(new StringBuilder(), base, 0, false, this.createContext()).toString();
    }

    @Override
    public String dump(BaseDescr base, MVELDumperContext context) {
        return this.dump(new StringBuilder(), base, 0, false, context).toString();
    }

    @Override
    public String dump(BaseDescr base, ConstraintConnectiveDescr parent, MVELDumperContext context) {
        return this.dump(new StringBuilder(), base, parent, 0, 0, false, context).toString();
    }

    @Override
    public String dump(BaseDescr base, int parentPrecedence) {
        return this.dump(new StringBuilder(), base, parentPrecedence, false, this.createContext()).toString();
    }

    @Override
    public StringBuilder dump(StringBuilder sbuilder, BaseDescr base, int parentPriority, boolean isInsideRelCons, MVELDumperContext context) {
        return this.dump(sbuilder, base, null, 0, parentPriority, false, context);
    }

    @Override
    public StringBuilder dump(StringBuilder sbuilder, BaseDescr base, ConstraintConnectiveDescr parent, int parentIndex, int parentPriority, boolean isInsideRelCons, MVELDumperContext context) {
        if (context == null) {
            context = this.createContext();
        }
        if (base instanceof ConstraintConnectiveDescr) {
            this.processConnectiveDescr(sbuilder, base, parent, parentPriority, isInsideRelCons, context);
        } else if (base instanceof AtomicExprDescr) {
            this.processAtomicExpression(sbuilder, context, (AtomicExprDescr)base, parent, parentIndex);
        } else if (base instanceof BindingDescr) {
            this.processBinding(sbuilder, (BindingDescr)base, parent, isInsideRelCons, context);
        } else if (base instanceof RelationalExprDescr) {
            this.processRelationalExpression(sbuilder, (RelationalExprDescr)base, parent, context);
        } else if (base instanceof ExprConstraintDescr) {
            this.processConstraint(sbuilder, (ExprConstraintDescr)base, isInsideRelCons, context);
        }
        return sbuilder;
    }

    private void processConstraint(StringBuilder sbuilder, ExprConstraintDescr base, boolean isInsideRelCons, MVELDumperContext context) {
        DrlExprParser expr = new DrlExprParser();
        ConstraintConnectiveDescr result = expr.parse(base.getExpression());
        if (result.getDescrs().size() == 1) {
            this.dump(sbuilder, result.getDescrs().get(0), 0, isInsideRelCons, context);
        } else {
            this.dump(sbuilder, result, 0, isInsideRelCons, context);
        }
    }

    private String[] processAtomicExpression(StringBuilder sbuilder, MVELDumperContext context, AtomicExprDescr atomicExpr, ConstraintConnectiveDescr parent, int parentIdx) {
        String expr = atomicExpr.getExpression().trim();
        expr = this.processEval(expr);
        String[] constrAndExpr = this.processImplicitConstraints(expr, atomicExpr, parent, parentIdx, context);
        sbuilder.append(context.isCcdNested() ? constrAndExpr[0] + constrAndExpr[1] : constrAndExpr[1]);
        return constrAndExpr;
    }

    private void processBinding(StringBuilder sbuilder, BindingDescr bind, ConstraintConnectiveDescr parent, boolean isInsideRelCons, MVELDumperContext context) {
        String expr = bind.getExpression().trim();
        AtomicExprDescr atomicExpr = new AtomicExprDescr(expr);
        String[] constrAndExpr = this.processImplicitConstraints(expr, atomicExpr, parent, parent.getDescrs().indexOf(bind), context);
        if (isInsideRelCons) {
            sbuilder.append(constrAndExpr[0]).append(constrAndExpr[1]);
        } else if (constrAndExpr[0].length() > 4) {
            sbuilder.append(constrAndExpr[0].substring(0, constrAndExpr[0].length() - 4));
        }
        if (bind.getExpression().equals(bind.getBindingField())) {
            bind.setExpressionAndBindingField(constrAndExpr[1]);
        } else {
            bind.setExpression(constrAndExpr[1]);
        }
        context.addBinding(bind);
    }

    private void processRelationalExpression(StringBuilder sbuilder, RelationalExprDescr red, ConstraintConnectiveDescr parent, MVELDumperContext context) {
        int idx = parent.getDescrs().indexOf(red);
        StringBuilder left = this.dump(new StringBuilder(), red.getLeft(), parent, idx, Integer.MAX_VALUE, true, context);
        StringBuilder right = red.getRight() instanceof AtomicExprDescr ? this.processRightAtomicExpr(left, (AtomicExprDescr)red.getRight(), parent, idx, context) : this.dump(new StringBuilder(), red.getRight(), parent, idx, Integer.MAX_VALUE, true, context);
        this.processRestriction(context, sbuilder, left.toString(), red.getOperatorDescr(), right.toString());
    }

    private StringBuilder processRightAtomicExpr(StringBuilder left, AtomicExprDescr atomicExpr, ConstraintConnectiveDescr parent, int parentIdx, MVELDumperContext context) {
        String expr = atomicExpr.getExpression().trim();
        expr = this.processEval(expr);
        String[] constrAndExpr = this.processImplicitConstraints(expr, atomicExpr, parent, parentIdx, context);
        left.insert(0, constrAndExpr[0]);
        return new StringBuilder(constrAndExpr[1]);
    }

    String[] processImplicitConstraints(String expr, AtomicExprDescr atomicExpr, ConstraintConnectiveDescr parent, int parentIdx, MVELDumperContext context) {
        boolean hasQuotes = expr.indexOf(34) >= 0;
        String[] constrAndExpr = new String[]{"", expr};
        int sharpPos = hasQuotes ? StringUtils.indexOfOutOfQuotes((String)expr, (char)'#') : expr.indexOf(35);
        int nullSafePos = hasQuotes ? StringUtils.indexOfOutOfQuotes((String)expr, (String)"!.") : expr.indexOf("!.");
        int j = 0;
        while (sharpPos > 0 || nullSafePos > 0) {
            if (nullSafePos < 0 || sharpPos > 0 && sharpPos < nullSafePos) {
                String[] castAndExpr = this.processInlineCast(expr, atomicExpr, parent, context, sharpPos, parentIdx, j++);
                expr = castAndExpr[1];
                constrAndExpr = new String[]{constrAndExpr[0] + castAndExpr[0], expr};
            } else {
                String[] nullCheckAndExpr = this.processNullSafeDereferencing(expr, atomicExpr, parent, nullSafePos, parentIdx, j++);
                expr = nullCheckAndExpr[1];
                constrAndExpr = new String[]{constrAndExpr[0] + nullCheckAndExpr[0], expr};
            }
            sharpPos = hasQuotes ? StringUtils.indexOfOutOfQuotes((String)expr, (char)'#') : expr.indexOf(35);
            nullSafePos = hasQuotes ? StringUtils.indexOfOutOfQuotes((String)expr, (String)"!.") : expr.indexOf("!.");
        }
        return new String[]{constrAndExpr[0], this.processInferredCast(constrAndExpr[1], atomicExpr, context)};
    }

    private String[] processInlineCast(String expr, AtomicExprDescr atomicExpr, ConstraintConnectiveDescr ccd, MVELDumperContext context, int sharpPos, int parentIdx, int childIdx) {
        String field1 = expr.substring(0, sharpPos).trim();
        int sharpPos2 = expr.indexOf(35, sharpPos + 1);
        String part2 = sharpPos2 < 0 ? expr.substring(sharpPos + 1).trim() : expr.substring(sharpPos + 1, sharpPos2).trim();
        String[] classAndField = this.splitInClassAndField(part2, context);
        if (classAndField == null) {
            return new String[]{"", expr};
        }
        if (classAndField.length == 1) {
            return new String[]{"", field1 + " instanceof " + classAndField[0]};
        }
        String className = classAndField[0];
        String field2 = classAndField[1];
        String castedExpression = "((" + className + ")" + field1 + ")." + field2 + (sharpPos2 > 0 ? expr.substring(sharpPos2) : "");
        RelationalExprDescr check = new RelationalExprDescr("instanceof", false, null, new AtomicExprDescr(field1), new AtomicExprDescr(className));
        String innerCheck = "";
        if (ccd.getConnective() == ConnectiveType.AND || ccd.getConnective() == ConnectiveType.INC_AND) {
            ccd.getDescrs().add(childIdx, check);
        } else {
            BaseDescr desc = ccd.getDescrs().get(parentIdx);
            if (desc instanceof ConstraintConnectiveDescr) {
                ((ConstraintConnectiveDescr)desc).getDescrs().add(childIdx, check);
            } else {
                ConstraintConnectiveDescr localAnd = new ConstraintConnectiveDescr(ConnectiveType.AND);
                BaseDescr original = ccd.getDescrs().remove(parentIdx);
                localAnd.getDescrs().add(check);
                localAnd.getDescrs().add(original);
                ccd.getDescrs().add(parentIdx, localAnd);
            }
        }
        innerCheck = check.toString() + " && ";
        atomicExpr.setRewrittenExpression(castedExpression);
        return new String[]{innerCheck, castedExpression};
    }

    private String processInferredCast(String expr, AtomicExprDescr atomicExpr, MVELDumperContext context) {
        if (context == null) {
            return expr;
        }
        Map.Entry<String, String> castEntry = context.getInferredCast(expr);
        if (castEntry == null) {
            return expr;
        }
        String castedExpr = "((" + castEntry.getValue() + ")" + castEntry.getKey() + ")" + expr.substring(castEntry.getKey().length());
        atomicExpr.setRewrittenExpression(castedExpr);
        return castedExpr;
    }

    private String[] processNullSafeDereferencing(String expr, AtomicExprDescr atomicExpr, ConstraintConnectiveDescr ccd, int nullSafePos, int parentIdx, int childIdx) {
        String field1 = expr.substring(0, nullSafePos).trim();
        expr = field1 + "." + expr.substring(nullSafePos + 2).trim();
        RelationalExprDescr check = new RelationalExprDescr("!=", false, null, new AtomicExprDescr(this.getPreconditionsToAppend(field1)), new AtomicExprDescr("null"));
        String innerCheck = "";
        if (ccd.getConnective() == ConnectiveType.AND || ccd.getConnective() == ConnectiveType.INC_AND) {
            ccd.getDescrs().add(childIdx, check);
        } else {
            BaseDescr desc = ccd.getDescrs().get(parentIdx);
            if (desc instanceof ConstraintConnectiveDescr) {
                ((ConstraintConnectiveDescr)desc).getDescrs().add(childIdx, check);
            } else {
                ConstraintConnectiveDescr localAnd = new ConstraintConnectiveDescr(ConnectiveType.AND);
                BaseDescr original = ccd.getDescrs().remove(parentIdx);
                localAnd.getDescrs().add(check);
                localAnd.getDescrs().add(original);
                ccd.getDescrs().add(parentIdx, localAnd);
            }
        }
        innerCheck = check.toString() + " && ";
        String[] nullCheckAndExpr = new String[]{innerCheck, expr};
        atomicExpr.setRewrittenExpression(expr);
        return nullCheckAndExpr;
    }

    private String getPreconditionsToAppend(String field1) {
        int parenthesisDepth = 0;
        int squareDepth = 0;
        String precondition = field1;
        block7: for (int i = field1.length() - 1; i >= 0; --i) {
            switch (field1.charAt(i)) {
                case '(': {
                    if (--parenthesisDepth >= 0) continue block7;
                    return field1.substring(i + 1, field1.length()).trim();
                }
                case ')': {
                    ++parenthesisDepth;
                    continue block7;
                }
                case '[': {
                    if (--squareDepth >= 0) continue block7;
                    return field1.substring(i + 1, field1.length()).trim();
                }
                case ']': {
                    ++squareDepth;
                    continue block7;
                }
                case ',': {
                    if (squareDepth != 0 || parenthesisDepth != 0) continue block7;
                    return field1.substring(i + 1, field1.length()).trim();
                }
            }
        }
        return field1;
    }

    private String processEval(String expr) {
        return evalRegexp.matcher(expr).find() ? expr.substring(expr.indexOf(40) + 1, expr.lastIndexOf(41)) : expr;
    }

    private String[] splitInClassAndField(String expr, MVELDumperContext context) {
        String[] split = expr.split("\\.");
        if (split.length < 2) {
            return new String[]{expr};
        }
        if (split[0].endsWith("!")) {
            split[0] = split[0].substring(0, split[0].length() - 1);
        }
        if (split.length < 3) {
            return split;
        }
        if (context == null || DialectUtil.findClassByName(context.getRuleContext(), split[0]) != null) {
            return new String[]{split[0], this.concatDotSeparated(split, 1, split.length)};
        }
        CompositeClassLoader cl = context.getRuleContext().getPackageBuilder().getRootClassLoader();
        for (int i = split.length - 1; i > 1; ++i) {
            String className = this.concatDotSeparated(split, 0, i);
            if (className.endsWith("!")) {
                className = className.substring(0, className.length() - 1);
            }
            if (ClassUtils.findClass((String)className, (ClassLoader)cl) == null) continue;
            return new String[]{className, this.concatDotSeparated(split, i, split.length)};
        }
        return null;
    }

    private String concatDotSeparated(String[] parts, int start, int end) {
        StringBuilder sb = new StringBuilder(parts[start]);
        for (int i = start + 1; i < end; ++i) {
            sb.append(".").append(parts[i]);
        }
        return sb.toString();
    }

    protected void processConnectiveDescr(StringBuilder sbuilder, BaseDescr base, ConstraintConnectiveDescr parent, int parentPriority, boolean isInsideRelCons, MVELDumperContext context) {
        boolean wrapParenthesis;
        ConstraintConnectiveDescr ccd = (ConstraintConnectiveDescr)base;
        boolean bl = wrapParenthesis = parentPriority > ccd.getConnective().getPrecedence();
        if (wrapParenthesis) {
            sbuilder.append("( ");
        }
        boolean first = true;
        ArrayList<BaseDescr> descrs = new ArrayList<BaseDescr>(ccd.getDescrs());
        boolean j = false;
        for (BaseDescr constr : descrs) {
            if (!(constr instanceof BindingDescr)) {
                if (first) {
                    first = false;
                } else {
                    sbuilder.append(" ");
                    sbuilder.append(ccd.getConnective().toString());
                    sbuilder.append(" ");
                }
            }
            context.incOpenCcd();
            this.dump(sbuilder, constr, ccd, ccd.getDescrs().indexOf(constr), ccd.getConnective().getPrecedence(), isInsideRelCons, context);
            context.decOpenCcd();
        }
        if (first) {
            sbuilder.append("true");
        }
        if (wrapParenthesis) {
            sbuilder.append(" )");
        }
    }

    @Override
    public void processRestriction(MVELDumperContext context, StringBuilder sbuilder, String left, OperatorDescr operator, String right) {
        Operator op = Operator.determineOperator((String)operator.getOperator(), (boolean)operator.isNegated());
        if (op == Operator.determineOperator((String)"memberOf", (boolean)operator.isNegated())) {
            int lastAndPos = left.lastIndexOf("&&");
            if (lastAndPos > 0) {
                sbuilder.append(left.substring(0, lastAndPos).trim()).append(" && ");
                left = left.substring(lastAndPos + 2).trim();
            }
            sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(right).append(" contains ").append(left).append(this.evaluatorSufix(operator.isNegated()));
        } else if (op == Operator.determineOperator((String)"contains", (boolean)operator.isNegated())) {
            sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(left).append(" contains ").append(right).append(this.evaluatorSufix(operator.isNegated()));
        } else if (op == Operator.determineOperator((String)"excludes", (boolean)operator.isNegated())) {
            sbuilder.append(this.evaluatorPrefix(!operator.isNegated())).append(left).append(" contains ").append(right).append(this.evaluatorSufix(!operator.isNegated()));
        } else if (op == Operator.determineOperator((String)"matches", (boolean)operator.isNegated())) {
            sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(left).append(" ~= ").append(right).append(this.evaluatorSufix(operator.isNegated()));
        } else if (this.lookupBasicOperator(operator.getOperator())) {
            if (operator.getOperator().equals("instanceof")) {
                context.addInferredCast(left, right);
            }
            this.rewriteBasicOperator(sbuilder, left, operator, right);
        } else {
            this.rewriteOperator(context, sbuilder, left, operator, right);
        }
    }

    protected void rewriteBasicOperator(StringBuilder sbuilder, String left, OperatorDescr operator, String right) {
        sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(left).append(" ").append(operator.getOperator()).append(" ").append(right).append(this.evaluatorSufix(operator.isNegated()));
    }

    protected boolean lookupBasicOperator(String op) {
        return Arrays.binarySearch(standard, op) >= 0;
    }

    protected void rewriteOperator(MVELDumperContext context, StringBuilder sbuilder, String left, OperatorDescr operator, String right) {
        String alias = context.createAlias(operator);
        operator.setLeftString(left);
        operator.setRightString(right);
        sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(alias).append(".evaluate( ").append(left).append(", ").append(right).append(" )").append(this.evaluatorSufix(operator.isNegated()));
    }

    protected String evaluatorPrefix(boolean isNegated) {
        if (isNegated) {
            return "!( ";
        }
        return "";
    }

    protected String evaluatorSufix(boolean isNegated) {
        if (isNegated) {
            return " )";
        }
        return "";
    }

    protected MVELDumperContext createContext() {
        return new MVELDumperContext();
    }

    @Override
    public Class<?> getEvaluatorWrapperClass() {
        return EvaluatorWrapper.class;
    }

    static {
        Arrays.sort(standard);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MVELDumperContext {
        protected Map<String, OperatorDescr> aliases = new HashMap<String, OperatorDescr>();
        protected int counter = 0;
        protected List<BindingDescr> bindings = null;
        protected Map<String, Class<?>> localTypes = null;
        private RuleBuildContext ruleContext;
        private Map<String, String> inferredCasts;
        private int openCcd = 0;

        public void clear() {
            this.aliases.clear();
            this.counter = 0;
            this.bindings = null;
            this.localTypes = null;
            this.openCcd = 0;
        }

        public void addInferredCast(String var, String cast) {
            if (this.inferredCasts == null) {
                this.inferredCasts = new HashMap<String, String>();
            }
            this.inferredCasts.put(var, cast);
        }

        public Map.Entry<String, String> getInferredCast(String expr) {
            if (this.inferredCasts != null) {
                for (Map.Entry<String, String> entry : this.inferredCasts.entrySet()) {
                    if (!expr.matches(entry.getKey() + "\\s*\\..+")) continue;
                    return entry;
                }
            }
            return null;
        }

        public Map<String, OperatorDescr> getAliases() {
            return this.aliases;
        }

        public void setAliases(Map<String, OperatorDescr> aliases) {
            this.aliases = aliases;
        }

        public String createAlias(OperatorDescr operator) {
            String alias = operator.getOperator() + this.counter++;
            operator.setAlias(alias);
            this.aliases.put(alias, operator);
            return alias;
        }

        public void addBinding(BindingDescr bind) {
            if (this.bindings == null) {
                this.bindings = new ArrayList<BindingDescr>();
            }
            this.bindings.add(bind);
        }

        public List<BindingDescr> getBindings() {
            return this.bindings == null ? Collections.EMPTY_LIST : this.bindings;
        }

        public Map<String, Class<?>> getLocalTypes() {
            return this.localTypes;
        }

        public void setLocalTypes(Map<String, Class<?>> localTypes) {
            this.localTypes = localTypes;
        }

        public RuleBuildContext getRuleContext() {
            return this.ruleContext;
        }

        public MVELDumperContext setRuleContext(RuleBuildContext ruleContext) {
            this.ruleContext = ruleContext;
            return this;
        }

        public void incOpenCcd() {
            ++this.openCcd;
        }

        public void decOpenCcd() {
            --this.openCcd;
        }

        public boolean isCcdNested() {
            return this.openCcd > 0;
        }
    }
}

