/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.shared.preferences.config;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.uberfire.ext.preferences.shared.PreferenceScopeTypes;
import org.uberfire.ext.preferences.shared.UsernameProvider;
import org.uberfire.ext.preferences.shared.impl.exception.InvalidPreferenceScopeException;

public class WorkbenchPreferenceScopeTypes
implements PreferenceScopeTypes {
    private Map<String, DefaultKey> defaultKeyByType;
    private UsernameProvider usernameProvider;

    protected WorkbenchPreferenceScopeTypes() {
    }

    @Inject
    public WorkbenchPreferenceScopeTypes(UsernameProvider usernameProvider) {
        this.usernameProvider = usernameProvider;
        this.defaultKeyByType = new HashMap<String, DefaultKey>();
        this.defaultKeyByType.put("global", () -> "global");
        this.defaultKeyByType.put("user", () -> ((UsernameProvider)usernameProvider).get());
        this.defaultKeyByType.put("project", null);
    }

    public boolean typeRequiresKey(String type) throws InvalidPreferenceScopeException {
        this.validateType(type);
        return this.defaultKeyByType.get(type) == null;
    }

    public String getDefaultKeyFor(String type) throws InvalidPreferenceScopeException {
        this.validateType(type);
        DefaultKey defaultKey = this.defaultKeyByType.get(type);
        if (defaultKey == null) {
            throw new InvalidPreferenceScopeException("The type " + type + " does not have a default key.");
        }
        return defaultKey.get();
    }

    protected void validateType(String type) throws InvalidPreferenceScopeException {
        if (this.isEmpty(type)) {
            throw new InvalidPreferenceScopeException("Type must be a non empty string.");
        }
        if (!this.defaultKeyByType.containsKey(type)) {
            throw new InvalidPreferenceScopeException("Invalid preference scope type.");
        }
    }

    protected boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    protected static interface DefaultKey {
        public String get();
    }
}

