/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.vm.impl;

import com.google.gwt.core.client.impl.WeakMapping;
import com.google.web.bindery.autobean.shared.Splittable;
import com.google.web.bindery.autobean.shared.impl.HasSplittable;
import com.google.web.bindery.autobean.shared.impl.StringQuoter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonSplittable
implements Splittable,
HasSplittable {
    private JSONArray array;
    private Boolean bool;
    private boolean isNull;
    private Double number;
    private JSONObject obj;
    private String string;
    private final Map<String, Object> reified = new HashMap<String, Object>();

    public static JsonSplittable create() {
        return new JsonSplittable(new JSONObject());
    }

    public static Splittable create(String payload) {
        try {
            switch (payload.charAt(0)) {
                case '{': {
                    return new JsonSplittable(new JSONObject(payload));
                }
                case '[': {
                    return new JsonSplittable(new JSONArray(payload));
                }
                case '\"': {
                    return new JsonSplittable(new JSONArray("[" + payload + "]").getString(0));
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return new JsonSplittable(Double.parseDouble(payload));
                }
                case 'f': 
                case 't': {
                    return new JsonSplittable(Boolean.parseBoolean(payload));
                }
                case 'n': {
                    return null;
                }
            }
            throw new RuntimeException("Could not parse payload: payload[0] = " + payload.charAt(0));
        }
        catch (JSONException e) {
            throw new RuntimeException("Could not parse payload", e);
        }
    }

    public static Splittable createIndexed() {
        return new JsonSplittable(new JSONArray());
    }

    public static Splittable createNull() {
        return new JsonSplittable();
    }

    private static String[] getNames(JSONObject json) {
        int length = json.length();
        if (length == 0) {
            return null;
        }
        String[] names = new String[length];
        Iterator i = json.keys();
        int j = 0;
        while (i.hasNext()) {
            names[j++] = (String)i.next();
        }
        return names;
    }

    private JsonSplittable() {
        this.isNull = true;
    }

    private JsonSplittable(boolean value) {
        this.bool = value;
    }

    private JsonSplittable(double value) {
        this.number = value;
    }

    private JsonSplittable(JSONArray array) {
        this.array = array;
    }

    private JsonSplittable(JSONObject obj) {
        this.obj = obj;
    }

    private JsonSplittable(String string) {
        this.array = null;
        this.obj = null;
        this.string = string;
    }

    @Override
    public boolean asBoolean() {
        return this.bool;
    }

    @Override
    public double asNumber() {
        return this.number;
    }

    @Override
    public void assign(Splittable parent, int index) {
        try {
            ((JsonSplittable)parent).array.put(index, this.value());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void assign(Splittable parent, String propertyName) {
        try {
            ((JsonSplittable)parent).obj.put(propertyName, this.value());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String asString() {
        return this.string;
    }

    @Override
    public Splittable deepCopy() {
        return JsonSplittable.create(this.getPayload());
    }

    @Override
    public Splittable get(int index) {
        try {
            return this.makeSplittable(this.array.get(index));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Splittable get(String key) {
        try {
            return this.makeSplittable(this.obj.get(key));
        }
        catch (JSONException e) {
            throw new RuntimeException(key, e);
        }
    }

    @Override
    public String getPayload() {
        if (this.isNull) {
            return "null";
        }
        if (this.obj != null) {
            return this.obj.toString();
        }
        if (this.array != null) {
            return this.array.toString();
        }
        if (this.string != null) {
            return StringQuoter.quote(this.string);
        }
        if (this.number != null) {
            return String.valueOf(this.number);
        }
        if (this.bool != null) {
            return String.valueOf(this.bool);
        }
        throw new RuntimeException("No data in this JsonSplittable");
    }

    @Override
    public List<String> getPropertyKeys() {
        String[] names = JsonSplittable.getNames(this.obj);
        if (names == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(names));
    }

    @Override
    public Object getReified(String key) {
        return this.reified.get(key);
    }

    @Override
    public Splittable getSplittable() {
        return this;
    }

    @Override
    public boolean isBoolean() {
        return this.bool != null;
    }

    @Override
    public boolean isIndexed() {
        return this.array != null;
    }

    @Override
    public boolean isKeyed() {
        return this.obj != null;
    }

    @Override
    public boolean isNull(int index) {
        return this.array.isNull(index);
    }

    @Override
    public boolean isNull(String key) {
        return !this.obj.has(key) || this.obj.isNull(key);
    }

    @Override
    public boolean isNumber() {
        return this.number != null;
    }

    @Override
    public boolean isReified(String key) {
        return this.reified.containsKey(key);
    }

    @Override
    public boolean isString() {
        return this.string != null;
    }

    @Override
    public boolean isUndefined(String key) {
        return !this.obj.has(key);
    }

    @Override
    public void setReified(String key, Object object) {
        this.reified.put(key, object);
    }

    @Override
    public void setSize(int size) {
        JSONArray newArray = new JSONArray();
        for (int i = 0; i < size; ++i) {
            try {
                newArray.put(i, this.array.get(i));
                continue;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        this.array = newArray;
    }

    @Override
    public int size() {
        return this.array.length();
    }

    public String toString() {
        return this.getPayload();
    }

    private synchronized JsonSplittable makeSplittable(Object object) {
        if (JSONObject.NULL.equals(object)) {
            return null;
        }
        JsonSplittable seen = (JsonSplittable)WeakMapping.get(object, JsonSplittable.class.getName());
        if (seen == null) {
            if (object instanceof JSONObject) {
                seen = new JsonSplittable((JSONObject)object);
                WeakMapping.setWeak(object, JsonSplittable.class.getName(), seen);
            } else if (object instanceof JSONArray) {
                seen = new JsonSplittable((JSONArray)object);
                WeakMapping.setWeak(object, JsonSplittable.class.getName(), seen);
            } else if (object instanceof String) {
                seen = new JsonSplittable(object.toString());
            } else if (object instanceof Number) {
                seen = new JsonSplittable(((Number)object).doubleValue());
            } else if (object instanceof Boolean) {
                seen = new JsonSplittable((Boolean)object);
            } else {
                throw new RuntimeException("Unhandled type " + object.getClass());
            }
        }
        return seen;
    }

    private Object value() {
        if (this.isNull) {
            return null;
        }
        if (this.obj != null) {
            return this.obj;
        }
        if (this.array != null) {
            return this.array;
        }
        if (this.string != null) {
            return this.string;
        }
        if (this.number != null) {
            return this.number;
        }
        if (this.bool != null) {
            return this.bool;
        }
        throw new RuntimeException("No data");
    }
}

