/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.server;

import com.google.gwt.dev.asm.Type;
import com.google.web.bindery.autobean.vm.impl.TypeUtils;
import com.google.web.bindery.requestfactory.server.ServiceLayerDecorator;
import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.ProxyFor;
import com.google.web.bindery.requestfactory.shared.ProxyForName;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.Service;
import com.google.web.bindery.requestfactory.shared.ServiceName;
import com.google.web.bindery.requestfactory.vm.impl.Deobfuscator;
import com.google.web.bindery.requestfactory.vm.impl.OperationKey;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResolverServiceLayer
extends ServiceLayerDecorator {
    private static Deobfuscator deobfuscator;

    ResolverServiceLayer() {
    }

    private static synchronized void updateDeobfuscator(Class<? extends RequestFactory> clazz, ClassLoader resolveClassesWith) {
        Deobfuscator.Builder builder = Deobfuscator.Builder.load(clazz, resolveClassesWith);
        if (deobfuscator != null) {
            builder.merge(deobfuscator);
        }
        deobfuscator = builder.build();
    }

    @Override
    public ClassLoader getDomainClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public Class<? extends BaseProxy> resolveClass(String typeToken) {
        String deobfuscated = deobfuscator.getTypeFromToken(typeToken);
        if (deobfuscated == null) {
            this.die(null, "No type for token %s", typeToken);
        }
        return this.forName(deobfuscated).asSubclass(BaseProxy.class);
    }

    @Override
    public <T> Class<? extends T> resolveClientType(Class<?> domainClass, Class<T> clientClass, boolean required) {
        if (List.class.isAssignableFrom(domainClass)) {
            return List.class.asSubclass(clientClass);
        }
        if (Set.class.isAssignableFrom(domainClass)) {
            return Set.class.asSubclass(clientClass);
        }
        if (TypeUtils.isValueType(domainClass)) {
            return domainClass.asSubclass(clientClass);
        }
        for (Class<?> toSearch = domainClass; toSearch != null; toSearch = toSearch.getSuperclass()) {
            List<String> clientTypes = deobfuscator.getClientProxies(toSearch.getName());
            if (clientTypes == null) continue;
            for (String clientType : clientTypes) {
                Class<?> proxy = this.forName(clientType);
                if (!clientClass.isAssignableFrom(proxy)) continue;
                return proxy.asSubclass(clientClass);
            }
        }
        if (required) {
            this.die(null, "The domain type %s cannot be sent to the client", domainClass.getCanonicalName());
        }
        return null;
    }

    @Override
    public Class<?> resolveDomainClass(Class<?> clazz) {
        if (List.class.equals(clazz)) {
            return List.class;
        }
        if (Set.class.equals(clazz)) {
            return Set.class;
        }
        if (BaseProxy.class.isAssignableFrom(clazz)) {
            ProxyFor pf = clazz.getAnnotation(ProxyFor.class);
            if (pf != null) {
                return pf.value();
            }
            ProxyForName pfn = clazz.getAnnotation(ProxyForName.class);
            if (pfn != null) {
                Class<?> toReturn = this.forName(pfn.value());
                return toReturn;
            }
        }
        return (Class)this.die(null, "Could not resolve a domain type for client type %s", clazz.getCanonicalName());
    }

    @Override
    public Method resolveDomainMethod(String operation) {
        Exception ex;
        String domainDescriptor = deobfuscator.getDomainMethodDescriptor(operation);
        if (domainDescriptor == null) {
            return (Method)this.die(null, "No domain method descriptor is mapped to operation %s", operation);
        }
        Class<?>[] domainArgs = this.getArgumentTypes(domainDescriptor);
        Class<? extends RequestContext> requestContext = this.getTop().resolveRequestContext(operation);
        Class<?> serviceImplementation = this.getTop().resolveServiceClass(requestContext);
        Method requestContextMethod = this.getTop().resolveRequestContextMethod(operation);
        try {
            return serviceImplementation.getMethod(requestContextMethod.getName(), domainArgs);
        }
        catch (SecurityException e) {
            ex = e;
        }
        catch (NoSuchMethodException e) {
            ex = e;
        }
        return (Method)this.die(ex, "Could not find method in implementation %s matching descriptor %s for operation %s", serviceImplementation.getCanonicalName(), domainDescriptor, operation);
    }

    @Override
    public Class<? extends RequestContext> resolveRequestContext(String operation) {
        String requestContextClass = deobfuscator.getRequestContext(operation);
        if (requestContextClass == null) {
            this.die(null, "No RequestContext for operation %s", operation);
        }
        return this.forName(requestContextClass).asSubclass(RequestContext.class);
    }

    @Override
    public Method resolveRequestContextMethod(String operation) {
        Class<? extends RequestContext> searchIn = this.getTop().resolveRequestContext(operation);
        String methodName = deobfuscator.getRequestContextMethodName(operation);
        String descriptor = deobfuscator.getRequestContextMethodDescriptor(operation);
        Class<?>[] params = this.getArgumentTypes(descriptor);
        try {
            return searchIn.getMethod(methodName, params);
        }
        catch (NoSuchMethodException ex) {
            return (Method)this.report("Could not locate %s operation %s", RequestContext.class.getSimpleName(), operation);
        }
    }

    @Override
    public Class<? extends RequestFactory> resolveRequestFactory(String binaryName) {
        Class<RequestFactory> toReturn = this.forName(binaryName).asSubclass(RequestFactory.class);
        ResolverServiceLayer.updateDeobfuscator(toReturn, this.getTop().getDomainClassLoader());
        return toReturn;
    }

    @Override
    public Class<?> resolveServiceClass(Class<? extends RequestContext> requestContextClass) {
        ServiceName sn;
        Class<?> searchIn = null;
        Service s = requestContextClass.getAnnotation(Service.class);
        if (s != null) {
            searchIn = s.value();
        }
        if ((sn = requestContextClass.getAnnotation(ServiceName.class)) != null) {
            searchIn = this.forName(sn.value());
        }
        if (searchIn == null) {
            this.die(null, "The %s type %s did not specify a service type", RequestContext.class.getSimpleName(), requestContextClass.getCanonicalName());
        }
        return searchIn;
    }

    @Override
    public String resolveTypeToken(Class<? extends BaseProxy> clazz) {
        return OperationKey.hash(clazz.getName());
    }

    private Class<?> forName(String name) {
        try {
            return Class.forName(name, false, this.getTop().getDomainClassLoader());
        }
        catch (ClassNotFoundException e) {
            return (Class)this.die(e, "Could not locate class %s", name);
        }
    }

    private Class<?>[] getArgumentTypes(String descriptor) {
        Type[] types = Type.getArgumentTypes(descriptor);
        Class[] params = new Class[types.length];
        int j = types.length;
        for (int i = 0; i < j; ++i) {
            params[i] = this.getClass(types[i]);
        }
        return params;
    }

    private Class<?> getClass(Type type) {
        switch (type.getSort()) {
            case 1: {
                return Boolean.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 10: {
                return this.forName(type.getClassName());
            }
            case 4: {
                return Short.TYPE;
            }
            case 0: {
                return Void.TYPE;
            }
            case 9: {
                return (Class)this.die(null, "Unsupported Type used in operation descriptor %s", type.getDescriptor());
            }
        }
        return (Class)this.die(null, "Unhandled Type: %s", type.getDescriptor());
    }
}

