/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.backend.repositories.SystemRepository;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.repositories.NewBranchEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.java.nio.file.FileSystem;

@ApplicationScoped
public class ConfiguredRepositories {
    private ConfigurationService configurationService;
    private RepositoryFactory repositoryFactory;
    private Repository systemRepository;
    private Map<String, Repository> repositoriesByAlias = new HashMap<String, Repository>();
    private Map<Path, Repository> repositoriesByBranchRoot = new HashMap<Path, Repository>();

    public ConfiguredRepositories() {
    }

    @Inject
    public ConfiguredRepositories(ConfigurationService configurationService, RepositoryFactory repositoryFactory, @Named(value="system") Repository systemRepository) {
        this.configurationService = configurationService;
        this.repositoryFactory = repositoryFactory;
        this.systemRepository = systemRepository;
    }

    @PostConstruct
    public void loadRepositories() {
        this.repositoriesByAlias.clear();
        this.repositoriesByBranchRoot.clear();
        List repoConfigs = this.configurationService.getConfiguration(ConfigType.REPOSITORY);
        if (repoConfigs != null && !repoConfigs.isEmpty()) {
            for (ConfigGroup configGroup : repoConfigs) {
                Repository repository = this.repositoryFactory.newRepository(configGroup);
                this.add(repository);
            }
        }
    }

    public Repository getRepositoryByRepositoryAlias(String alias) {
        return this.repositoriesByAlias.get(alias);
    }

    public Repository getRepositoryByRepositoryFileSystem(FileSystem fs) {
        if (fs == null) {
            return null;
        }
        if (Paths.convert((Path)this.systemRepository.getRoot()).getFileSystem().equals(fs)) {
            return this.systemRepository;
        }
        for (Repository repository : this.repositoriesByAlias.values()) {
            if (!Paths.convert((Path)repository.getRoot()).getFileSystem().equals(fs)) continue;
            return repository;
        }
        return null;
    }

    public Repository getRepositoryByRootPath(Path root) {
        return this.repositoriesByBranchRoot.get(root);
    }

    public List<Repository> getAllConfiguredRepositories() {
        return new ArrayList<Repository>(this.repositoriesByAlias.values());
    }

    public boolean containsAlias(String alias) {
        return this.repositoriesByAlias.containsKey(alias) || SystemRepository.SYSTEM_REPO.getAlias().equals(alias);
    }

    public void add(Repository repository) {
        this.repositoriesByAlias.put(repository.getAlias(), repository);
        if (repository instanceof GitRepository && repository.getBranches() != null) {
            for (String branch : repository.getBranches()) {
                this.repositoriesByBranchRoot.put(repository.getBranchRoot(branch), repository);
            }
        } else {
            this.repositoriesByBranchRoot.put(repository.getRoot(), repository);
        }
    }

    public void update(Repository updatedRepo) {
        this.add(updatedRepo);
    }

    public Repository remove(String alias) {
        Repository removed = this.repositoriesByAlias.remove(alias);
        this.removeFromRootByAlias(alias);
        return removed;
    }

    private void removeFromRootByAlias(String alias) {
        for (Path path : this.findFromRootMapByAlias(alias)) {
            this.repositoriesByBranchRoot.remove(path);
        }
    }

    private List<Path> findFromRootMapByAlias(String alias) {
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path path : this.repositoriesByBranchRoot.keySet()) {
            if (!this.repositoriesByBranchRoot.get(path).getAlias().equals(alias)) continue;
            result.add(path);
        }
        return result;
    }

    public void onNewBranch(@Observes NewBranchEvent changedEvent) {
        Repository repository;
        if (this.repositoriesByAlias.containsKey(changedEvent.getRepositoryAlias()) && (repository = this.getRepositoryByRepositoryAlias(changedEvent.getRepositoryAlias())) instanceof GitRepository) {
            ((GitRepository)repository).addBranch(changedEvent.getBranchName(), changedEvent.getBranchPath());
            this.repositoriesByBranchRoot.put(changedEvent.getBranchPath(), repository);
        }
    }

    public void flush(@Observes @org.guvnor.structure.backend.config.Repository SystemRepositoryChangedEvent changedEvent) {
        this.loadRepositories();
    }
}

