/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import org.apache.helix.HelixManager;
import org.apache.helix.task.Task;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.TaskResult;
import org.apache.helix.task.TaskUtil;
import org.apache.log4j.Logger;

public class TaskRunner
implements Runnable {
    private static final Logger LOG = Logger.getLogger(TaskRunner.class);
    private final HelixManager _manager;
    private final String _taskName;
    private final String _taskPartition;
    private final String _sessionId;
    private final String _instance;
    private final Object _startedSync = new Object();
    private final Object _doneSync = new Object();
    private final Task _task;
    private volatile TaskResult _result = null;
    private volatile boolean _started = false;
    private volatile boolean _timeout = false;
    private volatile boolean _done = false;

    public TaskRunner(Task task, String taskName, String taskPartition, String instance, HelixManager manager, String sessionId) {
        this._task = task;
        this._taskName = taskName;
        this._taskPartition = taskPartition;
        this._instance = instance;
        this._manager = manager;
        this._sessionId = sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            this.signalStarted();
            try {
                this._result = this._task.run();
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable t) {
                LOG.error((Object)"Problem running the task", t);
                this._result = new TaskResult(TaskResult.Status.ERROR, null);
            }
            switch (this._result.getStatus()) {
                case COMPLETED: {
                    this.requestStateTransition(TaskPartitionState.COMPLETED);
                    return;
                }
                case CANCELED: {
                    if (!this._timeout) return;
                    this.requestStateTransition(TaskPartitionState.TIMED_OUT);
                    return;
                }
                case ERROR: {
                    this.requestStateTransition(TaskPartitionState.TASK_ERROR);
                    return;
                }
                default: {
                    throw new AssertionError((Object)"Unknown result type.");
                }
            }
        }
        catch (Exception e) {
            this.requestStateTransition(TaskPartitionState.TASK_ERROR);
            return;
        }
        finally {
            Object object = this._doneSync;
            synchronized (object) {
                this._done = true;
                this._doneSync.notifyAll();
            }
        }
    }

    public void timeout() {
        if (!this._done) {
            this._timeout = true;
            this.cancel();
        }
    }

    public void cancel() {
        this._task.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillStarted() {
        Object object = this._startedSync;
        synchronized (object) {
            while (!this._started) {
                try {
                    this._startedSync.wait();
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)String.format("Interrupted while waiting for task %s to start.", this._taskPartition), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult waitTillDone() {
        Object object = this._doneSync;
        synchronized (object) {
            while (!this._done) {
                try {
                    this._doneSync.wait();
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)String.format("Interrupted while waiting for task %s to complete.", this._taskPartition), (Throwable)e);
                }
            }
        }
        return this._result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalStarted() {
        Object object = this._startedSync;
        synchronized (object) {
            this._started = true;
            this._startedSync.notifyAll();
        }
    }

    private void requestStateTransition(TaskPartitionState state) {
        boolean success = TaskUtil.setRequestedState(this._manager.getHelixDataAccessor(), this._instance, this._sessionId, this._taskName, this._taskPartition, state);
        if (!success) {
            LOG.error((Object)String.format("Failed to set the requested state to %s for instance %s, session id %s, task partition %s.", new Object[]{state, this._instance, this._sessionId, this._taskPartition}));
        }
    }
}

