/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.commons.backend.oracle.PackageDataModelOracleImpl;
import org.drools.workbench.models.commons.backend.oracle.ProjectDataModelOracleImpl;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.model.Package;
import org.kie.workbench.common.services.datamodel.backend.server.cache.LRUDataModelOracleCache;
import org.kie.workbench.common.services.datamodel.backend.server.cache.LRUProjectDataModelOracleCache;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.validation.PortablePreconditions;

@ApplicationScoped
public class DataModelServiceImpl
implements DataModelService {
    private LRUDataModelOracleCache cachePackages;
    private LRUProjectDataModelOracleCache cacheProjects;
    private KieProjectService projectService;

    @Inject
    public DataModelServiceImpl(@Named(value="PackageDataModelOracleCache") LRUDataModelOracleCache cachePackages, @Named(value="ProjectDataModelOracleCache") LRUProjectDataModelOracleCache cacheProjects, KieProjectService projectService) {
        this.cachePackages = cachePackages;
        this.cacheProjects = cacheProjects;
        this.projectService = projectService;
    }

    public PackageDataModelOracle getDataModel(Path resourcePath) {
        try {
            PortablePreconditions.checkNotNull((String)"resourcePath", (Object)resourcePath);
            KieProject project = this.resolveProject(resourcePath);
            Package pkg = this.resolvePackage(resourcePath);
            if (project == null) {
                return new PackageDataModelOracleImpl();
            }
            PackageDataModelOracle oracle = this.cachePackages.assertPackageDataModelOracle(project, pkg);
            return oracle;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public ProjectDataModelOracle getProjectDataModel(Path resourcePath) {
        try {
            PortablePreconditions.checkNotNull((String)"resourcePath", (Object)resourcePath);
            KieProject project = this.resolveProject(resourcePath);
            if (project == null) {
                return new ProjectDataModelOracleImpl();
            }
            ProjectDataModelOracle oracle = this.cacheProjects.assertProjectDataModelOracle(project);
            return oracle;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private KieProject resolveProject(Path resourcePath) {
        return (KieProject)this.projectService.resolveProject(resourcePath);
    }

    private Package resolvePackage(Path resourcePath) {
        return this.projectService.resolvePackage(resourcePath);
    }
}

