/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.jcrExport.asset;

import java.util.Arrays;
import org.drools.guvnor.server.contenthandler.drools.DRLFileContentHandler;
import org.drools.workbench.jcr2vfsmigration.jcrExport.asset.AssetExporter;
import org.drools.workbench.jcr2vfsmigration.jcrExport.asset.BaseAssetExporter;
import org.drools.workbench.jcr2vfsmigration.jcrExport.asset.ExportContext;
import org.drools.workbench.jcr2vfsmigration.util.ExportUtils;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.PlainTextAsset;

public class PlainTextAssetWithPackagePropertyExporter
extends BaseAssetExporter
implements AssetExporter<PlainTextAsset, ExportContext> {
    @Override
    public PlainTextAsset export(ExportContext exportContext) {
        String format = exportContext.getJcrAssetItem().getFormat();
        StringBuilder sb = new StringBuilder();
        if (Arrays.asList("drl", "dslr").contains(format) && this.isStandaloneRule(exportContext.getJcrAssetItem().getContent())) {
            sb.append("rule \"" + exportContext.getJcrAssetItem().getName() + "\"");
            sb.append(this.getExtendExpression(exportContext.getJcrModule(), exportContext.getJcrAssetItem(), ""));
            sb.append("\n");
            sb.append("\n");
            sb.append(exportContext.getJcrAssetItem().getContent());
            sb.append("\n");
            sb.append("\n");
            sb.append("end");
        } else {
            sb.append(exportContext.getJcrAssetItem().getContent());
            sb.append("\n");
        }
        String content = sb.toString();
        if ("dsl".equals(format) || "dslr".equals(format) || "template".equals(format) || "drl".equals(format) || "function".equals(format)) {
            content = ExportUtils.migrateStartOfCommentChar(content);
        }
        return new PlainTextAsset(exportContext.getJcrAssetItem().getName(), format, exportContext.getJcrAssetItem().getLastContributor(), exportContext.getJcrAssetItem().getCheckinComment(), exportContext.getJcrAssetItem().getLastModified().getTime(), content);
    }

    private boolean isStandaloneRule(String drl) {
        return DRLFileContentHandler.isStandAloneRule((String)drl);
    }
}

