/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.factmodel;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.factmodel.AnnotationMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.NoSpaceKeyPressHandler;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.messages.Constants;

public class AnnotationEditorPopup {
    private static final RegExp VALID_NAME = RegExp.compile((String)"^[a-zA-Z][a-zA-Z\\d]*$");
    private final AnnotationMetaModel annotation;
    private final List<AnnotationMetaModel> annotations;
    private final TextBox txtName = new TextBox();
    private final TextBox txtKey = new TextBox();
    private final TextBox txtValue = new TextBox();
    private Command okCommand;

    public AnnotationEditorPopup(List<AnnotationMetaModel> annotations) {
        this(new AnnotationMetaModel(), annotations);
    }

    public AnnotationEditorPopup(AnnotationMetaModel annotation, List<AnnotationMetaModel> annotations) {
        this.annotation = annotation;
        this.annotations = annotations;
    }

    public AnnotationMetaModel getAnnotation() {
        return this.annotation;
    }

    public void setOkCommand(Command okCommand) {
        this.okCommand = okCommand;
    }

    public void show() {
        final FormStylePopup pop = new FormStylePopup();
        VerticalPanel vp = new VerticalPanel();
        Grid g = new Grid(2, 3);
        this.txtName.addKeyPressHandler((KeyPressHandler)new NoSpaceKeyPressHandler());
        this.txtKey.addKeyPressHandler((KeyPressHandler)new NoSpaceKeyPressHandler());
        g.setWidget(0, 0, (Widget)new HTML("<b>Name</b>"));
        g.setWidget(1, 0, (Widget)this.txtName);
        g.setWidget(0, 1, (Widget)new HTML("<b>Key</b>"));
        g.setWidget(1, 1, (Widget)this.txtKey);
        g.setWidget(0, 2, (Widget)new HTML("<b>Value</b>"));
        g.setWidget(1, 2, (Widget)this.txtValue);
        this.setControlValues(this.annotation);
        Button btnOK = new Button(Constants.INSTANCE.OK());
        btnOK.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String name = AnnotationEditorPopup.this.txtName.getText();
                if (!this.isNameValid(name)) {
                    Window.alert((String)Constants.INSTANCE.InvalidModelName(name));
                    return;
                }
                if (this.doesTheNameExist(name)) {
                    Window.alert((String)Constants.INSTANCE.NameTakenForModel(name));
                    return;
                }
                if (this.annotationAlreadyHasAName() && this.annotationNameHasChanged(name)) {
                    if (this.isTheUserSureHeWantsToChangeTheName()) {
                        this.setNameAndClose();
                    }
                } else {
                    this.setNameAndClose();
                }
            }

            private boolean isNameValid(String name) {
                if (name == null || "".equals(name)) {
                    return false;
                }
                return VALID_NAME.test(name);
            }

            private boolean annotationAlreadyHasAName() {
                return ((AnnotationEditorPopup)AnnotationEditorPopup.this).annotation.name != null && ((AnnotationEditorPopup)AnnotationEditorPopup.this).annotation.name.length() > 0;
            }

            private boolean annotationNameHasChanged(String name) {
                return !name.equals(((AnnotationEditorPopup)AnnotationEditorPopup.this).annotation.name);
            }

            private void setNameAndClose() {
                String name = AnnotationEditorPopup.this.txtName.getText();
                String key = AnnotationEditorPopup.this.txtKey.getText();
                if (key == null || key.length() == 0) {
                    key = "value";
                }
                String value = AnnotationEditorPopup.this.txtValue.getText();
                ((AnnotationEditorPopup)AnnotationEditorPopup.this).annotation.name = name;
                AnnotationEditorPopup.this.annotation.getValues().clear();
                AnnotationEditorPopup.this.annotation.getValues().put(key, value);
                AnnotationEditorPopup.this.okCommand.execute();
                pop.hide();
            }

            private boolean isTheUserSureHeWantsToChangeTheName() {
                return Window.confirm((String)Constants.INSTANCE.ModelNameChangeWarning());
            }

            private boolean doesTheNameExist(String name) {
                for (AnnotationMetaModel a : AnnotationEditorPopup.this.annotations) {
                    if (a == AnnotationEditorPopup.this.annotation || !a.name.equals(name)) continue;
                    return true;
                }
                return false;
            }
        });
        vp.add((Widget)g);
        vp.add((Widget)btnOK);
        pop.addRow((Widget)vp);
        pop.show();
    }

    private void setControlValues(AnnotationMetaModel annotation) {
        String name = annotation.name == null ? "" : annotation.name;
        String key = this.getFirstEntry(annotation.getValues().keySet());
        String value = this.getFirstEntry(annotation.getValues().values());
        this.txtName.setText(name);
        this.txtKey.setText(key);
        this.txtValue.setText(value);
    }

    private String getFirstEntry(Collection<String> values) {
        if (values.isEmpty()) {
            return "";
        }
        return values.iterator().next();
    }
}

