/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.factmodel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactEditorPopup;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactFieldsEditor;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.ModelNameHelper;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.guvnor.client.util.AbstractLazyStackPanelHeader;

public class FactModelEditor
extends AbstractLazyStackPanelHeader {
    private static FactModelEditorBinder uiBinder = (FactModelEditorBinder)GWT.create(FactModelEditorBinder.class);
    @UiField
    Image icon;
    @UiField
    Label titleLabel;
    @UiField
    Image editIcon;
    @UiField
    Image moveUpIcon;
    @UiField
    Image moveDownIcon;
    @UiField
    Image deleteIcon;
    private final FactMetaModel factMetaModel;
    private final List<FactMetaModel> superTypeFactModels;
    private final ModelNameHelper modelNameHelper;
    private Command deleteEvent;
    private Command moveUpCommand;
    private Command moveDownCommand;

    public FactModelEditor(FactMetaModel factMetaModel, List<FactMetaModel> superTypeFactModels, ModelNameHelper modelNameHelper) {
        this.factMetaModel = factMetaModel;
        this.superTypeFactModels = superTypeFactModels;
        this.modelNameHelper = modelNameHelper;
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.titleLabel.setText(this.getTitleText());
        ClickHandler expandClickHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                FactModelEditor.this.onTitleClicked();
            }
        };
        this.icon.addClickHandler(expandClickHandler);
        this.titleLabel.addClickHandler(expandClickHandler);
        this.setIconImage();
        this.moveUpIcon.setTitle(Constants.INSTANCE.MoveUp());
        this.moveDownIcon.setTitle(Constants.INSTANCE.MoveDown());
        this.deleteIcon.setTitle(Constants.INSTANCE.RemoveThisFactType());
        this.addOpenHandler((OpenHandler)new OpenHandler<AbstractLazyStackPanelHeader>(){

            public void onOpen(OpenEvent<AbstractLazyStackPanelHeader> event) {
                FactModelEditor.this.expanded = true;
                FactModelEditor.this.setIconImage();
            }
        });
        this.addCloseHandler((CloseHandler)new CloseHandler<AbstractLazyStackPanelHeader>(){

            public void onClose(CloseEvent<AbstractLazyStackPanelHeader> event) {
                FactModelEditor.this.expanded = false;
                FactModelEditor.this.setIconImage();
            }
        });
    }

    private String getTitleText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.factMetaModel.getName());
        if (this.factMetaModel.hasSuperType()) {
            sb.append(" extends ");
            sb.append(this.factMetaModel.getSuperType());
        }
        return sb.toString();
    }

    @UiHandler(value={"editIcon"})
    void editIconClick(ClickEvent event) {
        FactEditorPopup popup = new FactEditorPopup(this.factMetaModel, this.superTypeFactModels, this.modelNameHelper);
        popup.setOkCommand(new Command(){

            public void execute() {
                FactModelEditor.this.titleLabel.setText(FactModelEditor.this.getTitleText());
            }
        });
        popup.show();
    }

    @UiHandler(value={"moveUpIcon"})
    void moveUpClick(ClickEvent event) {
        this.moveUpCommand.execute();
    }

    @UiHandler(value={"moveDownIcon"})
    void moveDownClick(ClickEvent event) {
        this.moveDownCommand.execute();
    }

    @UiHandler(value={"deleteIcon"})
    void deleteClick(ClickEvent event) {
        for (FactMetaModel fmm : this.superTypeFactModels) {
            if (!fmm.hasSuperType() || !fmm.getSuperType().equals(this.factMetaModel.getName())) continue;
            Window.confirm((String)Constants.INSTANCE.CannotDeleteADeclarationThatIsASuperType());
            return;
        }
        if (Window.confirm((String)Constants.INSTANCE.AreYouSureYouWantToRemoveThisFact())) {
            this.deleteEvent.execute();
        }
    }

    private void setIconImage() {
        if (this.expanded) {
            this.icon.setResource(DroolsGuvnorImageResources.INSTANCE.collapseExpand().collapse());
            this.icon.setAltText(Constants.INSTANCE.Collapse());
        } else {
            this.icon.setResource(DroolsGuvnorImageResources.INSTANCE.collapseExpand().expand());
            this.icon.setAltText(Constants.INSTANCE.Expand());
        }
    }

    public void setDeleteEvent(Command deleteEvent) {
        this.deleteEvent = deleteEvent;
    }

    public void setMoveDownCommand(Command moveDownCommand) {
        this.moveDownCommand = moveDownCommand;
    }

    public void setMoveUpCommand(Command moveUpCommand) {
        this.moveUpCommand = moveUpCommand;
    }

    public void setUpVisible(boolean visible) {
        this.moveUpIcon.setVisible(visible);
    }

    public void setDownVisible(boolean visible) {
        this.moveDownIcon.setVisible(visible);
    }

    public void expand() {
        if (!this.expanded) {
            this.onTitleClicked();
        }
    }

    public void collapse() {
        if (this.expanded) {
            this.onTitleClicked();
        }
    }

    private void onTitleClicked() {
        if (this.expanded) {
            CloseEvent.fire((HasCloseHandlers)this, (Object)((Object)this));
        } else {
            OpenEvent.fire((HasOpenHandlers)this, (Object)((Object)this));
        }
    }

    public FactMetaModel getFactModel() {
        return this.factMetaModel;
    }

    public Widget getContent() {
        return new FactFieldsEditor(this.factMetaModel.getFields(), this.factMetaModel.getAnnotations(), this.modelNameHelper);
    }

    static interface FactModelEditorBinder
    extends UiBinder<Widget, FactModelEditor> {
    }
}

