/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.factmodel;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FieldMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.ModelNameHelper;
import org.drools.guvnor.client.asseteditor.drools.factmodel.NoSpaceKeyPressHandler;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.messages.Constants;

public class FieldEditorPopup {
    private static final RegExp VALID_NAME = RegExp.compile((String)"^[a-zA-Z][a-zA-Z\\d_$]*$");
    private static final RegExp VALID_DATATYPE = RegExp.compile((String)"^([a-zA-Z][a-zA-Z\\d_$]*\\.)*[a-zA-Z][a-zA-Z\\d_$]*$");
    private final FieldMetaModel field;
    private final List<FieldMetaModel> fields;
    private final ModelNameHelper modelNameHelper;
    private Command okCommand;

    public FieldEditorPopup(List<FieldMetaModel> fields, ModelNameHelper modelNameHelper) {
        this(new FieldMetaModel(), fields, modelNameHelper);
    }

    public FieldEditorPopup(FieldMetaModel field, List<FieldMetaModel> fields, ModelNameHelper modelNameHelper) {
        this.field = field;
        this.fields = fields;
        this.modelNameHelper = modelNameHelper;
    }

    public FieldMetaModel getField() {
        return this.field;
    }

    public void setOkCommand(Command okCommand) {
        this.okCommand = okCommand;
    }

    public void show() {
        final FormStylePopup pop = new FormStylePopup();
        final TextBox fieldName = new TextBox();
        final TextBox fieldType = new TextBox();
        fieldName.addKeyPressHandler((KeyPressHandler)new NoSpaceKeyPressHandler());
        fieldType.addKeyPressHandler((KeyPressHandler)new NoSpaceKeyPressHandler());
        if (this.field != null) {
            fieldName.setText(this.field.name);
            fieldType.setText(this.field.type);
        }
        HorizontalPanel typeP = new HorizontalPanel();
        typeP.add((Widget)fieldType);
        final ListBox typeChoice = new ListBox();
        typeChoice.addItem(Constants.INSTANCE.chooseType());
        for (Map.Entry<String, String> entry : this.modelNameHelper.getTypeDescriptions().entrySet()) {
            typeChoice.addItem(entry.getValue(), entry.getKey());
        }
        typeChoice.setSelectedIndex(0);
        typeChoice.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                fieldType.setText(typeChoice.getValue(typeChoice.getSelectedIndex()));
            }
        });
        typeP.add((Widget)typeChoice);
        pop.addAttribute(Constants.INSTANCE.FieldNameAttribute(), (Widget)fieldName);
        pop.addAttribute(Constants.INSTANCE.Type(), (Widget)typeP);
        Button ok = new Button(Constants.INSTANCE.OK());
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String dataType = fieldType.getText();
                if (!this.isDataTypeValid(dataType)) {
                    Window.alert((String)Constants.INSTANCE.InvalidDataTypeName(dataType));
                    return;
                }
                String name = fieldName.getText();
                if (!this.isNameValid(name)) {
                    Window.alert((String)Constants.INSTANCE.InvalidModelName(name));
                    return;
                }
                if (this.doesTheNameExist(name)) {
                    Window.alert((String)Constants.INSTANCE.NameTakenForModel(name));
                    return;
                }
                if (this.factModelAlreadyHasAName(name)) {
                    if (this.isTheUserSureHeWantsToChangeTheName()) {
                        this.setNameAndClose();
                    }
                } else {
                    this.setNameAndClose();
                }
            }

            private boolean isDataTypeValid(String dataType) {
                if (dataType == null || "".equals(dataType)) {
                    return false;
                }
                return VALID_DATATYPE.test(dataType);
            }

            private boolean isNameValid(String name) {
                if (name == null || "".equals(name)) {
                    return false;
                }
                return VALID_NAME.test(name);
            }

            private boolean factModelAlreadyHasAName(String name) {
                return ((FieldEditorPopup)FieldEditorPopup.this).field.name != null && !((FieldEditorPopup)FieldEditorPopup.this).field.name.equals(name);
            }

            private void setNameAndClose() {
                ((FieldEditorPopup)FieldEditorPopup.this).field.name = fieldName.getText();
                ((FieldEditorPopup)FieldEditorPopup.this).field.type = fieldType.getText();
                FieldEditorPopup.this.okCommand.execute();
                pop.hide();
            }

            private boolean isTheUserSureHeWantsToChangeTheName() {
                return Window.confirm((String)Constants.INSTANCE.ModelNameChangeWarning());
            }

            private boolean doesTheNameExist(String name) {
                if (((FieldEditorPopup)FieldEditorPopup.this).field.name != null && ((FieldEditorPopup)FieldEditorPopup.this).field.name.equals(name)) {
                    return false;
                }
                for (FieldMetaModel f : FieldEditorPopup.this.fields) {
                    if (!f.name.equals(name)) continue;
                    return true;
                }
                return false;
            }
        });
        pop.addAttribute("", (Widget)ok);
        pop.show();
    }
}

