/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.HumanReadable;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.CEPTimeParameterTextBox;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.OperatorSelection;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.OperatorsCss;
import org.drools.guvnor.client.resources.OperatorsResource;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.HasParameterizedOperator;

public class CEPOperatorsDropdown
extends Composite
implements HasValueChangeHandlers<OperatorSelection> {
    private static final OperatorsResource resources = (OperatorsResource)GWT.create(OperatorsResource.class);
    private static final OperatorsCss css = resources.operatorsCss();
    private String[] operators;
    private Image btnAddCEPOperators;
    private ListBox box;
    private HorizontalPanel container = new HorizontalPanel();
    private TextBox[] parameters = new TextBox[4];
    protected int visibleParameterSet = 0;
    protected List<Integer> parameterSets;
    protected HasParameterizedOperator hop;
    private static final String VISIBLE_PARAMETER_SET = "org.drools.guvnor.client.modeldriven.ui.visibleParameterSet";
    private static final String CEP_OPERATOR_PARAMETER_GENERATOR = "org.drools.ide.common.server.util.CEPOperatorParameterDRLBuilder";

    public CEPOperatorsDropdown(String[] operators, HasParameterizedOperator hop) {
        this.operators = operators;
        this.hop = hop;
        this.parameterSets = SuggestionCompletionEngine.getCEPOperatorParameterSets((String)hop.getOperator());
        String vps = hop.getParameter(VISIBLE_PARAMETER_SET);
        if (vps != null) {
            try {
                this.visibleParameterSet = Integer.parseInt(vps);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = this.makeTextBox(i);
        }
        HorizontalPanel hp = new HorizontalPanel();
        hp.setStylePrimaryName(css.container());
        hp.add(this.getDropDown());
        hp.add(this.getOperatorExtension());
        this.initWidget((Widget)hp);
    }

    public void addItem(String item, String value) {
        this.box.addItem(item, value);
    }

    public int getSelectedIndex() {
        return this.box.getSelectedIndex();
    }

    public String getValue(int index) {
        return this.box.getValue(index);
    }

    private Widget getOperatorExtension() {
        this.container.setStylePrimaryName(css.container());
        this.btnAddCEPOperators = new Image(resources.clock());
        this.btnAddCEPOperators.setVisible(this.parameterSets.size() > 0);
        this.btnAddCEPOperators.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ++CEPOperatorsDropdown.this.visibleParameterSet;
                if (CEPOperatorsDropdown.this.visibleParameterSet == CEPOperatorsDropdown.this.parameterSets.size()) {
                    CEPOperatorsDropdown.this.visibleParameterSet = 0;
                }
                CEPOperatorsDropdown.this.hop.setParameter(CEPOperatorsDropdown.VISIBLE_PARAMETER_SET, Integer.toString(CEPOperatorsDropdown.this.visibleParameterSet));
                CEPOperatorsDropdown.this.displayParameters();
            }
        });
        this.container.add((Widget)this.btnAddCEPOperators);
        for (int i = 0; i < this.parameters.length; ++i) {
            this.container.add((Widget)this.parameters[i]);
        }
        return this.container;
    }

    private TextBox makeTextBox(int index) {
        CEPTimeParameterTextBox txt = new CEPTimeParameterTextBox(this.hop, index);
        if (this.parameterSets.size() == 0) {
            txt.setVisible(false);
        } else {
            txt.setVisible(index < this.parameterSets.get(this.visibleParameterSet));
        }
        return txt;
    }

    private void operatorChanged(OperatorSelection selection) {
        String operator = selection.getValue();
        if (SuggestionCompletionEngine.isCEPOperator((String)operator)) {
            this.container.setVisible(true);
            this.btnAddCEPOperators.setVisible(true);
            this.parameterSets = SuggestionCompletionEngine.getCEPOperatorParameterSets((String)operator);
            this.hop.setParameter("org.drools.ide.common.server.util.BRDRLPersistence.operatorParameterGenerator", CEP_OPERATOR_PARAMETER_GENERATOR);
        } else {
            this.visibleParameterSet = 0;
            this.container.setVisible(false);
            this.btnAddCEPOperators.setVisible(false);
            this.parameterSets = Collections.emptyList();
            this.hop.clearParameters();
        }
        this.displayParameters();
    }

    private void displayParameters() {
        if (this.parameterSets.size() == 0) {
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i].setVisible(false);
            }
        } else {
            for (int i = 0; i < this.parameters.length; ++i) {
                boolean isVisible;
                String key = Integer.toString(i);
                boolean bl = isVisible = i < this.parameterSets.get(this.visibleParameterSet);
                if (isVisible) {
                    String value = this.hop.getParameter(key);
                    if (value == null) {
                        value = "";
                        this.hop.setParameter(key, value);
                    }
                    this.parameters[i].setText(value);
                    this.parameters[i].setVisible(true);
                    continue;
                }
                this.hop.deleteParameter(key);
                this.parameters[i].setVisible(false);
            }
        }
    }

    private Widget getDropDown() {
        String selected = "";
        String selectedText = "";
        this.box = new ListBox();
        this.box.addItem(Constants.INSTANCE.pleaseChoose(), "");
        for (int i = 0; i < this.operators.length; ++i) {
            String op = this.operators[i];
            this.box.addItem(HumanReadable.getOperatorDisplayName(op), op);
            if (!op.equals(this.hop.getOperator())) continue;
            selected = op;
            selectedText = HumanReadable.getOperatorDisplayName(op);
            this.box.setSelectedIndex(i + 1);
        }
        final CEPOperatorsDropdown source = this;
        final OperatorSelection selection = new OperatorSelection(selected, selectedText);
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                CEPOperatorsDropdown.this.operatorChanged(selection);
                ValueChangeEvent.fire((HasValueChangeHandlers)source, (Object)selection);
            }
        });
        this.box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String selected = CEPOperatorsDropdown.this.box.getValue(CEPOperatorsDropdown.this.box.getSelectedIndex());
                String selectedText = CEPOperatorsDropdown.this.box.getItemText(CEPOperatorsDropdown.this.box.getSelectedIndex());
                OperatorSelection selection = new OperatorSelection(selected, selectedText);
                CEPOperatorsDropdown.this.operatorChanged(selection);
                ValueChangeEvent.fire((HasValueChangeHandlers)source, (Object)selection);
            }
        });
        return this.box;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<OperatorSelection> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }
}

