/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.common.DirtyableHorizontalPane;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleMetadata;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;

public class RuleAttributeWidget
extends Composite {
    public static final String SALIENCE_ATTR = "salience";
    public static final String ENABLED_ATTR = "enabled";
    public static final String DATE_EFFECTIVE_ATTR = "date-effective";
    public static final String DATE_EXPIRES_ATTR = "date-expires";
    public static final String NO_LOOP_ATTR = "no-loop";
    public static final String AGENDA_GROUP_ATTR = "agenda-group";
    public static final String ACTIVATION_GROUP_ATTR = "activation-group";
    public static final String DURATION_ATTR = "duration";
    public static final String TIMER_ATTR = "timer";
    public static final String CALENDARS_ATTR = "calendars";
    public static final String AUTO_FOCUS_ATTR = "auto-focus";
    public static final String LOCK_ON_ACTIVE_ATTR = "lock-on-active";
    public static final String RULEFLOW_GROUP_ATTR = "ruleflow-group";
    public static final String DIALECT_ATTR = "dialect";
    public static final String LOCK_LHS = "freeze_conditions";
    public static final String LOCK_RHS = "freeze_actions";
    public static final String DEFAULT_DIALECT = "mvel";
    private static final String TRUE_VALUE = "true";
    private static final String FALSE_VALUE = "false";
    private RuleModel model;
    private RuleModeller parent;

    public RuleAttributeWidget(RuleModeller parent, RuleModel model) {
        this.parent = parent;
        this.model = model;
        FormStyleLayout layout = new FormStyleLayout();
        RuleMetadata[] meta = model.metadataList;
        if (meta.length > 0) {
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new SmallLabel(Constants.INSTANCE.Metadata2()));
            layout.addRow((Widget)hp);
        }
        for (int i = 0; i < meta.length; ++i) {
            RuleMetadata rmd = meta[i];
            layout.addAttribute(rmd.attributeName, this.getEditorWidget(rmd, i));
        }
        RuleAttribute[] attrs = model.attributes;
        if (attrs.length > 0) {
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new SmallLabel(Constants.INSTANCE.Attributes1()));
            layout.addRow((Widget)hp);
        }
        for (int i = 0; i < attrs.length; ++i) {
            RuleAttribute at = attrs[i];
            layout.addAttribute(at.attributeName, this.getEditorWidget(at, i));
        }
        this.initWidget((Widget)layout);
    }

    public static ListBox getAttributeList() {
        ListBox list = new ListBox();
        list.addItem(Constants.INSTANCE.Choose());
        list.addItem(SALIENCE_ATTR);
        list.addItem(ENABLED_ATTR);
        list.addItem(DATE_EFFECTIVE_ATTR);
        list.addItem(DATE_EXPIRES_ATTR);
        list.addItem(NO_LOOP_ATTR);
        list.addItem(AGENDA_GROUP_ATTR);
        list.addItem(ACTIVATION_GROUP_ATTR);
        list.addItem(DURATION_ATTR);
        list.addItem(TIMER_ATTR);
        list.addItem(CALENDARS_ATTR);
        list.addItem(DURATION_ATTR);
        list.addItem(AUTO_FOCUS_ATTR);
        list.addItem(LOCK_ON_ACTIVE_ATTR);
        list.addItem(RULEFLOW_GROUP_ATTR);
        list.addItem(DIALECT_ATTR);
        return list;
    }

    private Widget getEditorWidget(RuleAttribute at, int idx) {
        Object editor = at.attributeName.equals(ENABLED_ATTR) || at.attributeName.equals(AUTO_FOCUS_ATTR) || at.attributeName.equals(LOCK_ON_ACTIVE_ATTR) || at.attributeName.equals(NO_LOOP_ATTR) ? this.checkBoxEditor(at) : this.textBoxEditor(at);
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        horiz.add(editor);
        horiz.add((Widget)this.getRemoveIcon(idx));
        return horiz;
    }

    private Widget getEditorWidget(RuleMetadata rm, int idx) {
        Object editor = rm.attributeName.equals(LOCK_LHS) || rm.attributeName.equals(LOCK_RHS) ? new InfoPopup(Constants.INSTANCE.FrozenAreas(), Constants.INSTANCE.FrozenExplanation()) : this.textBoxEditor(rm);
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        horiz.add((Widget)editor);
        horiz.add((Widget)this.getRemoveMetaIcon(idx));
        return horiz;
    }

    private Widget checkBoxEditor(final RuleAttribute at) {
        final CheckBox box = new CheckBox();
        if (at.value == null) {
            box.setValue(Boolean.valueOf(true));
            at.value = TRUE_VALUE;
        } else {
            box.setValue(Boolean.valueOf(at.value.equals(TRUE_VALUE)));
        }
        box.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                at.value = box.getValue() != false ? RuleAttributeWidget.TRUE_VALUE : RuleAttributeWidget.FALSE_VALUE;
            }
        });
        return box;
    }

    private TextBox textBoxEditor(final RuleAttribute at) {
        final TextBox box = new TextBox();
        box.setVisibleLength(at.value.length() < 3 ? 3 : at.value.length());
        box.setText(at.value);
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                at.value = box.getText();
            }
        });
        if (at.attributeName.equals(DATE_EFFECTIVE_ATTR) || at.attributeName.equals(DATE_EXPIRES_ATTR)) {
            if (at.value == null || "".equals(at.value)) {
                box.setText("");
            }
            box.setVisibleLength(10);
        }
        box.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                int length = box.getText().length();
                box.setVisibleLength(length > 0 ? length : 1);
            }
        });
        return box;
    }

    private TextBox textBoxEditor(final RuleMetadata rm) {
        final TextBox box = new TextBox();
        box.setVisibleLength(rm.value.length() < 3 ? 3 : rm.value.length());
        box.setText(rm.value);
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                rm.value = box.getText();
            }
        });
        box.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                box.setVisibleLength(box.getText().length());
            }
        });
        return box;
    }

    private Image getRemoveIcon(final int idx) {
        Image remove = new Image(DroolsGuvnorImageResources.INSTANCE.itemImages().deleteItemSmall());
        remove.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)Constants.INSTANCE.RemoveThisRuleOption())) {
                    RuleAttributeWidget.this.model.removeAttribute(idx);
                    RuleAttributeWidget.this.parent.refreshWidget();
                }
            }
        });
        return remove;
    }

    private Image getRemoveMetaIcon(final int idx) {
        Image remove = new Image(DroolsGuvnorImageResources.INSTANCE.itemImages().deleteItemSmall());
        remove.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)Constants.INSTANCE.RemoveThisRuleOption())) {
                    RuleAttributeWidget.this.model.removeMetadata(idx);
                    RuleAttributeWidget.this.parent.refreshWidget();
                }
            }
        });
        return remove;
    }
}

