/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.standalone;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.HashSet;
import org.drools.guvnor.client.asseteditor.MultiViewEditor;
import org.drools.guvnor.client.asseteditor.MultiViewEditorMenuBarCreator;
import org.drools.guvnor.client.asseteditor.drools.OryxMultiViewEditorMenuBarCreator;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModellerConfiguration;
import org.drools.guvnor.client.asseteditor.drools.standalone.RealAssetsMultiViewEditorMenuBarCreator;
import org.drools.guvnor.client.asseteditor.drools.standalone.TemporalAssetsMultiViewEditorMenuBarCreator;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.WorkingSetManager;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.StandaloneEditorInvocationParameters;
import org.drools.guvnor.client.rpc.StandaloneEditorService;
import org.drools.guvnor.client.rpc.StandaloneEditorServiceAsync;
import org.drools.guvnor.client.widgets.toolbar.ActionToolbarButtonsConfigurationProvider;
import org.drools.guvnor.client.widgets.toolbar.StandaloneEditorIndividualActionToolbarButtonsConfigurationProvider;

public class StandaloneEditorManager {
    private final ClientFactory clientFactory;
    private MultiViewEditor editor;
    private StandaloneEditorServiceAsync standaloneEditorService = (StandaloneEditorServiceAsync)GWT.create(StandaloneEditorService.class);
    private Asset[] assets;
    private final EventBus eventBus;

    public StandaloneEditorManager(ClientFactory clientFactory, EventBus eventBus) {
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
    }

    public Panel getBaseLayout() {
        String parametersUUID = Window.Location.getParameter((String)"pUUID");
        if (parametersUUID == null || parametersUUID.trim().equals("")) {
            return null;
        }
        this.setHooks(this);
        DockLayoutPanel mainLayout = new DockLayoutPanel(Style.Unit.EM);
        final ScrollPanel mainPanel = new ScrollPanel();
        mainLayout.add((Widget)mainPanel);
        this.standaloneEditorService.getInvocationParameters(parametersUUID, (AsyncCallback)new GenericCallback<StandaloneEditorInvocationParameters>(){

            public void onSuccess(final StandaloneEditorInvocationParameters parameters) {
                if (parameters.getAssetsToBeEdited().length == 0) {
                    Window.alert((String)Constants.INSTANCE.NoRulesFound());
                    return;
                }
                StandaloneEditorManager.access$002(StandaloneEditorManager.this, parameters.getAssetsToBeEdited());
                Command afterWorkingSetsAreAppliedCommand = new Command(){

                    public void execute() {
                        LoadingPopup.close();
                        RuleModellerConfiguration ruleModellerConfiguration = RuleModellerConfiguration.getDefault();
                        ruleModellerConfiguration.setHideLHS(parameters.isHideLHS());
                        ruleModellerConfiguration.setHideRHS(parameters.isHideRHS());
                        ruleModellerConfiguration.setHideAttributes(parameters.isHideAttributes());
                        Object editorMenuBarCreator = parameters.isTemporalAssets() ? new TemporalAssetsMultiViewEditorMenuBarCreator(new Command(){

                            public void execute() {
                                StandaloneEditorManager.this.afterSaveAndCloseCallbackFunction();
                            }
                        }, new Command(){

                            public void execute() {
                                StandaloneEditorManager.this.afterCancelButtonCallbackFunction();
                            }
                        }) : (parameters.getClientName().equalsIgnoreCase("oryx") ? new OryxMultiViewEditorMenuBarCreator(new Command(){

                            public void execute() {
                                StandaloneEditorManager.this.afterCloseButtonCallbackFunction();
                            }
                        }, new Command(){

                            public void execute() {
                                StandaloneEditorManager.this.beforeSaveAllCallbackFunction();
                            }
                        }, new Command(){

                            public void execute() {
                                StandaloneEditorManager.this.afterSaveAllCallbackFunction();
                            }
                        }) : new RealAssetsMultiViewEditorMenuBarCreator(new Command(){

                            public void execute() {
                                StandaloneEditorManager.this.afterCancelButtonCallbackFunction();
                            }
                        }));
                        StandaloneEditorManager.this.editor = new MultiViewEditor(parameters.getAssetsToBeEdited(), StandaloneEditorManager.this.clientFactory, StandaloneEditorManager.this.eventBus, (ActionToolbarButtonsConfigurationProvider)new StandaloneEditorIndividualActionToolbarButtonsConfigurationProvider(), (MultiViewEditorMenuBarCreator)editorMenuBarCreator);
                        StandaloneEditorManager.this.editor.setCloseCommand(new Command(){

                            public void execute() {
                                StandaloneEditorManager.this.afterSaveAndCloseCallbackFunction();
                            }
                        });
                        mainPanel.add((Widget)StandaloneEditorManager.this.editor);
                    }
                };
                HashSet<Asset> workingSetAssets = new HashSet<Asset>();
                if (parameters.getActiveTemporalWorkingSets() != null && parameters.getActiveTemporalWorkingSets().length > 0) {
                    workingSetAssets.addAll(Arrays.asList(parameters.getActiveTemporalWorkingSets()));
                }
                if (parameters.getActiveWorkingSets() != null && parameters.getActiveWorkingSets().length > 0) {
                    workingSetAssets.addAll(Arrays.asList(parameters.getActiveWorkingSets()));
                }
                if (!workingSetAssets.isEmpty()) {
                    WorkingSetManager.getInstance().setAutoVerifierEnabled(true);
                }
                WorkingSetManager.getInstance().applyWorkingSets(StandaloneEditorManager.this.assets[0].getMetaData().getModuleName(), workingSetAssets, afterWorkingSetsAreAppliedCommand);
            }
        });
        return mainLayout;
    }

    public void getDRLs() {
        if (this.assets == null || this.assets.length == 0) {
            this.returnDRL("");
        }
        this.standaloneEditorService.getAsstesDRL(this.assets, (AsyncCallback)new GenericCallback<String[]>(){

            public void onSuccess(String[] drls) {
                String result = "";
                if (drls != null) {
                    for (String drl : drls) {
                        result = result + drl + "\n\n";
                    }
                }
                StandaloneEditorManager.this.returnDRL(result);
            }
        });
    }

    public void getBRLs() {
        if (this.assets == null || this.assets.length == 0) {
            this.returnDRL("");
        }
        this.standaloneEditorService.getAsstesBRL(this.assets, (AsyncCallback)new GenericCallback<String[]>(){

            public void onSuccess(String[] drls) {
                String result = "";
                if (drls != null) {
                    for (String drl : drls) {
                        result = result + drl + "\n\n";
                    }
                }
                StandaloneEditorManager.this.returnBRL(result);
            }
        });
    }

    public String getAssetsUUIDs() {
        StringBuilder uuids = new StringBuilder("[");
        String separator = "";
        for (int i = 0; i < this.assets.length; ++i) {
            uuids.append(separator);
            uuids.append("'");
            uuids.append(this.assets[i].getUuid());
            uuids.append("'");
            if (!separator.equals("")) continue;
            separator = ",";
        }
        uuids.append("]");
        return uuids.toString();
    }

    public native void setHooks(StandaloneEditorManager var1);

    public native void returnDRL(String var1);

    public native void returnBRL(String var1);

    public native void afterSaveAndCloseCallbackFunction();

    public native void beforeSaveAllCallbackFunction();

    public native void afterSaveAllCallbackFunction();

    public native void afterCancelButtonCallbackFunction();

    public native void afterCloseButtonCallbackFunction();

    static /* synthetic */ Asset[] access$002(StandaloneEditorManager x0, Asset[] x1) {
        x0.assets = x1;
        return x1;
    }
}

