/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.moduleeditor.drools;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.ModuleNameValidator;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;

public class NewSubPackageWizard
extends FormStylePopup {
    private TextBox nameBox;
    private TextBox descBox;
    private RulePackageSelector parentPackage;
    private final FormStyleLayout importLayout = new FormStyleLayout();
    private final FormStyleLayout newPackageLayout = new FormStyleLayout();

    public NewSubPackageWizard(final Command afterCreatedEvent) {
        super(DroolsGuvnorImages.INSTANCE.Wizard(), Constants.INSTANCE.CreateANewSubPackage());
        this.nameBox = new TextBox();
        this.descBox = new TextBox();
        this.parentPackage = new RulePackageSelector();
        this.newPackageLayout.addAttribute(Constants.INSTANCE.NameColon(), (Widget)this.nameBox);
        this.newPackageLayout.addAttribute(Constants.INSTANCE.DescriptionColon(), (Widget)this.descBox);
        this.newPackageLayout.addAttribute(Constants.INSTANCE.ParentPackage(), (Widget)this.parentPackage);
        this.nameBox.setTitle(Constants.INSTANCE.PackageNameTip());
        RadioButton newPackage = new RadioButton("action", Constants.INSTANCE.CreateNewPackageRadio());
        RadioButton importPackage = new RadioButton("action", Constants.INSTANCE.ImportFromDrlRadio());
        newPackage.setValue(Boolean.valueOf(true));
        this.newPackageLayout.setVisible(true);
        newPackage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NewSubPackageWizard.this.newPackageLayout.setVisible(true);
                NewSubPackageWizard.this.importLayout.setVisible(false);
            }
        });
        this.setAfterShow(new Command(){

            public void execute() {
                NewSubPackageWizard.this.nameBox.setFocus(true);
            }
        });
        this.importLayout.setVisible(false);
        importPackage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NewSubPackageWizard.this.newPackageLayout.setVisible(false);
                NewSubPackageWizard.this.importLayout.setVisible(true);
            }
        });
        VerticalPanel ab = new VerticalPanel();
        ab.add((Widget)newPackage);
        ab.add((Widget)importPackage);
        this.addAttribute("", (Widget)ab);
        this.addRow((Widget)this.newPackageLayout);
        this.addRow((Widget)this.importLayout);
        this.importLayout.addAttribute(Constants.INSTANCE.DRLFileToImport(), NewSubPackageWizard.newImportWidget(afterCreatedEvent, this));
        this.importLayout.addRow((Widget)new HTML("<br/><b>" + Constants.INSTANCE.NoteNewPackageDrlImportWarning() + "</b>"));
        this.importLayout.addRow((Widget)new HTML(Constants.INSTANCE.ImportDRLDesc1()));
        this.importLayout.addRow((Widget)new HTML(Constants.INSTANCE.ImportDRLDesc2()));
        this.importLayout.addRow((Widget)new HTML(Constants.INSTANCE.ImportDRLDesc3()));
        Button create = new Button(Constants.INSTANCE.CreatePackage());
        create.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ModuleNameValidator.validatePackageName((String)NewSubPackageWizard.this.nameBox.getText())) {
                    NewSubPackageWizard.this.createSubPackageAction(NewSubPackageWizard.this.nameBox.getText(), NewSubPackageWizard.this.descBox.getText(), NewSubPackageWizard.this.parentPackage.getSelectedPackage(), afterCreatedEvent);
                    NewSubPackageWizard.this.hide();
                } else {
                    NewSubPackageWizard.this.nameBox.setText("");
                    Window.alert((String)Constants.INSTANCE.PackageNameCorrectHint());
                }
            }
        });
        this.newPackageLayout.addAttribute("", (Widget)create);
    }

    private void createSubPackageAction(final String name, String descr, String parentPackage, final Command refresh) {
        LoadingPopup.showMessage((String)Constants.INSTANCE.CreatingPackagePleaseWait());
        ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
        moduleService.createSubModule(name, descr, parentPackage, (AsyncCallback)new GenericCallback<String>(){

            public void onSuccess(String data) {
                RulePackageSelector.currentlySelectedPackage = name;
                LoadingPopup.close();
                refresh.execute();
            }
        });
    }

    public static Widget newImportWidget(final Command afterCreatedEvent, final FormStylePopup parent) {
        final FormPanel uploadFormPanel = new FormPanel();
        uploadFormPanel.setAction(GWT.getModuleBaseURL() + "package");
        uploadFormPanel.setEncoding("multipart/form-data");
        uploadFormPanel.setMethod("post");
        HorizontalPanel panel = new HorizontalPanel();
        uploadFormPanel.setWidget((Widget)panel);
        final FileUpload upload = new FileUpload();
        upload.setName("classicDRLFile");
        panel.add((Widget)upload);
        panel.add((Widget)new Label(Constants.INSTANCE.upload()));
        Image ok = DroolsGuvnorImages.INSTANCE.Upload();
        ok.setAltText(Constants.INSTANCE.Import());
        ClickHandler okClickHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)Constants.INSTANCE.ImportMergeWarning())) {
                    LoadingPopup.showMessage((String)Constants.INSTANCE.ImportingDRLPleaseWait());
                    uploadFormPanel.submit();
                }
            }
        };
        ok.addClickHandler(okClickHandler);
        panel.add((Widget)ok);
        Image image = new Image(DroolsGuvnorImageResources.INSTANCE.packageLarge());
        image.setAltText(Constants.INSTANCE.Package());
        final FormStylePopup packageNamePopup = new FormStylePopup(image, Constants.INSTANCE.PackageName());
        HorizontalPanel packageNamePanel = new HorizontalPanel();
        packageNamePopup.addRow((Widget)new Label(Constants.INSTANCE.ImportedDRLContainsNoNameForThePackage()));
        final TextBox packageName = new TextBox();
        packageNamePanel.add((Widget)new Label(Constants.INSTANCE.PackageName() + ":"));
        packageNamePanel.add((Widget)packageName);
        Button uploadWithNameButton = new Button(Constants.INSTANCE.OK());
        uploadWithNameButton.addClickHandler(okClickHandler);
        packageNamePanel.add((Widget)uploadWithNameButton);
        packageNamePopup.addRow((Widget)packageNamePanel);
        uploadFormPanel.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                if (event.getResults().indexOf("OK") > -1) {
                    LoadingPopup.close();
                    Window.alert((String)Constants.INSTANCE.PackageWasImportedSuccessfully());
                    afterCreatedEvent.execute();
                    parent.hide();
                    if (packageNamePopup != null) {
                        packageNamePopup.hide();
                    }
                } else if (event.getResults().indexOf("Missing package name.") > -1) {
                    LoadingPopup.close();
                    packageNamePopup.show();
                } else {
                    ErrorPopup.showMessage((String)Constants.INSTANCE.UnableToImportIntoThePackage0(event.getResults()));
                }
                LoadingPopup.close();
            }
        });
        uploadFormPanel.addSubmitHandler(new FormPanel.SubmitHandler(){

            public void onSubmit(FormPanel.SubmitEvent event) {
                if (upload.getFilename().length() == 0) {
                    Window.alert((String)Constants.INSTANCE.YouDidNotChooseADrlFileToImport());
                    event.cancel();
                } else if (!upload.getFilename().endsWith(".drl")) {
                    Window.alert((String)Constants.INSTANCE.YouCanOnlyImportDrlFiles());
                    event.cancel();
                } else if (packageName.getText() != null && !packageName.getText().equals("")) {
                    uploadFormPanel.setAction(uploadFormPanel.getAction() + "?packageName=" + packageName.getText());
                } else {
                    LoadingPopup.showMessage((String)Constants.INSTANCE.CreatingPackagePleaseWait());
                }
            }
        });
        return uploadFormPanel;
    }
}

