/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.moduleeditor.drools;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.shared.modules.ModuleHeader;
import org.drools.guvnor.shared.modules.ModuleHeaderHelper;

public class PackageHeaderWidget
extends Composite {
    private Module conf;
    private SimplePanel layout;
    private ListBox importList;
    private ListBox globalList;
    private boolean isHistoricalReadOnly = false;

    public PackageHeaderWidget(Module conf, boolean isHistoricalReadOnly) {
        this.conf = conf;
        this.isHistoricalReadOnly = isHistoricalReadOnly;
        this.layout = new SimplePanel();
        this.render();
        this.initWidget((Widget)this.layout);
    }

    private void render() {
        ModuleHeader mh = ModuleHeaderHelper.parseHeader((String)this.conf.getHeader());
        if (mh == null) {
            this.textEditorVersion();
        } else {
            this.basicEditorVersion(mh);
        }
    }

    private void basicEditorVersion(final ModuleHeader mh) {
        ImageButton newItemButton;
        ImageButton trashButton;
        ImageButton newItemButton2;
        this.layout.clear();
        HorizontalPanel main = new HorizontalPanel();
        VerticalPanel imports = new VerticalPanel();
        imports.add((Widget)new Label(Constants.INSTANCE.ImportedTypes()));
        this.importList = new ListBox(true);
        this.doImports(mh);
        HorizontalPanel importCols = new HorizontalPanel();
        importCols.add((Widget)this.importList);
        VerticalPanel importActions = new VerticalPanel();
        if (this.isHistoricalReadOnly) {
            newItemButton2 = new ImageButton(DroolsGuvnorImages.INSTANCE.NewItem(), DroolsGuvnorImages.INSTANCE.NewItemDisabled());
            newItemButton2.setEnabled(false);
            importActions.add((Widget)newItemButton2);
            trashButton = new ImageButton(DroolsGuvnorImages.INSTANCE.Trash(), DroolsGuvnorImages.INSTANCE.TrashDisabled());
            trashButton.setEnabled(false);
            importActions.add((Widget)trashButton);
        } else {
            newItemButton2 = new ImageButton(DroolsGuvnorImages.INSTANCE.NewItem(), DroolsGuvnorImages.INSTANCE.NewItemDisabled()){
                {
                    super(x0, x1);
                    this.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            PackageHeaderWidget.this.showTypeQuestion((Widget)event.getSource(), mh, false, Constants.INSTANCE.FactTypesJarTip());
                        }
                    });
                }
            };
            importActions.add((Widget)newItemButton2);
            trashButton = new ImageButton(DroolsGuvnorImages.INSTANCE.Trash(), DroolsGuvnorImages.INSTANCE.TrashDisabled()){
                {
                    super(x0, x1);
                    this.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            if (Window.confirm((String)Constants.INSTANCE.AreYouSureYouWantToRemoveThisFactType()) && PackageHeaderWidget.this.importList.getSelectedIndex() > -1) {
                                for (int i = 0; i < PackageHeaderWidget.this.importList.getItemCount(); ++i) {
                                    if (!PackageHeaderWidget.this.importList.isItemSelected(i)) continue;
                                    PackageHeaderWidget.this.importList.removeItem(i);
                                    mh.getImports().remove(i);
                                    --i;
                                }
                                PackageHeaderWidget.this.updateHeader(mh);
                            }
                        }
                    });
                }
            };
            importActions.add((Widget)trashButton);
        }
        importCols.add((Widget)importActions);
        imports.add((Widget)importCols);
        VerticalPanel globals = new VerticalPanel();
        globals.add((Widget)new Label(Constants.INSTANCE.Globals()));
        this.globalList = new ListBox(true);
        this.doGlobals(mh);
        HorizontalPanel globalCols = new HorizontalPanel();
        globalCols.add((Widget)this.globalList);
        VerticalPanel globalActions = new VerticalPanel();
        if (this.isHistoricalReadOnly) {
            newItemButton = new ImageButton(DroolsGuvnorImages.INSTANCE.NewItem(), DroolsGuvnorImages.INSTANCE.NewItemDisabled());
            newItemButton.setEnabled(false);
            globalActions.add((Widget)newItemButton);
            ImageButton trashButton2 = new ImageButton(DroolsGuvnorImages.INSTANCE.Trash(), DroolsGuvnorImages.INSTANCE.TrashDisabled());
            trashButton2.setEnabled(false);
            globalActions.add((Widget)trashButton2);
        } else {
            newItemButton = new ImageButton(DroolsGuvnorImages.INSTANCE.NewItem(), DroolsGuvnorImages.INSTANCE.NewItemDisabled()){
                {
                    super(x0, x1);
                    this.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            PackageHeaderWidget.this.showTypeQuestion((Widget)event.getSource(), mh, true, Constants.INSTANCE.GlobalTypesAreClassesFromJarFilesThatHaveBeenUploadedToTheCurrentPackage());
                        }
                    });
                }
            };
            globalActions.add((Widget)newItemButton);
            ImageButton trashButton3 = new ImageButton(DroolsGuvnorImages.INSTANCE.Trash(), DroolsGuvnorImages.INSTANCE.TrashDisabled()){
                {
                    super(x0, x1);
                    this.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            if (Window.confirm((String)Constants.INSTANCE.AreYouSureYouWantToRemoveThisGlobal()) && PackageHeaderWidget.this.globalList.getSelectedIndex() > -1) {
                                for (int i = 0; i < PackageHeaderWidget.this.globalList.getItemCount(); ++i) {
                                    if (!PackageHeaderWidget.this.globalList.isItemSelected(i)) continue;
                                    PackageHeaderWidget.this.globalList.removeItem(i);
                                    mh.getGlobals().remove(i);
                                    --i;
                                }
                                PackageHeaderWidget.this.updateHeader(mh);
                            }
                        }
                    });
                }
            };
            globalActions.add((Widget)trashButton3);
        }
        globalCols.add((Widget)globalActions);
        globals.add((Widget)globalCols);
        main.add((Widget)imports);
        main.add((Widget)new HTML("&nbsp;"));
        main.add((Widget)globals);
        Button advanced = new Button(){
            {
                this.setText(Constants.INSTANCE.AdvancedView());
                this.setTitle(Constants.INSTANCE.SwitchToTextModeEditing());
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (Window.confirm((String)Constants.INSTANCE.SwitchToAdvancedTextModeForPackageEditing())) {
                            PackageHeaderWidget.this.textEditorVersion();
                        }
                    }
                });
            }
        };
        main.add((Widget)advanced);
        this.layout.add((Widget)main);
    }

    private void textEditorVersion() {
        this.layout.clear();
        VerticalPanel main = new VerticalPanel();
        final TextArea area = new TextArea();
        if (this.isHistoricalReadOnly) {
            area.setEnabled(false);
        }
        area.setWidth("100%");
        area.setVisibleLines(8);
        area.setCharacterWidth(100);
        area.setText(this.conf.getHeader());
        area.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                PackageHeaderWidget.this.conf.setHeader(area.getText());
            }
        });
        main.add((Widget)area);
        Button basicMode = this.createBasicModeButton(area);
        main.add((Widget)basicMode);
        this.layout.add((Widget)main);
    }

    private Button createBasicModeButton(final TextArea area) {
        Button basicMode = new Button(){
            {
                this.setText(Constants.INSTANCE.BasicView());
                this.setTitle(Constants.INSTANCE.SwitchToGuidedModeEditing());
                this.addClickHandler(PackageHeaderWidget.this.createClickHanderForBasicModeButton(area));
            }
        };
        return basicMode;
    }

    private ClickHandler createClickHanderForBasicModeButton(final TextArea area) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                PackageHeaderWidget.this.conf.setHeader(area.getText());
                PackageHeaderWidget.this.handleCasesForBasicModeButton();
            }
        };
    }

    private void handleCasesForBasicModeButton() {
        ModuleHeader mh = ModuleHeaderHelper.parseHeader((String)this.conf.getHeader());
        if (mh == null) {
            Window.alert((String)Constants.INSTANCE.CanNotSwitchToBasicView());
        } else if (mh.hasDeclaredTypes()) {
            Window.alert((String)Constants.INSTANCE.CanNotSwitchToBasicViewDeclaredTypes());
        } else if (mh.hasFunctions()) {
            Window.alert((String)Constants.INSTANCE.CanNotSwitchToBasicViewFunctions());
        } else if (mh.hasRules()) {
            Window.alert((String)Constants.INSTANCE.CanNotSwitchToBasicViewRules());
        } else if (Window.confirm((String)Constants.INSTANCE.SwitchToGuidedModeForPackageEditing())) {
            this.basicEditorVersion(mh);
        }
    }

    private void showTypeQuestion(Widget w, final ModuleHeader mh, final boolean global, String headerMessage) {
        final FormStylePopup pop = new FormStylePopup(DroolsGuvnorImages.INSTANCE.Home(), Constants.INSTANCE.ChooseAFactType());
        pop.addRow((Widget)new HTML("<small><i>" + headerMessage + " </i></small>"));
        final ListBox factList = new ListBox();
        factList.addItem(Constants.INSTANCE.loadingList());
        ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
        moduleService.listTypesInPackage(this.conf.getUuid(), this.createGenericCallbackForListTypesInPackage(global, factList));
        InfoPopup info = new InfoPopup(Constants.INSTANCE.TypesInThePackage(), Constants.INSTANCE.IfNoTypesTip());
        pop.addAttribute(Constants.INSTANCE.ChooseClassType(), (Widget)this.createHorizontalPanel(new Widget[]{factList, info}));
        final TextBox globalName = new TextBox();
        if (global) {
            pop.addAttribute(Constants.INSTANCE.GlobalName(), (Widget)globalName);
        }
        final TextBox className = new TextBox();
        InfoPopup infoClass = new InfoPopup(Constants.INSTANCE.EnteringATypeClassName(), Constants.INSTANCE.EnterTypeNameTip());
        pop.addAttribute(Constants.INSTANCE.advancedClassName(), (Widget)this.createHorizontalPanel(new Widget[]{className, infoClass}));
        Button ok = new Button(Constants.INSTANCE.OK()){
            {
                super(x0);
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        String type;
                        String string = type = !"".equals(className.getText()) ? className.getText() : factList.getItemText(factList.getSelectedIndex());
                        if (!global) {
                            mh.getImports().add(new ModuleHeader.Import(type));
                            PackageHeaderWidget.this.doImports(mh);
                        } else {
                            if ("".equals(globalName.getText())) {
                                Window.alert((String)Constants.INSTANCE.YouMustEnterAGlobalVariableName());
                                return;
                            }
                            mh.getGlobals().add(new ModuleHeader.Global(type, globalName.getText()));
                            PackageHeaderWidget.this.doGlobals(mh);
                        }
                        PackageHeaderWidget.this.updateHeader(mh);
                        pop.hide();
                    }
                });
            }
        };
        Button cancel = new Button(Constants.INSTANCE.Cancel()){
            {
                super(x0);
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        pop.hide();
                    }
                });
            }
        };
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.add((Widget)ok);
        buttonPanel.add((Widget)cancel);
        pop.addAttribute("", (Widget)buttonPanel);
        pop.show();
    }

    private HorizontalPanel createHorizontalPanel(Widget ... wigets) {
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        for (Widget widget : wigets) {
            horizontalPanel.add(widget);
        }
        return horizontalPanel;
    }

    private GenericCallback<String[]> createGenericCallbackForListTypesInPackage(final boolean global, final ListBox factList) {
        return new GenericCallback<String[]>(){

            public void onSuccess(String[] list) {
                factList.clear();
                for (int i = 0; i < list.length; ++i) {
                    if (global) {
                        factList.addItem(list[i]);
                        continue;
                    }
                    if (list[i].indexOf(46) <= -1) continue;
                    factList.addItem(list[i]);
                }
            }
        };
    }

    private void updateHeader(ModuleHeader mh) {
        this.conf.setHeader(ModuleHeaderHelper.renderModuleHeader((ModuleHeader)mh));
    }

    private void doGlobals(ModuleHeader mh) {
        this.globalList.clear();
        for (ModuleHeader.Global g : mh.getGlobals()) {
            this.globalList.addItem(g.getType() + " [" + g.getName() + "]");
        }
    }

    private void doImports(ModuleHeader mh) {
        this.importList.clear();
        for (ModuleHeader.Import i : mh.getImports()) {
            this.importList.addItem(i.getType());
        }
    }
}

