/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.PackageBuilderWidget;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.widgets.drools.explorer.AbstractPackageDefinitionExplorerWidget;
import org.drools.guvnor.client.widgets.drools.explorer.ExplorerRenderMode;
import org.drools.guvnor.client.widgets.drools.explorer.PackageReadyCommand;

public class PackageResourceExplorerWidget
extends AbstractPackageDefinitionExplorerWidget {
    private boolean globalArea;
    private ModuleServiceAsync packageService;
    private String packageUUID;
    private static CreatePackageResourceWidgetBinder uiBinder = (CreatePackageResourceWidgetBinder)GWT.create(CreatePackageResourceWidgetBinder.class);
    @UiField
    protected TextBox txtName;
    @UiField
    protected TextBox txtDescription;
    @UiField
    protected Tree packageTree;
    @UiField
    protected Label labelName;
    @UiField
    protected Label labelDescr;

    public PackageResourceExplorerWidget(String packageUUID, String packageName, ClientFactory clientFactory, ExplorerRenderMode mode) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.globalArea = packageName.equals("globalArea");
        this.packageService = clientFactory.getModuleService();
        this.packageUUID = packageUUID;
        this.initializePackageTree();
        if (mode.equals((Object)ExplorerRenderMode.HIDE_NAME_AND_DESCRIPTION)) {
            this.txtName.setVisible(false);
            this.txtDescription.setVisible(false);
            this.labelName.setVisible(false);
            this.labelDescr.setVisible(false);
        }
    }

    private void initializePackageTree() {
        if (this.globalArea) {
            this.packageService.loadGlobalModule((AsyncCallback)new AsyncCallback<Module>(){

                public void onFailure(Throwable caught) {
                    ErrorPopup.showMessage((String)"Error listing Global Area information!");
                }

                public void onSuccess(Module result) {
                    PackageResourceExplorerWidget.this.populatePackageTree(result, null);
                }
            });
            this.packageService.listModules((AsyncCallback)new AsyncCallback<Module[]>(){

                public void onFailure(Throwable caught) {
                    ErrorPopup.showMessage((String)"Error listing package information!");
                }

                public void onSuccess(Module[] result) {
                    for (int i = 0; i < result.length; ++i) {
                        Module packageConfigData = result[i];
                        PackageResourceExplorerWidget.this.populatePackageTree(packageConfigData, null);
                    }
                }
            });
        } else {
            this.packageService.loadModule(this.packageUUID, (AsyncCallback)new AsyncCallback<Module>(){

                public void onFailure(Throwable caught) {
                    ErrorPopup.showMessage((String)"Error listing package information!");
                }

                public void onSuccess(Module result) {
                    PackageResourceExplorerWidget.this.populatePackageTree(result, null);
                }
            });
        }
        this.packageTree.setStyleName("category-explorer-Tree");
    }

    private void populatePackageTree(final Module packageConfigData, TreeItem rootItem) {
        final TreeItem packageItem = new TreeItem(packageConfigData.getName());
        packageItem.addItem(this.createTreeItem("LATEST", packageConfigData.getName(), PackageBuilderWidget.getDownloadLink(packageConfigData)));
        this.packageService.listSnapshots(packageConfigData.getName(), (AsyncCallback)new AsyncCallback<SnapshotInfo[]>(){

            public void onFailure(Throwable caught) {
                ErrorPopup.showMessage((String)"Error listing snapshots information!");
            }

            public void onSuccess(SnapshotInfo[] result) {
                for (int j = 0; j < result.length; ++j) {
                    final SnapshotInfo snapshotInfo = result[j];
                    ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
                    moduleService.loadModule(snapshotInfo.getUuid(), (AsyncCallback)new AsyncCallback<Module>(){

                        public void onFailure(Throwable caught) {
                            ErrorPopup.showMessage((String)"Error listing snapshots information!");
                        }

                        public void onSuccess(Module result) {
                            packageItem.addItem(PackageResourceExplorerWidget.this.createTreeItem(snapshotInfo.getName(), packageConfigData.getName(), PackageBuilderWidget.getDownloadLink(result)));
                        }
                    });
                }
            }
        });
        if (rootItem == null) {
            this.packageTree.addItem(packageItem);
        } else {
            rootItem.addItem(packageItem);
        }
    }

    private TreeItem createTreeItem(String label, String moduleName, String link) {
        TreeItem treeItem = new TreeItem((Widget)new RadioButton("pkgResourceGroup", label));
        treeItem.setUserObject((Object)new TreeItemData(moduleName, label, link));
        return treeItem;
    }

    @Override
    public void processSelectedPackage(PackageReadyCommand command) {
        try {
            TreeItem selectedPackageItem = this.packageTree.getSelectedItem();
            if (selectedPackageItem == null || selectedPackageItem.getChildCount() != 0) {
                throw new IllegalStateException(Constants.INSTANCE.NoPackageSeleced());
            }
            TreeItemData treeItem = (TreeItemData)selectedPackageItem.getUserObject();
            command.onSuccess(treeItem.moduleName, treeItem.label, treeItem.link, this.txtName.getText(), this.txtDescription.getText());
        }
        catch (Throwable t) {
            command.onFailure(t);
        }
    }

    private class TreeItemData {
        final String moduleName;
        final String label;
        final String link;

        TreeItemData(String moduleName, String label, String link) {
            this.moduleName = moduleName;
            this.label = label;
            this.link = link;
        }
    }

    static interface CreatePackageResourceWidgetBinder
    extends UiBinder<Widget, PackageResourceExplorerWidget> {
    }
}

