/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable;

import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.List;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.BindingTextBox;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.CEPWindowOperatorsDropdown;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.OperatorSelection;
import org.drools.guvnor.client.decisiontable.Validator;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.guvnor.client.resources.WizardCellListResources;
import org.drools.guvnor.client.resources.WizardResources;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.FactPatternsPageView;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.MinimumWidthCellList;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.cells.PatternCell;
import org.drools.ide.common.client.modeldriven.brl.HasCEPWindow;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

public class FactPatternsPageViewImpl
extends Composite
implements FactPatternsPageView {
    private FactPatternsPageView.Presenter presenter;
    private Validator validator;
    private Set<String> availableTypesSelections;
    private MinimumWidthCellList<String> availableTypesWidget;
    private List<Pattern52> chosenPatterns;
    private Pattern52 chosenPatternSelection;
    private Set<Pattern52> chosenPatternSelections;
    private MinimumWidthCellList<Pattern52> chosenPatternWidget;
    @UiField
    ScrollPanel availableTypesContainer;
    @UiField
    ScrollPanel chosenPatternsContainer;
    @UiField
    PushButton btnAdd;
    @UiField
    PushButton btnRemove;
    @UiField
    VerticalPanel patternDefinition;
    @UiField
    BindingTextBox txtBinding;
    @UiField
    HorizontalPanel bindingContainer;
    @UiField
    TextBox txtEntryPoint;
    @UiField
    CEPWindowOperatorsDropdown ddCEPWindow;
    @UiField
    HorizontalPanel cepWindowContainer;
    @UiField
    HorizontalPanel msgDuplicateBindings;
    @UiField(provided=true)
    PushButton btnMoveUp = new PushButton(AbstractImagePrototype.create((ImageResource)DroolsGuvnorImageResources.INSTANCE.shuffleUp()).createImage());
    @UiField(provided=true)
    PushButton btnMoveDown = new PushButton(AbstractImagePrototype.create((ImageResource)DroolsGuvnorImageResources.INSTANCE.shuffleDown()).createImage());
    private static FactPatternsPageWidgetBinder uiBinder = (FactPatternsPageWidgetBinder)GWT.create(FactPatternsPageWidgetBinder.class);

    public FactPatternsPageViewImpl(Validator validator) {
        this.validator = validator;
        this.availableTypesWidget = new MinimumWidthCellList(new TextCell(), WizardCellListResources.INSTANCE);
        this.chosenPatternWidget = new MinimumWidthCellList(new PatternCell(validator), WizardCellListResources.INSTANCE);
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.initialiseAvailableTypes();
        this.initialiseChosenPatterns();
        this.initialiseBinding();
        this.initialiseEntryPoint();
        this.initialiseCEPWindow();
        this.initialiseShufflers();
    }

    private void initialiseAvailableTypes() {
        this.availableTypesContainer.add(this.availableTypesWidget);
        this.availableTypesWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.availableTypesWidget.setMinimumWidth(275);
        Label lstEmpty = new Label(Constants.INSTANCE.DecisionTableWizardNoAvailablePatterns());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.availableTypesWidget.setEmptyListWidget((Widget)lstEmpty);
        final MultiSelectionModel selectionModel = new MultiSelectionModel();
        this.availableTypesWidget.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                FactPatternsPageViewImpl.this.availableTypesSelections = selectionModel.getSelectedSet();
                FactPatternsPageViewImpl.this.btnAdd.setEnabled(FactPatternsPageViewImpl.this.availableTypesSelections.size() > 0);
            }
        });
    }

    private void initialiseChosenPatterns() {
        this.chosenPatternsContainer.add(this.chosenPatternWidget);
        this.chosenPatternWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.chosenPatternWidget.setMinimumWidth(275);
        Label lstEmpty = new Label(Constants.INSTANCE.DecisionTableWizardNoChosenPatterns());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.chosenPatternWidget.setEmptyListWidget((Widget)lstEmpty);
        final MultiSelectionModel selectionModel = new MultiSelectionModel();
        this.chosenPatternWidget.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                FactPatternsPageViewImpl.this.chosenPatternSelections = selectionModel.getSelectedSet();
                this.chosenTypesSelected(FactPatternsPageViewImpl.this.chosenPatternSelections);
            }

            private void chosenTypesSelected(Set<Pattern52> ps) {
                FactPatternsPageViewImpl.this.btnRemove.setEnabled(true);
                if (ps.size() == 1) {
                    FactPatternsPageViewImpl.this.chosenPatternSelection = ps.iterator().next();
                    FactPatternsPageViewImpl.this.patternDefinition.setVisible(true);
                    FactPatternsPageViewImpl.this.validateBinding();
                    FactPatternsPageViewImpl.this.txtBinding.setEnabled(true);
                    FactPatternsPageViewImpl.this.txtBinding.setText(FactPatternsPageViewImpl.this.chosenPatternSelection.getBoundName());
                    FactPatternsPageViewImpl.this.txtEntryPoint.setEnabled(true);
                    FactPatternsPageViewImpl.this.txtEntryPoint.setText(FactPatternsPageViewImpl.this.chosenPatternSelection.getEntryPointName());
                    FactPatternsPageViewImpl.this.enableMoveUpButton();
                    FactPatternsPageViewImpl.this.enableMoveDownButton();
                    if (FactPatternsPageViewImpl.this.presenter.isPatternEvent(FactPatternsPageViewImpl.this.chosenPatternSelection)) {
                        FactPatternsPageViewImpl.this.ddCEPWindow.setCEPWindow((HasCEPWindow)FactPatternsPageViewImpl.this.chosenPatternSelection);
                        FactPatternsPageViewImpl.this.cepWindowContainer.setVisible(true);
                    } else {
                        FactPatternsPageViewImpl.this.cepWindowContainer.setVisible(false);
                    }
                } else {
                    FactPatternsPageViewImpl.this.chosenPatternSelection = null;
                    FactPatternsPageViewImpl.this.patternDefinition.setVisible(false);
                    FactPatternsPageViewImpl.this.txtBinding.setEnabled(false);
                    FactPatternsPageViewImpl.this.txtBinding.setText("");
                    FactPatternsPageViewImpl.this.txtEntryPoint.setEnabled(false);
                    FactPatternsPageViewImpl.this.txtEntryPoint.setText("");
                    FactPatternsPageViewImpl.this.btnMoveUp.setEnabled(false);
                    FactPatternsPageViewImpl.this.btnMoveDown.setEnabled(false);
                    FactPatternsPageViewImpl.this.cepWindowContainer.setVisible(false);
                }
            }
        });
    }

    private void validateBinding() {
        if (this.validator.isPatternBindingUnique(this.chosenPatternSelection)) {
            this.bindingContainer.setStyleName(WizardResources.INSTANCE.style().wizardDTableFieldContainerValid());
        } else {
            this.bindingContainer.setStyleName(WizardResources.INSTANCE.style().wizardDTableFieldContainerInvalid());
        }
    }

    private void enableMoveUpButton() {
        if (this.chosenPatterns == null || this.chosenPatternSelection == null) {
            this.btnMoveUp.setEnabled(false);
            return;
        }
        int index = this.chosenPatterns.indexOf(this.chosenPatternSelection);
        this.btnMoveUp.setEnabled(index > 0);
    }

    private void enableMoveDownButton() {
        if (this.chosenPatterns == null || this.chosenPatternSelection == null) {
            this.btnMoveDown.setEnabled(false);
            return;
        }
        int index = this.chosenPatterns.indexOf(this.chosenPatternSelection);
        this.btnMoveDown.setEnabled(index < this.chosenPatterns.size() - 1);
    }

    private void initialiseBinding() {
        this.txtBinding.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String binding = FactPatternsPageViewImpl.this.txtBinding.getText();
                FactPatternsPageViewImpl.this.chosenPatternSelection.setBoundName(binding);
                FactPatternsPageViewImpl.this.presenter.stateChanged();
                FactPatternsPageViewImpl.this.validateBinding();
            }
        });
    }

    private void initialiseEntryPoint() {
        this.txtEntryPoint.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (FactPatternsPageViewImpl.this.chosenPatternSelection == null) {
                    return;
                }
                FactPatternsPageViewImpl.this.chosenPatternSelection.setEntryPointName((String)event.getValue());
            }
        });
    }

    private void initialiseCEPWindow() {
        this.ddCEPWindow.addValueChangeHandler(new ValueChangeHandler<OperatorSelection>(){

            public void onValueChange(ValueChangeEvent<OperatorSelection> event) {
                if (FactPatternsPageViewImpl.this.chosenPatternSelection == null) {
                    return;
                }
                OperatorSelection selection = (OperatorSelection)event.getValue();
                String selected = selection.getValue();
                FactPatternsPageViewImpl.this.chosenPatternSelection.getWindow().setOperator(selected);
            }
        });
    }

    private void initialiseShufflers() {
        this.btnMoveUp.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int index = FactPatternsPageViewImpl.this.chosenPatterns.indexOf(FactPatternsPageViewImpl.this.chosenPatternSelection);
                Pattern52 p = (Pattern52)FactPatternsPageViewImpl.this.chosenPatterns.remove(index);
                FactPatternsPageViewImpl.this.chosenPatterns.add(index - 1, p);
                FactPatternsPageViewImpl.this.setChosenPatterns(FactPatternsPageViewImpl.this.chosenPatterns);
                FactPatternsPageViewImpl.this.presenter.setConditionPatterns(FactPatternsPageViewImpl.this.chosenPatterns);
            }
        });
        this.btnMoveDown.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int index = FactPatternsPageViewImpl.this.chosenPatterns.indexOf(FactPatternsPageViewImpl.this.chosenPatternSelection);
                Pattern52 p = (Pattern52)FactPatternsPageViewImpl.this.chosenPatterns.remove(index);
                FactPatternsPageViewImpl.this.chosenPatterns.add(index + 1, p);
                FactPatternsPageViewImpl.this.setChosenPatterns(FactPatternsPageViewImpl.this.chosenPatterns);
                FactPatternsPageViewImpl.this.presenter.setConditionPatterns(FactPatternsPageViewImpl.this.chosenPatterns);
            }
        });
    }

    @Override
    public void setAvailableFactTypes(List<String> types) {
        this.availableTypesWidget.setRowCount(types.size(), true);
        this.availableTypesWidget.setRowData(types);
    }

    @Override
    public void setChosenPatterns(List<Pattern52> types) {
        this.chosenPatterns = types;
        this.chosenPatternWidget.setRowCount(types.size(), true);
        this.chosenPatternWidget.setRowData(types);
        this.enableMoveUpButton();
        this.enableMoveDownButton();
        this.presenter.stateChanged();
    }

    @Override
    public void setPresenter(FactPatternsPageView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setArePatternBindingsUnique(boolean arePatternBindingsUnique) {
        this.msgDuplicateBindings.setVisible(!arePatternBindingsUnique);
        this.chosenPatternWidget.redraw();
    }

    @UiHandler(value={"btnAdd"})
    public void btnAddClick(ClickEvent event) {
        for (String type : this.availableTypesSelections) {
            Pattern52 pattern = new Pattern52();
            pattern.setFactType(type);
            this.chosenPatterns.add(pattern);
        }
        this.setChosenPatterns(this.chosenPatterns);
        this.presenter.setConditionPatterns(this.chosenPatterns);
        this.presenter.stateChanged();
    }

    @UiHandler(value={"btnRemove"})
    public void btnRemoveClick(ClickEvent event) {
        for (Pattern52 pattern : this.chosenPatternSelections) {
            this.chosenPatterns.remove(pattern);
            this.presenter.signalRemovalOfPattern(pattern);
        }
        this.chosenPatternSelections.clear();
        this.setChosenPatterns(this.chosenPatterns);
        this.presenter.setConditionPatterns(this.chosenPatterns);
        this.presenter.stateChanged();
        this.txtBinding.setText("");
        this.txtBinding.setEnabled(false);
        this.txtEntryPoint.setText("");
        this.txtEntryPoint.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.patternDefinition.setVisible(false);
    }

    static interface FactPatternsPageWidgetBinder
    extends UiBinder<Widget, FactPatternsPageViewImpl> {
    }
}

