/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.WorkItemService;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.ruleeditor.workitem.AssetWorkDefinitionsLoader;
import org.drools.guvnor.server.ruleeditor.workitem.ConfigFileWorkDefinitionsLoader;
import org.drools.guvnor.server.ruleeditor.workitem.WorkitemDefinitionElementsManager;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.ide.common.shared.workitems.PortableBooleanParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableFloatParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableIntegerParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableObjectParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableStringParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableWorkDefinition;
import org.drools.process.core.ParameterDefinition;
import org.drools.process.core.WorkDefinition;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.datatype.impl.type.BooleanDataType;
import org.drools.process.core.datatype.impl.type.EnumDataType;
import org.drools.process.core.datatype.impl.type.FloatDataType;
import org.drools.process.core.datatype.impl.type.IntegerDataType;
import org.drools.process.core.datatype.impl.type.ListDataType;
import org.drools.process.core.datatype.impl.type.ObjectDataType;
import org.drools.process.core.datatype.impl.type.StringDataType;
import org.jboss.seam.security.annotations.LoggedIn;
import org.jbpm.process.workitem.WorkDefinitionImpl;

public class WorkItemServiceImplementation
implements WorkItemService {
    private static final LoggingHelper log = LoggingHelper.getLogger(WorkItemService.class);
    @Inject
    private RepositoryAssetService repositoryAssetService;

    @Override
    public Map<String, String> loadWorkitemDefinitionElementData() throws DetailedSerializationException {
        try {
            return WorkitemDefinitionElementsManager.getInstance().getElements();
        }
        catch (IOException ex) {
            log.error("Error loading Workitem Definition Elements", (Throwable)ex);
            throw new DetailedSerializationException("Error loading Workitem Definition Elements", "View server logs for more information");
        }
    }

    @Override
    @LoggedIn
    public Set<PortableWorkDefinition> loadWorkItemDefinitions(String packageUUID) throws DetailedSerializationException {
        HashMap<String, WorkDefinition> workDefinitions = new HashMap<String, WorkDefinition>();
        try {
            AssetWorkDefinitionsLoader loader = new AssetWorkDefinitionsLoader(this.repositoryAssetService, packageUUID);
            Map<String, WorkDefinition> assetWorkDefinitions = loader.getWorkDefinitions();
            for (Map.Entry<String, WorkDefinition> entry : assetWorkDefinitions.entrySet()) {
                if (workDefinitions.containsKey(entry.getKey())) continue;
                workDefinitions.put(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            log.error("Error loading Workitem Definitions for package [" + packageUUID + "]", (Throwable)e);
            throw new DetailedSerializationException("Error loading Workitem Definitions for package [" + packageUUID + "]", "View server logs for more information");
        }
        try {
            Map<String, WorkDefinition> configuredWorkDefinitions = ConfigFileWorkDefinitionsLoader.getInstance().getWorkDefinitions();
            for (Map.Entry<String, WorkDefinition> entry : configuredWorkDefinitions.entrySet()) {
                if (workDefinitions.containsKey(entry.getKey())) continue;
                workDefinitions.put(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            log.error("Error loading Workitem Definitions from configuration file", (Throwable)e);
            throw new DetailedSerializationException("Error loading Workitem Definitions from configuration file", "View server logs for more information");
        }
        HashSet<PortableWorkDefinition> workItems = new HashSet<PortableWorkDefinition>();
        for (Map.Entry<String, Object> entry : workDefinitions.entrySet()) {
            PortableWorkDefinition wid = new PortableWorkDefinition();
            WorkDefinitionImpl wd = (WorkDefinitionImpl)entry.getValue();
            wid.setName(wd.getName());
            wid.setDisplayName(wd.getDisplayName());
            wid.setParameters(this.convertWorkItemParameters(((WorkDefinition)entry.getValue()).getParameters()));
            wid.setResults(this.convertWorkItemParameters(((WorkDefinition)entry.getValue()).getResults()));
            workItems.add(wid);
        }
        return workItems;
    }

    private Set<PortableParameterDefinition> convertWorkItemParameters(Set<ParameterDefinition> parameters) {
        HashSet<PortableParameterDefinition> pps = new HashSet<PortableParameterDefinition>();
        for (ParameterDefinition pd : parameters) {
            DataType pdt = pd.getType();
            PortableBooleanParameterDefinition ppd = null;
            if (pdt instanceof BooleanDataType) {
                ppd = new PortableBooleanParameterDefinition();
            } else if (pdt instanceof FloatDataType) {
                ppd = new PortableFloatParameterDefinition();
            } else if (pdt instanceof IntegerDataType) {
                ppd = new PortableIntegerParameterDefinition();
            } else if (!(pdt instanceof ListDataType)) {
                if (pdt instanceof ObjectDataType) {
                    ppd = new PortableObjectParameterDefinition();
                    PortableObjectParameterDefinition oppd = (PortableObjectParameterDefinition)ppd;
                    ObjectDataType odt = (ObjectDataType)pdt;
                    oppd.setClassName(odt.getClassName());
                } else if (pd.getType() instanceof StringDataType) {
                    ppd = new PortableStringParameterDefinition();
                } else if (pdt instanceof EnumDataType) {
                    // empty if block
                }
            }
            if (ppd == null) continue;
            ppd.setName(pd.getName());
            pps.add((PortableParameterDefinition)ppd);
        }
        return pps;
    }
}

