/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.server.contenthandler.IHasCustomValidator;
import org.drools.guvnor.server.contenthandler.PlainTextContentHandler;
import org.drools.ide.common.server.util.DataEnumLoader;
import org.drools.repository.AssetItem;

public class EnumerationContentHandler
extends PlainTextContentHandler
implements IHasCustomValidator {
    public BuilderResult validateAsset(AssetItem asset) {
        String content = asset.getContent();
        DataEnumLoader loader = new DataEnumLoader(content);
        if (!loader.hasErrors()) {
            return new BuilderResult();
        }
        ArrayList<BuilderResultLine> errors = new ArrayList<BuilderResultLine>();
        List errs = loader.getErrors();
        for (String message : errs) {
            BuilderResultLine result = new BuilderResultLine().setAssetName(asset.getName()).setAssetFormat(asset.getFormat()).setUuid(asset.getUUID()).setMessage(message);
            errors.add(result);
        }
        BuilderResult result = new BuilderResult();
        result.addLines(errors);
        return result;
    }

    public boolean validate(AssetItem assetItem) {
        return !this.validateAsset(assetItem).hasLines();
    }

    public String getFormat() {
        return "enumeration";
    }
}

