/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.converters.decisiontable.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.guvnor.client.rpc.ConversionResult;
import org.drools.guvnor.server.converters.decisiontable.builders.GuidedDecisionTableSourceBuilder;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.MetadataCol52;

public class GuidedDecisionTableMetadataBuilder
implements GuidedDecisionTableSourceBuilder {
    private int headerRow;
    private int headerCol;
    private Map<Integer, String> definitions = new HashMap<Integer, String>();
    private List<DTCellValue52> values = new ArrayList<DTCellValue52>();
    private ConversionResult conversionResult;

    public GuidedDecisionTableMetadataBuilder(int row, int column, ConversionResult conversionResult) {
        this.headerRow = row;
        this.headerCol = column;
        this.conversionResult = conversionResult;
    }

    @Override
    public void populateDecisionTable(GuidedDecisionTable52 dtable) {
        MetadataCol52 column = new MetadataCol52();
        String value = this.definitions.get(this.headerCol);
        column.setHideColumn(true);
        column.setMetadata(value);
        dtable.getMetadataCols().add(column);
        this.addColumnData(dtable, (DTColumnConfig52)column);
    }

    private void addColumnData(GuidedDecisionTable52 dtable, DTColumnConfig52 column) {
        int rowCount = this.values.size();
        int iColIndex = dtable.getExpandedColumns().indexOf(column);
        for (int iRow = 0; iRow < rowCount; ++iRow) {
            List rowData = (List)dtable.getData().get(iRow);
            rowData.add(iColIndex, this.values.get(iRow));
        }
    }

    public void addTemplate(int row, int column, String content) {
        if (this.definitions.containsKey(column)) {
            String message = "Internal error: Can't have a code snippet added twice to one spreadsheet column.";
            this.conversionResult.addMessage("Internal error: Can't have a code snippet added twice to one spreadsheet column.", ConversionResult.ConversionMessageType.ERROR);
        }
        this.definitions.put(column, content.trim());
    }

    public void addCellValue(int row, int column, String value) {
        String content = this.definitions.get(column);
        if (content == null) {
            String message = "No code snippet for METADATA in cell " + RuleSheetParserUtil.rc2name((int)(this.headerRow + 2), (int)this.headerCol);
            this.conversionResult.addMessage(message, ConversionResult.ConversionMessageType.ERROR);
        }
        DTCellValue52 dcv = new DTCellValue52(value);
        this.values.add(dcv);
    }

    public ActionType.Code getActionTypeCode() {
        return ActionType.Code.METADATA;
    }

    public void clearValues() {
        this.values.clear();
    }

    public boolean hasValues() {
        return this.values.size() > 0;
    }

    public String getResult() {
        throw new UnsupportedOperationException("GuidedDecisionTableMetadataBuilder does not return DRL.");
    }
}

