/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.shared.simulation;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.LinkedHashMap;
import java.util.Map;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.guvnor.shared.simulation.SimulationPathModel;

@XStreamAlias(value="SimulationModel")
public class SimulationModel
implements PortableObject {
    private Map<String, SimulationPathModel> paths = new LinkedHashMap<String, SimulationPathModel>();

    public static SimulationModel createNew() {
        SimulationModel simulation = new SimulationModel();
        simulation.addPath(SimulationPathModel.createNew());
        SimulationModel.todoCreateTestdata(simulation);
        return simulation;
    }

    private static void todoCreateTestdata(SimulationModel simulation) {
        simulation.addPath(SimulationPathModel.createNew());
        simulation.addPath(SimulationPathModel.createNew());
    }

    public Map<String, SimulationPathModel> getPaths() {
        return this.paths;
    }

    public int getPathsSize() {
        return this.paths.size();
    }

    public void addPath(SimulationPathModel path) {
        if (path.getName() == null) {
            this.generatePathName(path);
        }
        if (this.paths.containsKey(path.getName())) {
            throw new IllegalArgumentException("The simulation path's name (" + path.getName() + ") is not unique.");
        }
        this.paths.put(path.getName(), path);
    }

    public void removePath(SimulationPathModel path) {
        String name = path.getName();
        if (!this.paths.containsKey(name)) {
            throw new IllegalArgumentException("The simulation path's name (" + name + ") is not known. It probably changed while it was in the Map.");
        }
        this.paths.remove(name);
    }

    private void generatePathName(SimulationPathModel path) {
        String pathName;
        int index = 0;
        do {
            pathName = "path_" + index;
            ++index;
        } while (this.paths.containsKey(pathName));
        path.setName(pathName);
    }

    public long getMaximumDistanceMillis() {
        long maximumDistanceMillis = 0L;
        for (SimulationPathModel path : this.paths.values()) {
            long distanceMillis = path.getMaximumDistanceMillis();
            if (maximumDistanceMillis >= distanceMillis) continue;
            maximumDistanceMillis = distanceMillis;
        }
        return maximumDistanceMillis;
    }
}

