/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server.helpers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.plexus.util.IOUtil;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPutHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpPutHelper.class);
    @Inject
    private GuvnorM2Repository m2RepoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletInputStream inputStream = request.getInputStream();
        OutputStream outputStream = null;
        int status = 200;
        try {
            String pathInfo = request.getPathInfo();
            if (pathInfo == null) {
                response.sendError(404);
                return;
            }
            pathInfo = URLDecoder.decode(pathInfo, "UTF-8");
            File mavenRootDir = new File(this.m2RepoService.getM2RepositoryRootDir());
            String canonicalDirPath = mavenRootDir.getCanonicalPath() + File.separator;
            String canonicalEntryPath = new File(mavenRootDir, pathInfo).getCanonicalPath();
            if (!canonicalEntryPath.startsWith(canonicalDirPath)) {
                response.sendError(404);
                return;
            }
            pathInfo = canonicalEntryPath.substring(canonicalDirPath.length());
            File file = new File(mavenRootDir, pathInfo);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
                status = 201;
            }
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            response.setStatus(status);
            return;
        }
        catch (FileNotFoundException e) {
            log.error(e.toString(), (Throwable)e);
            return;
        }
        catch (IOException e) {
            log.error(e.toString(), (Throwable)e);
            return;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

