/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.ext.uberfire.social.activities.model.DefaultTypes;
import org.ext.uberfire.social.activities.model.SocialEventType;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class SocialActivitiesEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static SocialActivitiesEvent dummyLastWrittenMarker;
    private Date timestamp;
    private SocialUser socialUser;
    private String type;
    private String linkLabel;
    private String linkTarget;
    private Map<String, String> linkParams = new HashMap<String, String>();
    private LINK_TYPE linkType = LINK_TYPE.VFS;
    private String[] additionalInfo;
    private String description;

    public SocialActivitiesEvent() {
    }

    public SocialActivitiesEvent(SocialUser socialUser, String type, Date timestamp) {
        this.socialUser = socialUser;
        this.type = type;
        this.timestamp = timestamp;
    }

    public SocialActivitiesEvent(SocialUser socialUser, SocialEventType type, Date timestamp) {
        this.socialUser = socialUser;
        this.type = type.name();
        this.timestamp = timestamp;
    }

    public SocialActivitiesEvent withLink(String linklabel, String linkTarget) {
        this.linkLabel = linklabel;
        this.linkTarget = linkTarget;
        return this;
    }

    public SocialActivitiesEvent withLink(String linklabel, String linkTarget, LINK_TYPE linkType) {
        this.linkLabel = linklabel;
        this.linkTarget = linkTarget;
        this.linkType = linkType;
        return this;
    }

    public SocialActivitiesEvent withDescription(String description) {
        this.description = description;
        return this;
    }

    public SocialActivitiesEvent withParam(String name, String value) {
        this.linkParams.put(name, value);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasLink() {
        return this.linkLabel != null;
    }

    public String getLinkLabel() {
        return this.linkLabel;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public LINK_TYPE getLinkType() {
        return this.linkType;
    }

    public boolean isVFSLink() {
        return this.linkType == LINK_TYPE.VFS;
    }

    public SocialActivitiesEvent withAdicionalInfo(String ... adicionalInfo) {
        this.additionalInfo = adicionalInfo;
        return this;
    }

    public boolean hasAdicionalInfo() {
        return this.additionalInfo != null;
    }

    public String[] getAdditionalInfo() {
        return this.additionalInfo;
    }

    public String getAdicionalInfos() {
        String adicionalInfos = "";
        for (String info : this.additionalInfo) {
            adicionalInfos = adicionalInfos + info + " ";
        }
        if (!adicionalInfos.isEmpty()) {
            return adicionalInfos.substring(0, adicionalInfos.length() - 1);
        }
        return adicionalInfos;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public SocialUser getSocialUser() {
        return this.socialUser;
    }

    public Map<String, String> getLinkParams() {
        return this.linkParams;
    }

    public String toString() {
        return "SocialActivitiesEvent{timestamp=" + this.timestamp + ", user=" + this.socialUser.getUserName() + ", type=" + this.type + ", add=" + this.getAdicionalInfos() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SocialActivitiesEvent)) {
            return false;
        }
        SocialActivitiesEvent that = (SocialActivitiesEvent)o;
        if (this.socialUser != null ? !this.socialUser.equals(that.socialUser) : that.socialUser != null) {
            return false;
        }
        if (this.timestamp != null ? !this.compareDates(that) : that.timestamp != null) {
            return false;
        }
        return this.type.equals(that.type);
    }

    private boolean compareDates(SocialActivitiesEvent that) {
        if (that.getTimestamp() == null || that.getTimestamp() == null) {
            return false;
        }
        long difference = this.getTimestamp().getTime() - that.getTimestamp().getTime();
        return difference > -1000L && difference < 1000L;
    }

    public int hashCode() {
        int result = this.timestamp != null ? this.timestamp.hashCode() : 0;
        result = 31 * result + (this.socialUser != null ? this.socialUser.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public boolean isDummyEvent() {
        return this.type != null && this.type.equals(DefaultTypes.DUMMY_EVENT.name());
    }

    public static SocialActivitiesEvent getDummyLastWrittenMarker() {
        if (dummyLastWrittenMarker == null) {
            dummyLastWrittenMarker = new SocialActivitiesEvent(new SocialUser("DUMMY"), DefaultTypes.DUMMY_EVENT, new Date());
        }
        return dummyLastWrittenMarker;
    }

    public String getType() {
        return this.type;
    }

    public void updateSocialUser(SocialUser updatedSocialUser) {
        this.socialUser = updatedSocialUser;
    }

    public static enum LINK_TYPE {
        VFS,
        CUSTOM;

    }
}

