/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.base.ClassObjectType;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.FromNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.PropertySpecificUtil;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Pattern;
import org.drools.rule.TypeDeclaration;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;

public abstract class AbstractTerminalNode
extends BaseNode
implements TerminalNode,
Externalizable {
    private LeftTupleSource tupleSource;
    private long declaredMask;
    private long inferredMask;
    private long negativeMask;

    public AbstractTerminalNode() {
    }

    public AbstractTerminalNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, LeftTupleSource source) {
        super(id, partitionId, partitionsEnabled);
        this.tupleSource = source;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.declaredMask = in.readLong();
        this.inferredMask = in.readLong();
        this.negativeMask = in.readLong();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.tupleSource);
        out.writeLong(this.declaredMask);
        out.writeLong(this.inferredMask);
        out.writeLong(this.negativeMask);
    }

    public void initDeclaredMask(BuildContext context) {
        if (!(this.unwrapTupleSource() instanceof LeftInputAdapterNode)) {
            this.setDeclaredMask(-1L);
            return;
        }
        Pattern pattern = context.getLastBuiltPatterns()[0];
        ObjectType objectType = pattern.getObjectType();
        if (!(objectType instanceof ClassObjectType)) {
            this.setDeclaredMask(-1L);
            return;
        }
        Class<?> objectClass = ((ClassObjectType)objectType).getClassType();
        TypeDeclaration typeDeclaration = context.getRuleBase().getTypeDeclaration(objectClass);
        if (typeDeclaration == null || !typeDeclaration.isPropertyReactive()) {
            this.setDeclaredMask(-1L);
        } else {
            List<String> settableProperties = PropertySpecificUtil.getSettableProperties(context.getRuleBase(), objectClass);
            this.setDeclaredMask(PropertySpecificUtil.calculatePositiveMask(pattern.getListenedProperties(), settableProperties));
            this.setNegativeMask(PropertySpecificUtil.calculateNegativeMask(pattern.getListenedProperties(), settableProperties));
        }
    }

    public void initInferredMask() {
        LeftTupleSource leftTupleSource = this.unwrapTupleSource();
        if (leftTupleSource instanceof LeftInputAdapterNode && ((LeftInputAdapterNode)leftTupleSource).getParentObjectSource() instanceof AlphaNode) {
            AlphaNode alphaNode = (AlphaNode)((LeftInputAdapterNode)leftTupleSource).getParentObjectSource();
            this.setInferredMask(alphaNode.updateMask(this.getDeclaredMask()));
        } else {
            this.setInferredMask(this.getDeclaredMask());
        }
        this.setInferredMask(this.getInferredMask() & -1L - this.getNegativeMask());
    }

    public LeftTupleSource unwrapTupleSource() {
        return this.tupleSource instanceof FromNode ? ((FromNode)this.tupleSource).getLeftTupleSource() : this.tupleSource;
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleSource.doModifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory, this, this.getLeftInputOtnId(), this.inferredMask);
    }

    public LeftTupleSource getLeftTupleSource() {
        return this.tupleSource;
    }

    public long getDeclaredMask() {
        return this.declaredMask;
    }

    public long getInferredMask() {
        return this.inferredMask;
    }

    public void setDeclaredMask(long mask) {
        this.declaredMask = mask;
    }

    public void setInferredMask(long mask) {
        this.inferredMask = mask;
    }

    public long getNegativeMask() {
        return this.negativeMask;
    }

    public void setNegativeMask(long mask) {
        this.negativeMask = mask;
    }
}

